/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.api.OdaDataSetAdapterTest;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.model.util.SchemaConversionUtil;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueDefinition;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.ecore.EObject;

public class ReportParameterAdapterTest
extends BaseTestCase {
    public void testToODADataSetParamWithReportParam() throws Exception {
        this.openDesign("OdaDataSetConvertReportParamTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setDataSetParameters(SchemaConversionUtil.convertToAdapterParameters((DataSetParameters)setDesign.getParameters()));
        this.saveDesignValuesToFile(values);
        ReportParameterAdapterTest.assertTrue((boolean)this.compareTextFile("DataSetParamWithReportParam_golden.xml"));
    }

    public void testToROMDataSetParamWithReportParam() throws Exception {
        this.openDesign("OdaDataSetConvertReportParamTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DataSetParameters params = setDesign.getParameters();
        ParameterDefinition param = (ParameterDefinition)params.getParameterDefinitions().get(0);
        this.updateParameterDefinition1(param);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.compareTextFile("OdaDataSetConvertReportParamTest_golden.xml");
        this.openDesign("OdaDataSetConvertReportParamTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DesignUtil.validateObject((EObject)setDesign);
        params = setDesign.getParameters();
        param = (ParameterDefinition)params.getParameterDefinitions().get(0);
        this.updateParameterDefinition1(param);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.compareTextFile("OdaDataSetConvertReportParamTest_1_golden.xml");
        this.openDesign("OdaDataSetConvertReportParamTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        params = setDesign.getParameters();
        param = (ParameterDefinition)params.getParameterDefinitions().get(0);
        this.updateParameterDefinition2(param);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.compareTextFile("OdaDataSetConvertReportParamTest_2_golden.xml");
        this.openDesign("OdaDataSetConvertReportParamTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        Iterator paramHandles = setHandle.parametersIterator();
        OdaDataSetParameterHandle paramHandle = (OdaDataSetParameterHandle)paramHandles.next();
        paramHandle.setIsOutput(true);
        paramHandle.setIsInput(false);
        paramHandle.setDefaultValue("not updated default value");
        String reportParamName = paramHandle.getParamName();
        ScalarParameterHandle reportParam = (ScalarParameterHandle)this.designHandle.findParameter(reportParamName);
        reportParam.setPromptText("not updated prompt text");
        reportParam.setDefaultValue("not updated default value");
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.compareTextFile("OdaDataSetConvertReportParamTest_3_golden.xml");
        this.openDesign("OdaDataSetConvertReportParamTest_2.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("sqlSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        params = setDesign.getParameters();
        param = (ParameterDefinition)params.getParameterDefinitions().get(0);
        this.updateParameterDefinition3(param);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.checkUpdateParameterDefinition3(param);
        this.openDesign("OdaDataSetConvertReportParamTest_2.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("sqlSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        params = setDesign.getParameters();
        param = (ParameterDefinition)params.getParameterDefinitions().get(0);
        this.updateParameterDefinition3(param);
        DataSetHandle dataSetToDelete = this.designHandle.findDataSet("Data Set");
        dataSetToDelete.drop();
        dataSetToDelete = this.designHandle.findDataSet("Data Set");
        ReportParameterAdapterTest.assertNull((Object)dataSetToDelete);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.checkUpdateParameterDefinition3(param);
        dataSetToDelete = this.designHandle.findDataSet("Data Set");
        ReportParameterAdapterTest.assertNull((Object)dataSetToDelete);
    }

    private void updateParameterDefinition1(ParameterDefinition param) {
        DataElementAttributes dataAttrs = param.getAttributes();
        dataAttrs.setNullability(ElementNullability.get((int)2));
        DataElementUIHints dataUIHints = DesignFactory.eINSTANCE.createDataElementUIHints();
        dataAttrs.setUiHints(dataUIHints);
        dataUIHints.setDisplayName("new prompt text for report param 1");
        dataUIHints.setDisplayNameKey("newPromptTextKeyParam1");
        dataUIHints.setDescription("new help text for report param 1");
        dataUIHints.setDescriptionKey("newHelpTextKeyParam1");
        InputParameterAttributes paramAttrs = param.getInputAttributes();
        InputElementAttributes elementAttrs = paramAttrs.getElementAttributes();
        elementAttrs.setDefaultScalarValue("new default value for report param 1");
        elementAttrs.setOptional(true);
        elementAttrs.setMasksValue(false);
        ScalarValueChoices chocies = DesignFactory.eINSTANCE.createScalarValueChoices();
        ScalarValueDefinition choice = DesignFactory.eINSTANCE.createScalarValueDefinition();
        choice.setDisplayName("new choice display name 1");
        choice.setDisplayNameKey("newChoiceDisplayName1");
        choice.setValue("new choice value 1");
        chocies.getScalarValues().add((Object)choice);
        elementAttrs.setStaticValueChoices(chocies);
        DynamicValuesQuery dynamicValue = DesignFactory.eINSTANCE.createDynamicValuesQuery();
        dynamicValue.setValueColumn("new value column 1");
        dynamicValue.setDisplayNameColumn("new lable column 1");
        dynamicValue.setDataSetDesign(OdaDataSetAdapterTest.createDataSetDesign());
        elementAttrs.setDynamicValueChoices(dynamicValue);
        InputElementUIHints elementUIHints = DesignFactory.eINSTANCE.createInputElementUIHints();
        elementUIHints.setPromptStyle(InputPromptControlStyle.get((int)4));
        elementUIHints.setAutoSuggestThreshold(111);
        elementAttrs.setUiHints(elementUIHints);
    }

    private void updateParameterDefinition2(ParameterDefinition param) {
        param.setInOutMode(ParameterMode.get((int)1));
    }

    private void updateParameterDefinition3(ParameterDefinition param) {
        DynamicValuesQuery dynamicValue = param.getInputAttributes().getElementAttributes().getDynamicValueChoices();
        if (dynamicValue == null) {
            dynamicValue = DesignFactory.eINSTANCE.createDynamicValuesQuery();
            dynamicValue.setValueColumn("new value column 1");
            dynamicValue.setDisplayNameColumn("new lable column 1");
            dynamicValue.setDataSetDesign(OdaDataSetAdapterTest.createDataSetDesign());
            param.getInputAttributes().getElementAttributes().setDynamicValueChoices(dynamicValue);
        }
        DataSetDesign setDesign = dynamicValue.getDataSetDesign();
        setDesign.setDisplayName("new display name");
        setDesign.setQueryText("select * from CLASSICMODELS.CUSTOMERS");
    }

    private void checkUpdateParameterDefinition3(ParameterDefinition param) {
        DynamicValuesQuery dynamicValue = param.getInputAttributes().getElementAttributes().getDynamicValueChoices();
        DataSetDesign setDesign = dynamicValue.getDataSetDesign();
        ReportParameterAdapterTest.assertEquals((String)"myDataSet1", (String)setDesign.getName());
        ReportParameterAdapterTest.assertEquals((String)"new display name", (String)setDesign.getDisplayName());
        ReportParameterAdapterTest.assertEquals((String)"select * from CLASSICMODELS.CUSTOMERS", (String)setDesign.getQueryText());
    }
}

