/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class DataIDTest
extends EngineCase {
    static final String INPUT = "dataID.rptdesign";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testDataIDFromReport() throws EngineException, IOException {
        String tmp_type;
        String inputFile = this.genInputFile(INPUT);
        IReportRunnable reportRunnable = this.engine.openReportDesign(inputFile);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat("html");
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)ostream);
        options.setEnableMetadata(true);
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(reportRunnable);
        task.setRenderOption((IRenderOption)options);
        task.run();
        DataIDTest.assertTrue((task.getErrors().size() <= 0 ? 1 : 0) != 0);
        task.close();
        ArrayList<String> iids = new ArrayList<String>();
        String content = ostream.toString("utf-8");
        ostream.close();
        Pattern typePattern = Pattern.compile("(element_type=\"TABLE\".*iid=\".*\")");
        Matcher matcher = typePattern.matcher(content);
        String strIid = null;
        while (matcher.find()) {
            tmp_type = null;
            tmp_type = matcher.group(0);
            strIid = tmp_type.substring(tmp_type.indexOf("iid"));
            strIid = strIid.substring(5, strIid.indexOf("\"", 6));
            iids.add(strIid);
        }
        typePattern = Pattern.compile("(element_type=\"LIST\".*iid=\".*\")");
        matcher = typePattern.matcher(content);
        while (matcher.find()) {
            tmp_type = null;
            tmp_type = matcher.group(0);
            strIid = tmp_type.substring(tmp_type.indexOf("iid"));
            strIid = strIid.substring(5, strIid.indexOf("\"", 6));
            iids.add(strIid);
        }
        InstanceID iid = InstanceID.parse((String)iids.get(1).toString());
        iid = iid.getParentID().getParentID().getParentID();
        DataID dataID = iid.getDataID();
        DataIDTest.assertEquals((String)iid.toString(), (String)("/0.-2(" + dataID.getDataSetID() + ":" + dataID.getRowID() + ")"));
        iid = iid.getParentID();
        dataID = iid.getDataID();
        DataIDTest.assertNotNull((Object)dataID);
        DataIDTest.assertEquals((String)iid.toString(), (String)("/0.28(" + dataID.getDataSetID() + ":" + dataID.getRowID() + ")"));
        iid = InstanceID.parse((String)iids.get(2).toString());
        iid = iid.getParentID().getParentID().getParentID();
        dataID = iid.getDataID();
        DataIDTest.assertNotNull((Object)dataID);
        DataIDTest.assertEquals((String)iid.toString(), (String)("/0.-3(" + dataID.getDataSetID() + ":" + dataID.getRowID() + ")"));
    }

    public void testGetDataSetID() {
        DataSetID dsID = new DataSetID("dsid");
        DataID dataID = new DataID(dsID, 1L);
        DataIDTest.assertEquals((Object)dsID, (Object)dataID.getDataSetID());
    }

    public void testGetRowID() {
        DataID dataID = new DataID(null, 0L);
        DataIDTest.assertEquals((long)0L, (long)dataID.getRowID());
        dataID = new DataID(null, 1L);
        DataIDTest.assertEquals((long)1L, (long)dataID.getRowID());
        dataID = new DataID(null, -1L);
        DataIDTest.assertEquals((long)-1L, (long)dataID.getRowID());
        dataID = new DataID(null, Long.MAX_VALUE);
        DataIDTest.assertEquals((long)Long.MAX_VALUE, (long)dataID.getRowID());
        dataID = new DataID(null, Long.MIN_VALUE);
        DataIDTest.assertEquals((long)Long.MIN_VALUE, (long)dataID.getRowID());
    }

    public void testAppend() {
        DataSetID dsID = new DataSetID("ds1");
        DataID dataID = new DataID(dsID, 0L);
        dataID.append(new StringBuffer("buffer"));
        DataIDTest.assertEquals((Object)dsID, (Object)dataID.getDataSetID());
        dataID = new DataID(null, 0L);
        dataID.append(new StringBuffer("buffer"));
        DataIDTest.assertNull((Object)dataID.getDataSetID());
    }

    public void testToString() {
        DataSetID dsID = new DataSetID("ds1");
        DataID dataID = new DataID(dsID, 0L);
        DataIDTest.assertEquals((String)"ds1:0", (String)dataID.toString());
        dsID = new DataSetID("\ufffd\ufffd\u077c\ufffd");
        dataID = new DataID(dsID, 0L);
        DataIDTest.assertEquals((String)"\ufffd\ufffd\u077c\ufffd:0", (String)dataID.toString());
        dsID = new DataSetID("\ufffd\u02e4\u06e4\ufffd\ufffd\ufffd\ufffd");
        dataID = new DataID(dsID, 0L);
        DataIDTest.assertEquals((String)"\ufffd\u02e4\u06e4\ufffd\ufffd\ufffd\ufffd:0", (String)dataID.toString());
        dsID = new DataSetID("~!@#$%^&*()_+?>:");
        dataID = new DataID(dsID, 0L);
        DataIDTest.assertEquals((String)"~!@#$%^&*()_+?>::0", (String)dataID.toString());
        dsID = new DataSetID("");
        dataID = new DataID(dsID, 0L);
        DataIDTest.assertEquals((String)":0", (String)dataID.toString());
        dataID = new DataID(dsID, Long.MAX_VALUE);
        DataIDTest.assertEquals((String)":9223372036854775807", (String)dataID.toString());
    }
}

