/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class ICellContentTest
extends BaseEmitter {
    private ICellContent cell = null;
    private String reportName = "ICellContentTest.rptdesign";
    private static int count = 0;

    protected String getReportName() {
        return this.reportName;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.reportName, this.reportName);
        this.cell = new ReportContent().createCellContent();
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testColSpan() {
        this.cell.setColSpan(3);
        ICellContentTest.assertEquals((int)3, (int)this.cell.getColSpan());
    }

    public void testRowSpan() {
        this.cell.setRowSpan(3);
        ICellContentTest.assertEquals((int)3, (int)this.cell.getRowSpan());
    }

    public void testColumn() {
        this.cell.setColumn(5);
        ICellContentTest.assertEquals((int)5, (int)this.cell.getColumn());
    }

    public void testDisplayGroupIcon() {
        this.cell.setDisplayGroupIcon(true);
        ICellContentTest.assertTrue((boolean)this.cell.getDisplayGroupIcon());
        this.cell.setDisplayGroupIcon(false);
        ICellContentTest.assertFalse((boolean)this.cell.getDisplayGroupIcon());
    }

    public void testICellContentFromReport() throws EngineException {
        this.runandrender_emitter("emitter_html", false);
    }

    public void endCell(ICellContent cell) {
        if (count == 0) {
            ICellContentTest.assertEquals((int)2, (int)cell.getColSpan());
            ICellContentTest.assertEquals((int)2, (int)cell.getRowSpan());
            ICellContentTest.assertEquals((int)0, (int)cell.getRow());
            ICellContentTest.assertEquals((int)0, (int)cell.getColumn());
            IColumn column = cell.getColumnInstance();
            ICellContentTest.assertEquals((long)5L, (long)column.getInstanceID().getComponentID());
        }
        if (count == 1) {
            ICellContentTest.assertEquals((int)1, (int)cell.getColSpan());
            ICellContentTest.assertEquals((int)1, (int)cell.getRowSpan());
            ICellContentTest.assertEquals((int)2, (int)cell.getColumn());
        }
        if (count == 2) {
            ICellContentTest.assertEquals((int)1, (int)cell.getColSpan());
            ICellContentTest.assertEquals((int)1, (int)cell.getRowSpan());
            ICellContentTest.assertEquals((int)1, (int)cell.getRow());
        }
        ++count;
    }
}

