/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class IEmitterServicesTest
extends BaseEmitter {
    private String report = "IEmitterServicesTest.rptdesign";
    private Object emitterConfig;

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.report, this.report);
    }

    public void tearDown() {
        this.removeResource();
    }

    protected String getReportName() {
        return this.report;
    }

    public void testIEmitterServices() throws BirtException {
        EngineConfig config = new EngineConfig();
        this.emitterConfig = new HTMLEmitterConfig();
        config.setEmitterConfiguration("emitter_html", this.emitterConfig);
        this.emitterConfig = config.getEmitterConfigs().get("emitter_html");
        Platform.startup((PlatformConfig)config);
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        IReportEngine reportEngine = factory.createReportEngine(config);
        IReportRunnable reportRunnable = this.engine.openReportDesign(this.genInputFile(this.report));
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat("emitter_html");
        options.setOutputFileName(this.genOutputFile("myService.html"));
        HTMLRenderContext renderContext = new HTMLRenderContext();
        renderContext.setImageDirectory("myImage");
        HashMap<String, Object> appContext = new HashMap<String, Object>();
        appContext.put("HTML_RENDER_CONTEXT", renderContext);
        appContext.put("emitter_class", (Object)this);
        IRunAndRenderTask rrTask = reportEngine.createRunAndRenderTask(reportRunnable);
        rrTask.setRenderOption((IRenderOption)options);
        rrTask.setAppContext(appContext);
        rrTask.run();
        rrTask.close();
    }

    public void initialize(IEmitterServices service) {
        IEmitterServicesTest.assertNotNull((Object)service.getEmitterConfig());
        IEmitterServicesTest.assertEquals((Object)this.emitterConfig, service.getEmitterConfig().get("emitter_html"));
        IEmitterServicesTest.assertEquals((Object)"emitter_html", (Object)service.getOption("Format"));
        IEmitterServicesTest.assertTrue((boolean)(((HashMap)service.getRenderContext()).get("HTML_RENDER_CONTEXT") instanceof HTMLRenderContext));
        HTMLRenderContext renderContext = (HTMLRenderContext)((HashMap)service.getRenderContext()).get("HTML_RENDER_CONTEXT");
        IEmitterServicesTest.assertEquals((String)"myImage", (String)renderContext.getImageDirectory());
        IReportContext context = service.getReportContext();
        IEmitterServicesTest.assertTrue((boolean)(context.getAppContext().get("HTML_RENDER_CONTEXT") instanceof HTMLRenderContext));
        renderContext = (HTMLRenderContext)context.getAppContext().get("HTML_RENDER_CONTEXT");
        IEmitterServicesTest.assertEquals((String)"myImage", (String)renderContext.getImageDirectory());
        IEmitterServicesTest.assertEquals((String)"emitter_html", (String)service.getRenderOption().getOutputFormat());
        String name = service.getReportName();
        name = name.substring(name.lastIndexOf("/") + 1);
        IEmitterServicesTest.assertEquals((String)this.report, (String)name);
        IReportRunnable reportRunnable = service.getReportRunnable();
        IEmitterServicesTest.assertEquals((String)service.getReportName(), (String)reportRunnable.getReportName());
    }
}

