/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class RunAndRenderTaskTest
extends EngineCase {
    private Boolean cancelSignal = new Boolean(false);

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("report_engine.rptdesign", "report_engine.rptdesign");
        this.copyResource_INPUT("pages9.rptdesign", "pages9.rptdesign");
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testRunAndRenderTask() throws EngineException {
        String input = this.genInputFile("report_engine.rptdesign");
        try {
            IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(input)));
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            RunAndRenderTaskTest.assertTrue((boolean)task.validateParameters());
            RenderOptionBase option = new RenderOptionBase();
            task.setRenderOption((IRenderOption)option);
            RenderOptionBase optionGet = (RenderOptionBase)task.getRenderOption();
            RunAndRenderTaskTest.assertEquals((String)"set/getRenderOption fail", (Object)option, (Object)optionGet);
            HashMap hm = new HashMap();
            task.setParameterValues(hm);
            HashMap hmGet = task.getParameterValues();
            RunAndRenderTaskTest.assertEquals((String)"set/getParameterValues(hashmap) fail", hm, (Object)hmGet);
            task.setParameterValue("p1", (Object)"p1value");
            RunAndRenderTaskTest.assertEquals((String)"Set/getParameterValues fail", task.getParameterValues().get("p1"), (Object)"p1value");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void testCancelRunAndRenderTask() {
        String input = this.genInputFile("pages9.rptdesign");
        long timeSpan1 = 0L;
        long timeSpan2 = 0L;
        long timeSpan3 = 0L;
        try {
            IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(input)));
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            int i = 0;
            while (i < 3) {
                task = this.engine.createRunAndRenderTask(runnable);
                task.setRenderOption((IRenderOption)option);
                task.setAppContext(new HashMap());
                task.run();
                task.close();
                ++i;
            }
            i = 0;
            while (i < 10) {
                task = this.engine.createRunAndRenderTask(runnable);
                task.setRenderOption((IRenderOption)option);
                task.setAppContext(new HashMap());
                this.engine.getConfig().getAppContext().put("taskToCancel", task);
                long bTime = System.currentTimeMillis();
                task.run();
                long eTime = System.currentTimeMillis();
                task.close();
                timeSpan1 += eTime - bTime;
                task = this.engine.createRunAndRenderTask(runnable);
                this.engine.getConfig().getAppContext().put("taskToCancelWithSignal", task);
                task.setRenderOption((IRenderOption)option);
                bTime = System.currentTimeMillis();
                task.run();
                eTime = System.currentTimeMillis();
                task.close();
                timeSpan2 += eTime - bTime;
                task = this.engine.createRunAndRenderTask(runnable);
                this.engine.getConfig().getAppContext().put("taskToCancel", null);
                this.engine.getConfig().getAppContext().put("taskToCancelWithSignal", null);
                task.setRenderOption((IRenderOption)option);
                bTime = System.currentTimeMillis();
                task.run();
                eTime = System.currentTimeMillis();
                task.close();
                timeSpan3 += eTime - bTime;
                ++i;
            }
            RunAndRenderTaskTest.assertTrue((String)"timeSpan3 > timeSpan1", (timeSpan3 > timeSpan1 ? 1 : 0) != 0);
            RunAndRenderTaskTest.assertTrue((String)"timeSpan3 > timeSpan2", (timeSpan3 > timeSpan2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            RunAndRenderTaskTest.fail((String)"RunAndRenderTask.cancel() failed!");
        }
    }

    private class CancelTask
    extends Thread {
        private IRunAndRenderTask runTask;

        public CancelTask(String threadName, IRunAndRenderTask task) {
            super(threadName);
            this.runTask = task;
        }

        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                this.runTask.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
                RunAndRenderTaskTest.fail((String)"RunAndRenderTask.cancel() failed!");
            }
        }
    }

    private class CancelWithFlagTask
    extends Thread {
        private IRunAndRenderTask runTask;

        public CancelWithFlagTask(String threadName, IRunAndRenderTask task) {
            super(threadName);
            this.runTask = task;
        }

        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                this.runTask.cancel((Object)RunAndRenderTaskTest.this.cancelSignal);
            }
            catch (Exception e) {
                e.printStackTrace();
                RunAndRenderTaskTest.fail((String)"RunAndRenderTask.cancel() failed!");
            }
        }
    }
}

