/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class RunTaskTest
extends EngineCase {
    private Boolean signal = new Boolean(false);
    private String separator = System.getProperty("file.separator");
    private String INPUT = String.valueOf(this.genInputFolder()) + this.separator;
    String tempDir = System.getProperty("java.io.tmpdir");
    private String OUTPUT = String.valueOf(this.genOutputFolder()) + this.separator;
    private String report_design;
    private String report_document;
    private String name;
    private IReportRunnable runnable;

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
    }

    public void tearDown() {
        this.removeResource();
    }

    public RunTaskTest(String name) {
        super(name);
    }

    public static Test Suite() {
        return new TestSuite(RunTaskTest.class);
    }

    public void testRunTask_simple() {
        this.runReport("case1");
    }

    public void testRunTask_longtext() {
        this.runReport("long_text");
    }

    public void testRunTask_masterpage() {
        this.runReport("master_page");
    }

    public void testRunTask_multidataset() {
        this.runReport("multiple_datasets");
    }

    public void testRunTask_pages() {
        this.runReport("pages9");
    }

    public void testRunTask_nesttable() {
        this.runReport("table_nest_pages");
    }

    public void testRunTask_chart() {
        this.runReport("chart");
    }

    public void testRunTask_complex() {
        this.runReport("complex_report");
    }

    public void testRunTask_areachart() {
        this.runReport("area3dChart");
    }

    public void testRunTask_dynamicimage() {
        this.runReport("image_in_DB");
    }

    public void testRunTask_meterchart() {
        this.runReport("MeterChart");
    }

    public void testCancel() {
        this.report_design = String.valueOf(this.INPUT) + "pages9.rptdesign";
        this.copyResource_INPUT("pages9.rptdesign", "pages9.rptdesign");
        String fileDocument = String.valueOf(this.OUTPUT) + "cancel_pages9.rptdocument";
        try {
            this.runnable = this.engine.openReportDesign(this.report_design);
            IRunTask task = this.engine.createRunTask(this.runnable);
            CancelTask cancelThread = new CancelTask("cancelThread", task);
            cancelThread.start();
            long bTime = System.currentTimeMillis();
            task.run(fileDocument);
            long eTime = System.currentTimeMillis();
            task.close();
            long timeSpan1 = eTime - bTime;
            task = this.engine.createRunTask(this.runnable);
            bTime = System.currentTimeMillis();
            task.run(fileDocument);
            eTime = System.currentTimeMillis();
            task.close();
            long timeSpan3 = eTime - bTime;
            this.removeFile(fileDocument);
            RunTaskTest.assertTrue((String)"RunTask.cancel() failed!", (timeSpan3 > timeSpan1 ? 1 : 0) != 0);
        }
        catch (EngineException ee) {
            ee.printStackTrace();
            RunTaskTest.fail((String)"RunTask.cancel() failed!");
        }
    }

    public void testGetErrors() {
        this.report_design = String.valueOf(this.INPUT) + "jdbc_exception.rptdesign";
        this.copyResource_INPUT("jdbc_exception.rptdesign", "jdbc_exception.rptdesign");
        String fileDocument = String.valueOf(this.OUTPUT) + "jdbc_exception.rptdocument";
        try {
            this.runnable = this.engine.openReportDesign(this.report_design);
            IRunTask task = this.engine.createRunTask(this.runnable);
            task.run(fileDocument);
            RunTaskTest.assertTrue((String)"IRunTask.getErrors() fails!", (task.getErrors() != null ? 1 : 0) != 0);
            RunTaskTest.assertTrue((task.getErrors().get(0).getClass().toString().indexOf("Exception") > 0 ? 1 : 0) != 0);
            task.close();
        }
        catch (Exception exception) {}
    }

    private void runReport(String report) {
        this.report_design = String.valueOf(this.INPUT) + report + ".rptdesign";
        this.copyResource_INPUT(String.valueOf(report) + ".rptdesign", String.valueOf(report) + ".rptdesign");
        String fileDocument = String.valueOf(this.OUTPUT) + report + ".rptdocument";
        String folderDocument = String.valueOf(this.OUTPUT) + "runtask_folderdocument_" + report + this.separator;
        try {
            this.runnable = this.engine.openReportDesign(this.report_design);
            IRunTask task = this.engine.createRunTask(this.runnable);
            task.run(fileDocument);
            task.close();
            task = this.engine.createRunTask(this.runnable);
            task.run(folderDocument);
            task.close();
            RunTaskTest.assertTrue((String)("Fail to generate file archive for " + report), (boolean)new File(fileDocument).exists());
            RunTaskTest.assertTrue((String)("Fail to generate folder archive for " + report), (boolean)new File(folderDocument).exists());
        }
        catch (EngineException ee) {
            ee.printStackTrace();
            RunTaskTest.assertTrue((String)("Failed to generate document for " + report + ee.getLocalizedMessage()), (boolean)false);
        }
    }

    private class CancelTask
    extends Thread {
        private IRunTask runTask;

        public CancelTask(String threadName, IRunTask task) {
            super(threadName);
            this.runTask = task;
        }

        public void run() {
            try {
                System.out.print("cancel started waiting");
                Thread.currentThread();
                Thread.sleep(100L);
                System.out.print("cancel stop waiting");
                this.runTask.cancel();
                System.out.print("cancel done");
            }
            catch (Exception e) {
                e.printStackTrace();
                RunTaskTest.fail((String)"RunTask.cancel() failed");
            }
        }
    }
}

