/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;

public class LogConfigurationTest
extends TestCase {
    private Logger m_pkgLogger = Logger.getLogger(LogConfigurationTest.class.getName().substring(0, LogConfigurationTest.class.getName().lastIndexOf(".")));
    private String m_simpleFormatterName = "java.util.logging.SimpleFormatter";
    private OdaJdbcDriver m_driver = new OdaJdbcDriver();
    private String m_logDirectory = "./OdaLogs";
    private File m_dir = new File(this.m_logDirectory);

    protected void setUp() throws Exception {
        super.setUp();
        if (this.m_dir.exists()) {
            this.clearDirectory(this.m_dir);
        } else {
            boolean created = this.m_dir.mkdir();
            if (!created) {
                throw new IOException("Cannot create directory: " + this.m_dir.getName());
            }
        }
    }

    protected void tearDown() throws Exception {
        this.clearHandlers(this.m_pkgLogger);
        this.clearDirectory(this.m_dir);
        boolean deleted = this.m_dir.delete();
        if (!deleted) {
            throw new IOException("Cannot delete directory: " + this.m_dir.getName());
        }
        super.tearDown();
    }

    public void testValidLogConfig() throws Exception {
        this.clearHandlers(this.m_pkgLogger);
        LogConfiguration config = new LogConfiguration(900, null, null, null);
        this.m_driver.setLogConfiguration(config);
        Handler[] handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, Level.WARNING);
        this.assertHandlerType(handlers, true);
        this.clearHandlers(this.m_pkgLogger);
        config = new LogConfiguration(400, "", "", "");
        this.m_driver.setLogConfiguration(config);
        handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, Level.FINER);
        this.assertHandlerType(handlers, true);
        this.clearHandlers(this.m_pkgLogger);
        config = new LogConfiguration(500, null, "", this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, Level.FINE);
        this.assertHandlerType(handlers, true);
        config = new LogConfiguration(Integer.MIN_VALUE, "", null, this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, Level.ALL);
        this.assertHandlerType(handlers, true);
        this.clearHandlers(this.m_pkgLogger);
        config = new LogConfiguration(Integer.MAX_VALUE, null, null, this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        LogConfigurationTest.assertEquals((Object)Level.OFF, (Object)this.m_pkgLogger.getLevel());
        LogConfigurationTest.assertEquals((int)0, (int)this.m_pkgLogger.getHandlers().length);
        this.clearHandlers(this.m_pkgLogger);
        config = new LogConfiguration(1002, null, null, this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        LogConfigurationTest.assertEquals((Object)Level.OFF, (Object)this.m_pkgLogger.getLevel());
        LogConfigurationTest.assertEquals((int)0, (int)this.m_pkgLogger.getHandlers().length);
    }

    public void testInvalidLogConfig() throws Exception {
        this.clearHandlers(this.m_pkgLogger);
        Level priorLogLevel = Level.CONFIG;
        this.m_pkgLogger.setLevel(priorLogLevel);
        LogConfiguration config = new LogConfiguration(-100, null, null, null);
        this.m_driver.setLogConfiguration(config);
        Handler[] handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, priorLogLevel);
        this.assertHandlerType(handlers, true);
        this.clearHandlers(this.m_pkgLogger);
        priorLogLevel = Level.CONFIG;
        this.m_pkgLogger.setLevel(priorLogLevel);
        config = new LogConfiguration(-100, null, null, this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, priorLogLevel);
        this.assertHandlerType(handlers, true);
        this.clearHandlers(this.m_pkgLogger);
        priorLogLevel = Level.OFF;
        this.m_pkgLogger.setLevel(priorLogLevel);
        config = new LogConfiguration(50, null, null, this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        LogConfigurationTest.assertEquals((Object)priorLogLevel, (Object)this.m_pkgLogger.getLevel());
        LogConfigurationTest.assertEquals((int)0, (int)this.m_pkgLogger.getHandlers().length);
        this.clearHandlers(this.m_pkgLogger);
        this.m_pkgLogger.setLevel(null);
        config = new LogConfiguration(-100, null, null, this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        LogConfigurationTest.assertEquals(null, (Object)this.m_pkgLogger.getLevel());
        this.assertHandlerType(handlers, true);
        this.clearHandlers(this.m_pkgLogger);
        config = new LogConfiguration(900, "invalid directory?", "invalid prefix?", this.m_simpleFormatterName);
        this.m_driver.setLogConfiguration(config);
        LogConfigurationTest.assertEquals((Object)Level.WARNING, (Object)this.m_pkgLogger.getLevel());
        LogConfigurationTest.assertEquals((int)0, (int)this.m_pkgLogger.getHandlers().length);
        this.clearHandlers(this.m_pkgLogger);
        config = new LogConfiguration(900, null, null, "invalid formatter class!");
        this.m_driver.setLogConfiguration(config);
        handlers = this.m_pkgLogger.getHandlers();
        this.assertSingleHandlerAndSimpleFormatter(handlers);
        this.assertLoggerAndHandlerLevels(handlers, Level.WARNING);
        this.assertHandlerType(handlers, true);
    }

    public void testFileLogging() throws Exception {
    }

    private void clearHandlers(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            logger.removeHandler(handlers[i]);
            ++i;
        }
    }

    private void assertSingleHandlerAndSimpleFormatter(Handler[] handlers) {
        LogConfigurationTest.assertEquals((int)1, (int)handlers.length);
        if (handlers.length < 1) {
            return;
        }
        LogConfigurationTest.assertNotNull((Object)handlers[0].getFormatter());
        LogConfigurationTest.assertEquals((String)this.m_simpleFormatterName, (String)handlers[0].getFormatter().getClass().getName());
    }

    private void assertHandlerType(Handler[] handlers, boolean isConsoleHandler) {
        if (handlers.length < 1) {
            LogConfigurationTest.fail((String)"Expecting at least one handler; found none.");
            return;
        }
        if (isConsoleHandler) {
            LogConfigurationTest.assertTrue((boolean)(handlers[0] instanceof ConsoleHandler));
        } else {
            LogConfigurationTest.assertTrue((boolean)(handlers[0] instanceof FileHandler));
        }
    }

    private void assertLoggerAndHandlerLevels(Handler[] handlers, Level level) {
        if (handlers.length < 1) {
            return;
        }
        LogConfigurationTest.assertEquals((Object)level, (Object)this.m_pkgLogger.getLevel());
        LogConfigurationTest.assertEquals((Object)level, (Object)handlers[0].getLevel());
    }

    private void clearDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            boolean deleted = files[i].delete();
            if (!deleted) {
                throw new IOException("Cannot delete file: " + files[i].getName());
            }
            ++i;
        }
    }

    private Level convertLogLevel(int level) {
        switch (level) {
            case -2147483648: {
                return Level.ALL;
            }
            case 300: {
                return Level.FINEST;
            }
            case 400: {
                return Level.FINER;
            }
            case 500: {
                return Level.FINE;
            }
            case 700: {
                return Level.CONFIG;
            }
            case 800: {
                return Level.INFO;
            }
            case 900: {
                return Level.WARNING;
            }
            case 1000: {
                return Level.SEVERE;
            }
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
        }
        if (level > 1000) {
            return Level.OFF;
        }
        LogConfigurationTest.fail((String)"No valid level specified.");
        return null;
    }

    private void logMessageForAllLevels(Logger logger) {
        logger.log(Level.SEVERE, "SEVERE log message");
        logger.log(Level.WARNING, "WARNING log message");
        logger.log(Level.INFO, "INFO log message");
        logger.log(Level.CONFIG, "CONFIG log message");
        logger.log(Level.FINE, "FINE log message");
        logger.log(Level.FINER, "FINER log message");
        logger.log(Level.FINEST, "FINEST log message");
        logger.log(Level.ALL, "ALL log message");
    }

    private boolean isLockFile(File file) {
        String fileName = file.getName();
        String fileExtension = fileName.substring(fileName.length() - 3);
        return fileExtension.equals("lck");
    }
}

