/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class OdaJdbcDriverTest
extends TestCase {
    public OdaJdbcDriverTest(String arg0) {
        super(arg0);
    }

    public void testGetConnection() throws Exception {
        OdaJdbcDriver connFact = new OdaJdbcDriver();
        Connection conn = (Connection)connFact.getConnection("");
        OdaJdbcDriverTest.assertNotNull((Object)conn);
    }

    public void testSetAppContext() throws Exception {
        OdaJdbcDriver connFact = new OdaJdbcDriver();
        IConnection odaConnection = connFact.getConnection("");
        OdaJdbcDriverTest.assertFalse((boolean)odaConnection.isOpen());
        try {
            odaConnection.open(null);
            OdaJdbcDriverTest.fail((String)"The connction should not have been opened!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            odaConnection.close();
        }
        Properties props = new Properties();
        props.setProperty("odaURL", TestUtil.getURL());
        props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
        props.setProperty("odaUser", TestUtil.getUser());
        props.setProperty("odaPassword", "");
        try {
            odaConnection.open(props);
            OdaJdbcDriverTest.assertTrue((boolean)odaConnection.isOpen());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            odaConnection.close();
        }
        HashMap<String, java.sql.Connection> context = new HashMap<String, java.sql.Connection>();
        java.sql.Connection passInConn = TestUtil.openJDBCConnection();
        context.put("OdaJDBCDriverPassInConnection", passInConn);
        IConnection connection = connFact.getConnection("");
        connection.setAppContext(context);
        try {
            connection.open(null);
            OdaJdbcDriverTest.assertTrue((boolean)connection.isOpen());
        }
        catch (OdaException odaException) {
            OdaJdbcDriverTest.fail((String)"Exception occurrs when opening a connection!");
        }
    }
}

