/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class AutotextHandleTest
extends BaseTestCase {
    private ElementFactory factory = null;
    private AutoTextHandle autotext = null;
    private AutoTextHandle autotext1 = null;
    private AutoTextHandle autotext2 = null;
    private SimpleMasterPageHandle masterpage = null;

    public AutotextHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AutotextHandleTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SessionHandle designSession = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = designSession.createDesign();
        this.factory = new ElementFactory(this.designHandle.getModule());
        this.autotext = this.factory.newAutoText("autotext");
        this.autotext1 = this.factory.newAutoText("autotext1");
        this.masterpage = this.factory.newSimpleMasterPage("masterpage");
        this.designHandle.getMasterPages().add((DesignElementHandle)this.masterpage);
    }

    public void testAddAndDeleteAutotext() throws Exception {
        this.masterpage.getPageHeader().add((DesignElementHandle)this.autotext);
        AutotextHandleTest.assertEquals((int)1, (int)this.masterpage.getPageHeader().getContents().size());
        this.masterpage.getPageFooter().add((DesignElementHandle)this.autotext1);
        AutotextHandleTest.assertEquals((int)1, (int)this.masterpage.getPageFooter().getContents().size());
        try {
            this.autotext2 = this.factory.newAutoText("autotext2");
            this.masterpage.getPageHeader().add((DesignElementHandle)this.autotext2);
            AutotextHandleTest.fail();
        }
        catch (ContentException e) {
            AutotextHandleTest.assertNotNull((Object)((Object)e));
        }
        this.masterpage.getPageHeader().drop((DesignElementHandle)this.autotext);
        AutotextHandleTest.assertEquals((int)0, (int)this.masterpage.getPageHeader().getContents().size());
        this.masterpage.getPageFooter().drop((DesignElementHandle)this.autotext1);
        AutotextHandleTest.assertEquals((int)0, (int)this.masterpage.getPageFooter().getContents().size());
        TableHandle table = this.factory.newTableItem("table", 3, 1, 1, 1);
        RowHandle detail = (RowHandle)table.getSlot(0).get(0);
        CellHandle cell = (CellHandle)detail.getSlot(0).get(0);
        cell.getSlot(0).add((DesignElementHandle)this.autotext);
    }

    public void testStyleOnAutotext() throws Exception {
        SharedStyleHandle style = this.factory.newStyle("style");
        style.setStringProperty("backgroundColor", "red");
        style.setStringProperty("fontSize", "small");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        this.autotext.setStyle(style);
        AutotextHandleTest.assertEquals((String)"red", (String)this.autotext.getStringProperty("backgroundColor"));
        AutotextHandleTest.assertEquals((String)"small", (String)this.autotext.getStringProperty("fontSize"));
    }
}

