/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.CustomColorHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ElementExporterTest
extends BaseTestCase {
    private ReportDesignHandle designHandle;
    private LibraryHandle libaryHandle;

    public static Test suite() {
        return new TestSuite(ElementExporterTest.class);
    }

    protected void setUp() throws Exception {
        this.designHandle = this.createDesign(ULocale.ENGLISH);
        this.libaryHandle = this.createLibrary();
    }

    protected void tearDown() throws Exception {
    }

    public void testCanExport() throws SemanticException {
        AutoTextHandle autotext = this.designHandle.getElementFactory().newAutoText("autotext");
        SimpleMasterPageHandle masterPage = this.designHandle.getElementFactory().newSimpleMasterPage("mypage");
        masterPage.getPageHeader().add((DesignElementHandle)autotext);
        this.designHandle.getMasterPages().add((DesignElementHandle)masterPage);
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)autotext, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)masterPage, (LibraryHandle)this.libraryHandle, (boolean)false));
        GridHandle grid = this.designHandle.getElementFactory().newGridItem(null, 1, 1);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)grid, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)grid, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)grid));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)grid, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)grid, (boolean)false));
        TableHandle table = this.designHandle.getElementFactory().newTableItem("mytable");
        TableGroupHandle group = this.designHandle.getElementFactory().newTableGroup();
        table.getGroups().add((DesignElementHandle)group);
        this.designHandle.getBody().add((DesignElementHandle)table);
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)table, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)group, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)group));
        RowHandle row = this.designHandle.getElementFactory().newTableRow();
        CellHandle cell = this.designHandle.getElementFactory().newCell();
        table.getHeader().add((DesignElementHandle)row);
        row.getCells().add((DesignElementHandle)cell);
        ColumnHandle column = this.designHandle.getElementFactory().newTableColumn();
        table.getColumns().add((DesignElementHandle)column);
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)row, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)column, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)cell, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)row));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)column));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)cell));
        FilterCondition filtercondition = StructureFactory.createFilterCond();
        filtercondition.setExpr("1");
        table = (TableHandle)this.designHandle.findElement("mytable");
        PropertyHandle propHandle = table.getPropertyHandle("filter");
        propHandle.addItem((IStructure)filtercondition);
        FilterConditionHandle fcHandle = (FilterConditionHandle)table.filtersIterator().next();
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StructureHandle)fcHandle, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StructureHandle)fcHandle));
        this.designHandle.getElementFactory().newTabularDimension("mydim");
        TabularCubeHandle cubeHandle = this.designHandle.getElementFactory().newTabularCube("mycube");
        this.designHandle.getCubes().add((DesignElementHandle)cubeHandle);
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)cubeHandle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)cubeHandle));
        LabelHandle label = this.designHandle.getElementFactory().newLabel("mylabel");
        label.setAction(StructureFactory.createAction());
        ActionHandle actionHandle = label.getActionHandle();
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StructureHandle)actionHandle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StructureHandle)actionHandle));
        ConfigVariable cv = StructureFactory.createConfigVar();
        cv.setName("config1");
        cv.setValue("value");
        this.designHandle.addConfigVariable(cv);
        PropertyHandle propertyHandle = this.designHandle.getPropertyHandle("configVars");
        Iterator iter = propertyHandle.iterator();
        ConfigVariableHandle cvHandle = (ConfigVariableHandle)iter.next();
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)cvHandle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)cvHandle));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)cvHandle, (boolean)false));
        CustomColor customColor = StructureFactory.createCustomColor();
        customColor.setName("tmpcolor");
        this.designHandle.getPropertyHandle("colorPalette").addItem((IStructure)customColor);
        CustomColorHandle color1 = (CustomColorHandle)this.designHandle.customColorsIterator().next();
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)color1, (boolean)false));
        customColor.setName(null);
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StructureHandle)color1, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)color1, (boolean)true));
    }

    public void testCanExport_invalid() {
        DesignElementHandle handle = null;
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport(handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        StructureHandle structure = null;
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport(handle));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport(structure));
    }
}

