/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ExternalCssStyleSheet3Test
extends BaseTestCase {
    private String fileName = "ExternalCssStyleSheet3Test.css";

    public ExternalCssStyleSheet3Test(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ExternalCssStyleSheet3Test.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.createDesign();
    }

    public void testImportExternalCssStyleSheet() throws Exception {
        this.designHandle.setBase(PLUGIN_PATH);
        CssStyleSheetHandle stylesheet = this.loadStyleSheet(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + this.fileName);
        ExternalCssStyleSheet3Test.assertNotNull((Object)stylesheet);
        SharedStyleHandle style1 = stylesheet.findStyle("STYLE1");
        SharedStyleHandle style2 = stylesheet.findStyle("styl2");
        SharedStyleHandle style3 = stylesheet.findStyle("style3");
        ExternalCssStyleSheet3Test.assertNotNull((Object)style1);
        ExternalCssStyleSheet3Test.assertNull((Object)style2);
        ExternalCssStyleSheet3Test.assertNotNull((Object)style3);
        ArrayList<SharedStyleHandle> styleList = new ArrayList<SharedStyleHandle>();
        styleList.add(0, style1);
        styleList.add(1, style3);
        ExternalCssStyleSheet3Test.assertEquals((int)2, (int)styleList.size());
        this.designHandle.importCssStyles(stylesheet, styleList);
        ExternalCssStyleSheet3Test.assertEquals((int)4, (int)this.designHandle.getStyles().getCount());
    }

    public void testImportExternalCssStyleSheetWithFile() throws Exception {
        try {
            this.loadStyleSheet(this.fileName);
            ExternalCssStyleSheet3Test.fail();
        }
        catch (Exception e) {
            ExternalCssStyleSheet3Test.assertNotNull((Object)e);
        }
    }

    private CssStyleSheetHandle loadStyleSheet(String fileName) throws Exception {
        return this.designHandle.openCssStyleSheet(fileName);
    }
}

