/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class GroupHandleTest
extends BaseTestCase {
    public GroupHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(GroupHandleTest.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("GroupHandleTest.xml", "GroupHandleTest.xml");
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testIntervalRange() throws SemanticException {
        this.createDesign();
        ElementFactory factory = this.designHandle.getElementFactory();
        TableHandle table = factory.newTableItem("table");
        this.designHandle.getBody().add((DesignElementHandle)table);
        TableGroupHandle group = factory.newTableGroup();
        table.getGroups().add((DesignElementHandle)group);
        group.setKeyExpr("row[\"abc\"]");
        group.setIntervalRange("1.234567");
        GroupHandleTest.assertEquals((String)"1.234567", (String)group.getStringProperty("intervalRange"));
        group.setIntervalRange("1234567E-6");
        GroupHandleTest.assertEquals((String)"1.234567", (String)group.getStringProperty("intervalRange"));
        try {
            group.setIntervalRange("abc");
        }
        catch (SemanticException e) {
            GroupHandleTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testIntervalRangeWithLocale() throws SemanticException {
        this.createDesign(ULocale.GERMANY);
        ElementFactory factory = this.designHandle.getElementFactory();
        TableHandle table = factory.newTableItem("table");
        this.designHandle.getBody().add((DesignElementHandle)table);
        TableGroupHandle group = factory.newTableGroup();
        table.getGroups().add((DesignElementHandle)group);
        group.setKeyExpr("row[\"abc\"]");
        group.setIntervalRange("1.234567");
        group.setIntervalRange("6.0");
        GroupHandleTest.assertEquals((String)"60.0", (String)group.getStringProperty("intervalRange"));
        group.setIntervalRange("1,234.567");
        GroupHandleTest.assertEquals((String)"1.234", (String)group.getStringProperty("intervalRange"));
        group.setIntervalRange("1234567E-6");
        GroupHandleTest.assertEquals((String)"1.234567", (String)group.getStringProperty("intervalRange"));
    }

    public void testACL() throws SemanticException {
        this.createDesign();
        ElementFactory factory = this.designHandle.getElementFactory();
        TableHandle table = factory.newTableItem("table");
        this.designHandle.getBody().add((DesignElementHandle)table);
        TableGroupHandle group = factory.newTableGroup();
        table.getGroups().add((DesignElementHandle)group);
        group.setACLExpression("group");
        GroupHandleTest.assertEquals((String)"group", (String)((GroupHandle)table.getGroups().get(0)).getACLExpression());
        GroupHandleTest.assertTrue((boolean)((GroupHandle)table.getGroups().get(0)).cascadeACL());
    }
}

