/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class IncludeLibraryRuleTest
extends BaseTestCase {
    String fileName = "BlankReport.xml";
    String libfileName = "DesignIncludeLibraryTest.xml";
    private String outputFileName = "IncludeLibraryRuleTest10.xml";
    private String LibA = "LibA.xml";
    private String LibB = "LibB.xml";
    private String LibC = "LibC.xml";
    private String outLibA = "LibA.xml";

    public IncludeLibraryRuleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IncludeLibraryRuleTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        this.copyInputToFile("input/" + this.libfileName);
        this.copyInputToFile("input/" + this.LibA);
        this.copyInputToFile("input/" + this.LibB);
        this.copyInputToFile("input/" + this.LibC);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testIncludeLibraryRule1() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.LibA, "LibA");
        this.designHandle.includeLibrary(this.LibB, "LibB");
        this.designHandle.includeLibrary(this.LibC, "LibC");
    }

    public void testIncludeLibraryRule2() throws Exception {
        this.openDesign(this.fileName);
        try {
            this.designHandle.includeLibrary(this.LibA, "");
            this.designHandle.includeLibrary(this.LibB, "");
            this.designHandle.includeLibrary(this.LibC, "");
        }
        catch (Exception e) {
            IncludeLibraryRuleTest.assertNotNull((Object)e);
        }
    }

    public void testIncludeLibraryRule3() throws Exception {
        this.openDesign(this.fileName);
        try {
            this.designHandle.includeLibrary(this.LibA, "LibA");
            this.designHandle.includeLibrary(this.LibB, "LibA");
        }
        catch (Exception e) {
            IncludeLibraryRuleTest.assertNotNull((Object)e);
        }
    }

    public void testIncludeLibraryRule4() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.LibA, "");
        try {
            this.designHandle.includeLibrary(this.LibB, "LibA");
            IncludeLibraryRuleTest.fail();
        }
        catch (Exception e) {
            IncludeLibraryRuleTest.assertNotNull((Object)e);
        }
    }

    public void testIncludeLibraryRule5() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.LibA, "");
        try {
            this.designHandle.includeLibrary(this.LibA, "LibB");
            IncludeLibraryRuleTest.fail();
        }
        catch (SemanticException e) {
            IncludeLibraryRuleTest.assertNotNull((Object)((Object)e));
        }
    }

    public void testIncludeLibraryRule6() throws Exception {
        this.openLibrary(this.LibA);
        this.libraryHandle.includeLibrary(this.LibB, "LibB");
        this.libraryHandle.includeLibrary(this.LibC, "LibC");
    }

    public void testIncludeLibraryRule7() throws Exception {
        this.openDesign(this.fileName);
        this.testIncludeLibraryRule6();
        this.designHandle.includeLibrary(this.LibA, "LibA");
    }

    public void testIncludeLibraryRule8() throws Exception {
        this.openDesign(this.fileName);
        this.testIncludeLibraryRule6();
        this.designHandle.includeLibrary(this.LibA, "LibA");
        this.designHandle.includeLibrary(this.LibB, "");
    }

    public void testIncludeLibraryRule9() throws Exception {
        this.openLibrary(this.LibA);
        this.libraryHandle.includeLibrary(this.LibB, "LibB");
        super.saveAs(this.outLibA);
        this.libraryHandle.close();
        this.openLibrary(this.LibB);
        this.libraryHandle.includeLibrary(this.outLibA, "LibA");
    }

    public void testIncludeLibraryRule10() throws Exception {
        this.openDesign(this.libfileName);
        this.designHandle.includeLibrary(this.LibA, "LibA");
        this.designHandle.includeLibrary(this.LibB, "LibB");
        TextItemHandle textDesignHandle = (TextItemHandle)this.designHandle.findElement("text1");
        IncludeLibraryRuleTest.assertNotNull((String)"Text should not be null", (Object)textDesignHandle);
        textDesignHandle.setProperty("backgroundColor", null);
        IncludeLibraryRuleTest.assertEquals((String)"#0000FF", (String)textDesignHandle.getStringProperty("backgroundColor"));
        SharedStyleHandle styleDesignHandle = this.designHandle.findStyle("style1");
        IncludeLibraryRuleTest.assertNotNull((String)"Style should not be null", (Object)styleDesignHandle);
        styleDesignHandle.drop();
        super.saveAs(this.outputFileName);
        TextItemHandle text2DesignHandle = (TextItemHandle)this.designHandle.findElement("text1");
        IncludeLibraryRuleTest.assertNotNull((String)"Text should not be null", (Object)text2DesignHandle);
        IncludeLibraryRuleTest.assertEquals(null, (String)textDesignHandle.getStringProperty("backgroundColor"));
    }
}

