/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.util.ResourceLocatorImpl;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class InputStreamURITest
extends BaseTestCase {
    private final String fileName = "inputStream_uri_Test.xml";
    private ResourceLocatorImpl rl;

    public InputStreamURITest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(InputStreamURITest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/inputStream_uri_Test.xml");
        this.copyInputToFile("input/Library_Import_Test.xml");
        this.openDesign("inputStream_uri_Test.xml");
        this.rl = new ResourceLocatorImpl();
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testImportLibrary() throws Exception {
        URL url = this.rl.findResource((ModuleHandle)this.designHandle, "1.xml", 1);
        InputStreamURITest.assertNull((Object)url);
        url = this.rl.findResource((ModuleHandle)this.designHandle, "1.xml", 2);
        InputStreamURITest.assertNull((Object)url);
        url = this.rl.findResource((ModuleHandle)this.designHandle, "Library_Import_Test.xml", 2);
        InputStreamURITest.assertNotNull((Object)url);
        this.designHandle.setFileName(String.valueOf(this.getTempFolder()) + "/" + "golden" + "/");
        url = this.rl.findResource((ModuleHandle)this.designHandle, "1_golden.xml", 1);
        InputStreamURITest.assertNull((Object)url);
        this.designHandle.setFileName(String.valueOf(this.getTempFolder()) + "/" + "golden" + "/");
        url = this.rl.findResource((ModuleHandle)this.designHandle, "LibraryCreatLib.xml", 1);
        InputStreamURITest.assertNull((Object)url);
        url = this.rl.findResource((ModuleHandle)this.designHandle, "http://www.actuate.com/logo.gif", 1);
        InputStreamURITest.assertNotNull((Object)url);
    }
}

