/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class MoveLibraryTest
extends BaseTestCase {
    String fileName = "BlankReport.xml";
    private static String LibA = "LibA.xml";
    private static String LibB = "LibB.xml";
    private static String LibC = "LibC.xml";
    private String LibD = "LibA.xml";

    public MoveLibraryTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MoveLibraryTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        this.copyInputToFile("input/" + LibA);
        this.copyInputToFile("input/" + LibB);
        this.copyInputToFile("input/" + LibC);
        this.openDesign(this.fileName);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testCopyLibA() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        MoveLibraryTest.assertNotNull((Object)this.sessionHandle);
        this.libraryHandle = this.sessionHandle.openLibrary(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + LibA);
        MoveLibraryTest.assertNotNull((Object)this.libraryHandle);
        String TempFile = this.genOutputFile(this.LibD);
        this.libraryHandle.saveAs(TempFile);
    }

    public void testMoveLibrary() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.LibD, "LibD");
        LibraryHandle libHandle = this.designHandle.getLibrary("LibD");
        TextItemHandle textLibHandle = (TextItemHandle)libHandle.findElement("text1");
        MoveLibraryTest.assertNotNull((String)"Text should not be null", (Object)textLibHandle);
        DataItemHandle dataLibHandle = (DataItemHandle)libHandle.findElement("data1");
        MoveLibraryTest.assertNotNull((String)"Data should not be null", (Object)dataLibHandle);
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)textLibHandle, "text1");
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)dataLibHandle, "data1");
        this.designHandle.getBody().add((DesignElementHandle)dataHandle);
        this.designHandle.getBody().add((DesignElementHandle)textHandle);
        MoveLibraryTest.assertEquals((String)"yellow", (String)dataHandle.getExtends().getStringProperty("backgroundColor"));
        MoveLibraryTest.assertEquals((String)"red", (String)textHandle.getExtends().getStringProperty("backgroundColor"));
        File deleteLibD = new File(this.LibD);
        deleteLibD.delete();
        String TempFile = this.genOutputFile("SavedReport.xml");
        this.designHandle.saveAs(TempFile);
        this.openDesign("SavedReport.xml");
        MoveLibraryTest.assertNotNull((Object)((TextItemHandle)this.designHandle.findElement("text1")));
        MoveLibraryTest.assertNotNull((Object)((DataItemHandle)this.designHandle.findElement("data1")));
        MoveLibraryTest.assertEquals(null, (String)((TextItemHandle)this.designHandle.findElement("text1")).getStringProperty("backgroundColor"));
        MoveLibraryTest.assertEquals(null, (String)((DataItemHandle)this.designHandle.findElement("data1")).getStringProperty("backgroundColor"));
    }
}

