/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ThemeTest
extends BaseTestCase {
    private ElementFactory factory = null;
    private ThemeHandle theme = null;
    private ThemeHandle theme1 = null;
    private SharedStyleHandle style1 = null;
    private SharedStyleHandle style2 = null;
    private TableHandle table = null;
    private LabelHandle label = null;
    private String LibA = "LibraryAIncludeTheme.xml";
    private String LibB = "LibraryBIncludeTheme.xml";
    private String LibC = "LibraryCIncludeTheme.xml";
    private String LibC1 = "LibraryCIncludeTheme_1.xml";
    private String LibCInclTheme = "LibraryCIncludeTheme.xml";
    private String lib = "ThemeTest2_1.xml";

    public ThemeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ThemeTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.LibA);
        this.copyInputToFile("input/" + this.LibB);
        this.copyInputToFile("input/" + this.LibC);
        this.copyInputToFile("input/" + this.LibC1);
        this.copyInputToFile("input/ThemeTest1.xml");
        this.copyInputToFile("input/ThemeTest2.xml");
        this.copyInputToFile("input/ThemeTest2_1.xml");
        this.copyInputToFile("input/" + this.LibCInclTheme);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testDefineThemes() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        this.library = (Library)this.libraryHandle.getModule();
        this.factory = new ElementFactory((Module)this.library);
        this.theme = this.factory.newTheme(null);
        this.theme1 = this.factory.newTheme(null);
        ThemeTest.assertEquals((String)"NewTheme", (String)this.theme.getName());
        this.libraryHandle.getThemes().add((DesignElementHandle)this.theme);
        this.libraryHandle.getThemes().add((DesignElementHandle)this.theme1);
        ThemeTest.assertEquals((String)"NewTheme1", (String)this.theme1.getName());
        this.style1 = this.factory.newStyle("Style1");
        this.style2 = this.factory.newStyle("Style2");
        this.theme.getStyles().add((DesignElementHandle)this.style1);
        this.theme.getStyles().add((DesignElementHandle)this.style2);
        ThemeTest.assertEquals((int)2, (int)this.theme.getStyles().getCount());
    }

    public void testUsingTheme() throws Exception {
        System.out.println("ThemeTest1.xml");
        this.openDesign("ThemeTest1.xml");
        this.designHandle.includeLibrary(this.LibA, "LibA");
        this.designHandle.includeLibrary(this.LibB, "LibB");
        this.table = (TableHandle)this.designHandle.findElement("mytable");
        this.label = (LabelHandle)this.designHandle.findElement("mylabel");
        ThemeTest.assertNotNull((Object)this.table);
        ThemeTest.assertNotNull((Object)this.label);
        this.designHandle.setThemeName("LibB.theme1");
        ThemeTest.assertEquals((Object)"dashed", (Object)this.table.getProperty("borderLeftStyle"));
        ThemeTest.assertEquals((Object)"green", (Object)this.label.getProperty("color"));
        this.designHandle.setThemeName("LibA.theme2");
        ThemeTest.assertEquals((String)"10pt", (String)this.table.getStringProperty("fontSize"));
        ThemeTest.assertEquals((String)"#808080", (String)this.table.getStringProperty("color"));
        ThemeTest.assertEquals((String)"10mm", (String)this.label.getStringProperty("marginTop"));
    }

    public void testThemeSearchAlgorithm() throws Exception {
        this.openDesign("ThemeTest2.xml");
        this.table = (TableHandle)this.designHandle.findElement("mytable");
        this.label = (LabelHandle)this.designHandle.findElement("mylabel");
        SharedStyleHandle RCS1 = this.designHandle.findStyle("mytable");
        SharedStyleHandle RCS2 = this.designHandle.findStyle("mylabel");
        SharedStyleHandle RSS1 = this.designHandle.findStyle("table");
        SharedStyleHandle RSS2 = this.designHandle.findStyle("label");
        ThemeTest.assertNotNull((Object)this.table);
        ThemeTest.assertNotNull((Object)this.label);
        ThemeTest.assertNotNull((Object)RCS1);
        ThemeTest.assertNotNull((Object)RCS2);
        ThemeTest.assertNotNull((Object)RSS1);
        ThemeTest.assertNotNull((Object)RSS2);
        this.openLibrary(this.LibCInclTheme, true);
        this.libraryHandle.saveAs(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + this.LibC1);
        StyleHandle LCS1 = this.libraryHandle.findTheme("theme1").findStyle("mytable");
        StyleHandle LCS2 = this.libraryHandle.findTheme("theme1").findStyle("mylabel");
        StyleHandle LSS1 = this.libraryHandle.findTheme("theme1").findStyle("table");
        StyleHandle LSS2 = this.libraryHandle.findTheme("theme1").findStyle("label");
        ThemeTest.assertNotNull((Object)LCS1);
        ThemeTest.assertNotNull((Object)LCS2);
        ThemeTest.assertNotNull((Object)LSS1);
        ThemeTest.assertNotNull((Object)LSS2);
        this.designHandle.includeLibrary(this.LibC1, "LibC");
        this.designHandle.setThemeName("LibC.theme1");
        this.table.setStyleName("mytable");
        this.label.setStyleName("mylabel");
        ThemeTest.assertEquals((String)"large", (String)this.table.getStringProperty("fontSize"));
        ThemeTest.assertEquals((String)"#0000FF", (String)this.label.getStringProperty("backgroundColor"));
        this.designHandle.getStyles().drop((DesignElementHandle)RCS1);
        this.designHandle.getStyles().drop((DesignElementHandle)RCS2);
        ThemeTest.assertEquals((String)"10pt", (String)this.table.getStringProperty("fontSize"));
        ThemeTest.assertEquals((String)"red", (String)this.label.getStringProperty("backgroundColor"));
        this.libraryHandle.findTheme("theme1").getStyles().drop((DesignElementHandle)LCS1);
        this.libraryHandle.findTheme("theme1").getStyles().drop((DesignElementHandle)LCS2);
        this.libraryHandle.save();
        this.openDesign("ThemeTest2_1.xml");
        ThemeTest.assertEquals((String)"100%", (String)this.designHandle.findElement("mytable").getStringProperty("fontSize"));
        ThemeTest.assertEquals((String)"aqua", (String)this.designHandle.findElement("mylabel").getStringProperty("backgroundColor"));
        ThemeTest.assertNotNull((Object)this.libraryHandle.findTheme("theme1").findStyle("table"));
        this.libraryHandle.findTheme("theme1").findStyle("label").drop();
        this.libraryHandle.save();
        this.openDesign("ThemeTest2_1.xml");
        ThemeTest.assertEquals((String)"100%", (String)this.designHandle.findElement("mytable").getStringProperty("fontSize"));
        ThemeTest.assertNotNull((Object)this.designHandle.findElement("mylabel").getStringProperty("backgroundColor"));
        this.openLibrary("LibraryCIncludeTheme_1.xml");
        this.libraryHandle.findTheme("theme1").drop();
        ThemeTest.assertNull((Object)this.libraryHandle.findTheme("LibC1.theme1"));
    }

    public void testLibraryUseTheme() throws Exception {
        this.openLibrary(this.LibA, true);
        this.library = (Library)this.libraryHandle.getModule();
        this.factory = new ElementFactory((Module)this.library);
        this.table = this.factory.newTableItem("mytable");
        this.label = this.factory.newLabel("mylabel");
        this.libraryHandle.getComponents().add((DesignElementHandle)this.table);
        this.libraryHandle.getComponents().add((DesignElementHandle)this.label);
        ThemeTest.assertNotNull((Object)this.libraryHandle.findElement("mytable"));
        ThemeTest.assertNotNull((Object)this.libraryHandle.findElement("mylabel"));
        this.libraryHandle.setThemeName("theme1");
        ThemeTest.assertEquals((String)"\"Arial\"", (String)this.libraryHandle.findElement("mytable").getStringProperty("fontFamily"));
        ThemeTest.assertEquals((String)"#FF0000", (String)this.libraryHandle.findElement("mytable").getStringProperty("color"));
        this.libraryHandle.setThemeName("theme2");
        ThemeTest.assertEquals((String)"10pt", (String)this.libraryHandle.findElement("mytable").getStringProperty("fontSize"));
        ThemeTest.assertEquals((String)"#808080", (String)this.libraryHandle.findElement("mytable").getStringProperty("color"));
        ThemeTest.assertEquals((String)"10mm", (String)this.libraryHandle.findElement("mylabel").getStringProperty("marginTop"));
    }

    public void testExportStyleToDefaultTheme() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        this.openDesign("ThemeTest2.xml");
        SharedStyleHandle RCS1 = this.designHandle.findStyle("mytable");
        SharedStyleHandle RCS2 = this.designHandle.findStyle("mylabel");
        SharedStyleHandle RSS1 = this.designHandle.findStyle("table");
        SharedStyleHandle RSS2 = this.designHandle.findStyle("label");
        ThemeTest.assertNotNull((Object)RCS1);
        ThemeTest.assertNotNull((Object)RCS2);
        ThemeTest.assertNotNull((Object)RSS1);
        ThemeTest.assertNotNull((Object)RSS2);
        ElementExportUtil.exportElement((DesignElementHandle)RCS1, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)RCS2, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)RSS1, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)RSS2, (LibraryHandle)this.libraryHandle, (boolean)false);
        ThemeTest.assertEquals((String)"mytable", (String)this.libraryHandle.getTheme().getStyles().get(0).getName());
        ThemeTest.assertEquals((String)"mylabel", (String)this.libraryHandle.getTheme().getStyles().get(1).getName());
        ThemeTest.assertEquals((String)"table", (String)this.libraryHandle.getTheme().getStyles().get(2).getName());
        ThemeTest.assertEquals((String)"label", (String)this.libraryHandle.getTheme().getStyles().get(3).getName());
    }

    public void testCopyPasteTheme() throws Exception {
        this.openLibrary(this.LibC, true);
        ThemeHandle defaulttheme = this.libraryHandle.findTheme("defaultTheme");
        ThemeHandle theme1 = this.libraryHandle.findTheme("theme1");
        ThemeTest.assertNotNull((Object)defaulttheme);
        ThemeTest.assertNotNull((Object)theme1);
        ThemeHandle defaultcopy = (ThemeHandle)defaulttheme.copy().getHandle(this.libraryHandle.getModule());
        ThemeHandle defaultcopy1 = (ThemeHandle)defaulttheme.copy().getHandle(this.libraryHandle.getModule());
        ThemeHandle theme1copy = (ThemeHandle)theme1.copy().getHandle(this.libraryHandle.getModule());
        ThemeHandle theme1copy1 = (ThemeHandle)theme1.copy().getHandle(this.libraryHandle.getModule());
        try {
            this.libraryHandle.getThemes().add((DesignElementHandle)defaultcopy);
            ThemeTest.fail();
        }
        catch (NameException e) {
            ThemeTest.assertNotNull((Object)((Object)e));
        }
        defaultcopy.setName("defaultTheme1");
        theme1copy.setName("theme11");
        this.libraryHandle.getThemes().add((DesignElementHandle)defaultcopy);
        this.libraryHandle.getThemes().add((DesignElementHandle)theme1copy);
        ThemeTest.assertEquals((String)"defaultTheme1", (String)this.libraryHandle.getThemes().get(2).getName());
        ThemeTest.assertEquals((String)"theme11", (String)this.libraryHandle.getThemes().get(3).getName());
        this.openLibrary(this.LibB);
        defaultcopy1.setName("defaultTheme1");
        theme1copy1.setName("theme11");
        this.libraryHandle.getThemes().add((DesignElementHandle)defaultcopy1);
        this.libraryHandle.getThemes().add((DesignElementHandle)theme1copy1);
        ThemeTest.assertEquals((String)"defaultTheme1", (String)this.libraryHandle.getThemes().get(2).getName());
        ThemeTest.assertEquals((String)"theme11", (String)this.libraryHandle.getThemes().get(3).getName());
    }
}

