/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class TocSupportTest
extends BaseTestCase {
    String fileName = "TocSupportTest.xml";
    String fileName1 = "TocSupportTest_1.xml";

    public TocSupportTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TocSupportTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        this.copyInputToFile("input/" + this.fileName1);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testTocProperty() throws Exception {
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("MyTable");
        TocSupportTest.assertNotNull((String)"should not be null", (Object)table);
        TocSupportTest.assertNull((Object)table.getTocExpression());
        table.setTocExpression("This Section");
        TocSupportTest.assertEquals((String)"This Section", (String)table.getTocExpression());
    }

    public void testGetAllToc() throws Exception {
        this.openDesign(this.fileName1);
        TocSupportTest.assertEquals((int)2, (int)this.designHandle.getAllTocs().size());
        TextItemHandle text = (TextItemHandle)this.designHandle.findElement("mytext");
        text.setTocExpression("Mytext");
        TocSupportTest.assertEquals((int)3, (int)this.designHandle.getAllTocs().size());
        this.designHandle.getCommandStack().undo();
        TocSupportTest.assertEquals((int)2, (int)this.designHandle.getAllTocs().size());
        this.designHandle.getCommandStack().redo();
        text.clearProperty("toc");
        TocSupportTest.assertEquals((int)2, (int)this.designHandle.getAllTocs().size());
    }
}

