/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_161383
extends BaseTestCase {
    private static final String REPORT = "regression_161383.xml";
    private static final String REPORT1 = "regression_161383_1.xml";
    private static final String REPORT2 = "regression_161383_2.xml";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_161383.xml");
        this.copyInputToFile("input/regression_161383_1.xml");
        this.copyInputToFile("input/regression_161383_2.xml");
    }

    public void tearDown() {
        this.removeResource();
    }

    public void test_regression_161383() throws SemanticException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = session.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        LabelHandle label = factory.newLabel("label");
        designHandle.getBody().add((DesignElementHandle)label);
        label.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)label.getStringProperty("pageBreakInside"));
        TextItemHandle text = factory.newTextItem("text");
        designHandle.getBody().add((DesignElementHandle)text);
        text.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)text.getStringProperty("pageBreakInside"));
        ImageHandle image = factory.newImage("image");
        designHandle.getBody().add((DesignElementHandle)image);
        image.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)image.getStringProperty("pageBreakInside"));
        DataItemHandle data = factory.newDataItem("data");
        designHandle.getBody().add((DesignElementHandle)data);
        data.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)data.getStringProperty("pageBreakInside"));
        TextDataHandle dtext = factory.newTextData("dtext");
        designHandle.getBody().add((DesignElementHandle)dtext);
        dtext.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)dtext.getStringProperty("pageBreakInside"));
        GridHandle grid = factory.newGridItem("grid");
        designHandle.getBody().add((DesignElementHandle)grid);
        grid.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)grid.getStringProperty("pageBreakInside"));
        TableHandle table = factory.newTableItem("table");
        designHandle.getBody().add((DesignElementHandle)table);
        table.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)table.getStringProperty("pageBreakInside"));
        ListHandle list = factory.newList("list");
        designHandle.getBody().add((DesignElementHandle)list);
        list.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)list.getStringProperty("pageBreakInside"));
        ListHandle list1 = factory.newList("list");
        designHandle.getBody().add((DesignElementHandle)list1);
        ListGroupHandle listgroup = factory.newListGroup();
        list1.getGroups().add((DesignElementHandle)listgroup);
        ListGroupHandle group = (ListGroupHandle)list1.getGroups().get(0);
        group.setStringProperty("pageBreakInside", "avoid");
        group.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)group.getStringProperty("pageBreakInside"));
        TableHandle table3 = factory.newTableItem("table");
        designHandle.getBody().add((DesignElementHandle)table3);
        TableGroupHandle tablegroup = factory.newTableGroup();
        table3.getGroups().add((DesignElementHandle)tablegroup);
        TableGroupHandle group1 = (TableGroupHandle)table3.getGroups().get(0);
        group1.setStringProperty("pageBreakInside", "avoid");
        group1.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)group1.getStringProperty("pageBreakInside"));
        TableHandle table1 = factory.newTableItem("table1", 3, 1, 1, 1);
        designHandle.getBody().add((DesignElementHandle)table1);
        RowHandle row = (RowHandle)table1.getDetail().get(0);
        row.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)row.getStringProperty("pageBreakInside"));
        TableHandle table2 = factory.newTableItem("table2", 3, 1, 1, 1);
        designHandle.getBody().add((DesignElementHandle)table2);
        ColumnHandle column = (ColumnHandle)table2.getColumns().get(0);
        Regression_161383.assertNotNull((Object)column);
        try {
            column.setStringProperty("pageBreakInside", "avoid");
            Regression_161383.fail();
        }
        catch (SemanticException e) {
            Regression_161383.assertEquals((String)"Error.PropertyNameException.PROPERTY_NOT_VALID", (String)e.getErrorCode());
        }
    }

    public void test_regression_161383_1() throws DesignFileException, SemanticException {
        this.openDesign(REPORT);
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        RowHandle row1 = (RowHandle)table.getDetail().get(0);
        RowHandle row2 = (RowHandle)table.getHeader().get(0);
        SharedStyleHandle style1 = this.designHandle.findStyle("style1");
        style1.setStringProperty("pageBreakInside", "avoid");
        row1.setStyleName("style1");
        Regression_161383.assertEquals((String)"avoid", (String)row1.getStringProperty("pageBreakInside"));
        SharedStyleHandle style2 = this.designHandle.findStyle("table-header");
        style2.setStringProperty("pageBreakInside", "avoid");
        Regression_161383.assertEquals((String)"avoid", (String)row2.getStringProperty("pageBreakInside"));
    }

    public void test_regression_161383_2() throws DesignFileException, SemanticException {
        this.openDesign(REPORT1);
        this.libraryHandle = this.designHandle.getLibrary("LIB");
        Regression_161383.assertNotNull((Object)this.libraryHandle);
        TableHandle table = (TableHandle)this.libraryHandle.findElement("table");
        Regression_161383.assertNotNull((Object)table);
        TableHandle newtable = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)table, "newTable");
        this.designHandle.getBody().add((DesignElementHandle)newtable);
        RowHandle row = (RowHandle)newtable.getDetail().get(0);
        Regression_161383.assertEquals((String)"avoid", (String)row.getStringProperty("pageBreakInside"));
    }

    public void test_regression_161383_3() throws DesignFileException, SemanticException {
        this.openDesign(REPORT2);
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        Regression_161383.assertNotNull((Object)table);
        this.designHandle.setThemeName("LIB2.theme1");
        Regression_161383.assertEquals((String)"avoid", (String)table.getStringProperty("pageBreakInside"));
    }
}

