/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class EngintTaskLoggerTest
extends EngineCase {
    public void testLogger() throws Exception {
        Logger engineLogger = Logger.getAnonymousLogger();
        ByteArrayOutputStream engineOut = new ByteArrayOutputStream();
        StreamHandler engineHandler = new StreamHandler(engineOut, new SimpleFormatter());
        engineHandler.setLevel(Level.ALL);
        engineLogger.addHandler(engineHandler);
        engineLogger.setLevel(Level.ALL);
        Logger taskLogger = Logger.getAnonymousLogger();
        ByteArrayOutputStream taskOut = new ByteArrayOutputStream();
        StreamHandler taskHandler = new StreamHandler(taskOut, new SimpleFormatter());
        taskHandler.setLevel(Level.ALL);
        taskLogger.addHandler(taskHandler);
        taskLogger.setLevel(Level.ALL);
        this.engine.setLogger(engineLogger);
        this.engine.changeLogLevel(Level.ALL);
        engineHandler.flush();
        taskHandler.flush();
        new File("./utest/").mkdirs();
        this.copyResource("org/eclipse/birt/report/engine/api/engine-task-logger-test.rptdesign", "./utest/reportdesign.rptdesign");
        IReportRunnable runnable = this.engine.openReportDesign("./utest/reportdesign.rptdesign");
        IRunTask task = this.engine.createRunTask(runnable);
        task.setParameter("sample", (Object)"==golden values==", "displayText");
        task.run("./utest/report.rptdocument");
        task.close();
        engineHandler.flush();
        EngintTaskLoggerTest.assertTrue((engineOut.toString().indexOf("==golden values==") != -1 ? 1 : 0) != 0);
        engineOut.reset();
        task = this.engine.createRunTask(runnable);
        task.setLogger(taskLogger);
        task.setParameter("sample", (Object)"==golden values==", "displayText");
        task.run("./utest/report.rptdocument");
        task.close();
        engineHandler.flush();
        taskHandler.flush();
        EngintTaskLoggerTest.assertTrue((engineOut.toString().indexOf("==golden values==") == -1 ? 1 : 0) != 0);
        EngintTaskLoggerTest.assertTrue((taskOut.toString().indexOf("==golden values==") != -1 ? 1 : 0) != 0);
    }

    public void testRollingLogger() throws Exception {
        this.doTestRollingLog(100000, 5, 1);
        this.doTestRollingLog(10, 5, 5);
        this.doTestRollingLog(-1, 5, 1);
    }

    private void doTestRollingLog(int logRollingSize, int maxBackupIndex, int expectLogNum) throws EngineException {
        EngineConfig config = new EngineConfig();
        String tmpPath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + System.nanoTime();
        config.setLogConfig(tmpPath, Level.ALL);
        config.setLogRollingSize(logRollingSize);
        config.setLogMaxBackupIndex(maxBackupIndex);
        this.engine = this.createReportEngine(config);
        this.engine.changeLogLevel(Level.ALL);
        new File("./utest/").mkdirs();
        this.copyResource("org/eclipse/birt/report/engine/api/engine-task-logger-test.rptdesign", "./utest/reportdesign.rptdesign");
        IReportRunnable runnable = this.engine.openReportDesign("./utest/reportdesign.rptdesign");
        IRunTask task = this.engine.createRunTask(runnable);
        task.setParameter("sample", (Object)"==golden values==", "displayText");
        task.run("./utest/report.rptdocument");
        task.close();
        task = this.engine.createRunTask(runnable);
        task.setParameter("sample", (Object)"==golden values==", "displayText");
        task.run("./utest/report.rptdocument");
        task.close();
        this.engine.destroy();
        File tmpDir = new File(tmpPath);
        File[] logFiles = tmpDir.listFiles(new FilenameFilter(){

            public boolean accept(File parent, String name) {
                return name.matches(".*log\\.?[0-9]*?$");
            }
        });
        int logFileNum = logFiles.length;
        File[] fileArray = logFiles;
        int n = logFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        tmpDir.delete();
        EngintTaskLoggerTest.assertEquals((int)expectLogNum, (int)logFileNum);
    }
}

