/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.RunnableMonitor;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class MutipleThreadRenderTest
extends EngineCase {
    static final String REPORT_DOCUMENT = "./utest/report.rptdocument";
    static final String REPORT_DOCUMENT_FOLDER = "./utest/report.rptdocument.folder/";
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/mutiple-thread-render.rptdesign";
    static final String REPORT_DESIGN = "./utest/report.rptdesign";
    int THREAD_COUNT = 20;
    int runningThread;

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(REPORT_DOCUMENT_FOLDER);
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void tearDown() {
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT_FOLDER);
    }

    public void testMutipleThreadWithProgressive() throws Exception {
        RunnableMonitor monitor = new RunnableMonitor();
        new CreateDocument(monitor);
        int i = 0;
        while (i < 2) {
            new RenderEachPageToHTML(monitor);
            ++i;
        }
        i = 0;
        while (i < 2) {
            new RenderEachPageToPDF(monitor);
            ++i;
        }
        i = 0;
        while (i < 2) {
            new RenderFullToHTML(monitor);
            ++i;
        }
        i = 0;
        while (i < 2) {
            new RenderFullToPDF(monitor);
            ++i;
        }
        monitor.start();
        monitor.printStackTrace();
        MutipleThreadRenderTest.assertTrue((boolean)monitor.getFailedRunnables().isEmpty());
    }

    public void testMutipleThreadRenderShareDocument() throws Exception {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        try {
            task.run(REPORT_DOCUMENT);
        }
        finally {
            task.close();
        }
        IReportDocument reportDoc = this.engine.openReportDocument(REPORT_DOCUMENT);
        RenderRunnable[] renders = new RenderRunnable[this.THREAD_COUNT];
        int i = 0;
        while (i < this.THREAD_COUNT) {
            renders[i] = new RenderRunnable(this.engine, reportDoc);
            new Thread(renders[i]).start();
            ++i;
        }
        long waitingTime = 0L;
        while (this.runningThread > 0) {
            Thread.sleep(200L);
            if ((waitingTime += 200L) <= 20000L) continue;
            MutipleThreadRenderTest.fail();
        }
        reportDoc.close();
        String golden = renders[0].output.toString();
        MutipleThreadRenderTest.assertTrue((golden.length() != 0 ? 1 : 0) != 0);
        int i2 = 1;
        while (i2 < this.THREAD_COUNT) {
            String value = renders[i2].output.toString();
            MutipleThreadRenderTest.assertEquals((String)golden, (String)value);
            ++i2;
        }
    }

    class CreateDocument
    extends RunnableMonitor.Runnable {
        CreateDocument(RunnableMonitor monitor) {
            super(monitor);
        }

        public void doRun() throws Exception {
            System.out.println("start run document");
            IReportRunnable report = MutipleThreadRenderTest.this.engine.openReportDesign(MutipleThreadRenderTest.REPORT_DESIGN);
            IRunTask task = MutipleThreadRenderTest.this.engine.createRunTask(report);
            try {
                task.run(MutipleThreadRenderTest.REPORT_DOCUMENT_FOLDER);
            }
            finally {
                task.close();
            }
            System.out.println("end run document");
        }
    }

    class RenderEachPageToHTML
    extends RunnableMonitor.Runnable {
        RenderEachPageToHTML(RunnableMonitor monitor) {
            super(monitor);
        }

        /*
         * Exception decompiling
         */
        public void doRun() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class RenderEachPageToPDF
    extends RunnableMonitor.Runnable {
        RenderEachPageToPDF(RunnableMonitor monitor) {
            super(monitor);
        }

        /*
         * Exception decompiling
         */
        public void doRun() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class RenderFullToHTML
    extends RunnableMonitor.Runnable {
        RenderFullToHTML(RunnableMonitor monitor) {
            super(monitor);
        }

        /*
         * Exception decompiling
         */
        public void doRun() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class RenderFullToPDF
    extends RunnableMonitor.Runnable {
        RenderFullToPDF(RunnableMonitor monitor) {
            super(monitor);
        }

        /*
         * Exception decompiling
         */
        public void doRun() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class RenderRunnable
    implements Runnable {
        IReportDocument document;
        IReportEngine engine;
        ByteArrayOutputStream output;

        RenderRunnable(IReportEngine engine, IReportDocument document) {
            this.engine = engine;
            this.document = document;
            this.output = new ByteArrayOutputStream();
            ++MutipleThreadRenderTest.this.runningThread;
        }

        public void run() {
            try {
                try {
                    long pageCount = this.document.getPageCount();
                    long i = 1L;
                    while (i <= pageCount) {
                        IRenderTask task = this.engine.createRenderTask(this.document);
                        HTMLRenderOption option = new HTMLRenderOption();
                        option.setOutputFormat("html");
                        option.setOutputStream((OutputStream)this.output);
                        task.setRenderOption((IRenderOption)option);
                        task.setPageNumber(i);
                        task.render();
                        task.close();
                        ++i;
                    }
                }
                catch (Exception exception) {
                    MutipleThreadRenderTest.fail();
                    --MutipleThreadRenderTest.this.runningThread;
                }
            }
            finally {
                --MutipleThreadRenderTest.this.runningThread;
            }
        }
    }
}

