/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;

public class PageHandlerTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/page-handler.rptdesign";
    static final String REPORT_DESIGN = "page-handler.rptdesign";
    static final String REPORT_DOCUMENT = "./reportdocument.rptdocument";

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void tearDown() {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    public void testHandlerOfRunTask() {
        long[] pageNumberStatus = new long[]{1L, 2L, 3L, 3L};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[3] = true;
        boolean[] checkPointStatus = blArray;
        try {
            IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
            IRunTask task = this.engine.createRunTask(report);
            task.setPageHandler((IPageHandler)new TestPageHandler(pageNumberStatus, checkPointStatus));
            task.run(REPORT_DOCUMENT);
            task.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PageHandlerTest.fail();
        }
    }

    public void testHandlerOfRunAndRenderTask() {
        this.testRunAndRender("html", 1L, 2L, 3L, 3L);
    }

    private void testRunAndRender(String format, long ... pageNumberStatus) {
        try {
            boolean[] checkPointStatus = new boolean[pageNumberStatus.length];
            IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(report);
            HTMLRenderOption options = new HTMLRenderOption();
            options.setHtmlPagination(true);
            options.setOutputFormat(format);
            task.setRenderOption((IRenderOption)options);
            TestPageHandler handler = new TestPageHandler(pageNumberStatus, checkPointStatus);
            task.setPageHandler((IPageHandler)handler);
            task.run();
            PageHandlerTest.assertEquals((int)pageNumberStatus.length, (int)handler.getCallCount());
            task.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PageHandlerTest.fail();
        }
    }

    public void testHandlerOfRenderTask() {
        this.testRender("html", 1L, 2L, 3L, 3L);
        this.testRender("pdf", 1L, 2L, 3L, 3L);
    }

    private void testRender(String format, long ... pageNumberStatus) {
        try {
            IReportDocument document = this.createReportDocument(REPORT_DESIGN_RESOURCE);
            IRenderTask task = this.engine.createRenderTask(document);
            HTMLRenderOption options = new HTMLRenderOption();
            options.setHtmlPagination(true);
            options.setOutputFormat(format);
            task.setRenderOption((IRenderOption)options);
            TestPageHandler handler = new TestPageHandler(pageNumberStatus, new boolean[pageNumberStatus.length]);
            task.setPageHandler((IPageHandler)handler);
            task.render();
            task.close();
            PageHandlerTest.assertEquals((int)pageNumberStatus.length, (int)handler.getCallCount());
            document.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PageHandlerTest.fail();
        }
    }

    class TestPageHandler
    implements IPageHandler {
        int callBackCount = 0;
        private long[] pageNumberStatus;
        private boolean[] checkPointStatus;

        public TestPageHandler(long[] pageNumbers, boolean[] checkPointStatus) {
            this.pageNumberStatus = pageNumbers;
            this.checkPointStatus = checkPointStatus;
        }

        public void onPage(int pageNumber, boolean checkpoint, IReportDocumentInfo doc) {
            PageHandlerTest.assertEquals((long)this.pageNumberStatus[this.callBackCount], (long)pageNumber);
            PageHandlerTest.assertEquals((boolean)this.checkPointStatus[this.callBackCount], (boolean)checkpoint);
            ++this.callBackCount;
        }

        public int getCallCount() {
            return this.callBackCount;
        }
    }
}

