/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class ProgressiveViewingTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/progressive_viewing.rptdesign";
    static final String REPORT_DESIGN = "progressive_viewing.rptdesign";
    static final String REPORT_DOCUMENT = "./reportdocument";
    ArrayList pages = new ArrayList();

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void tearDown() {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    public void testProgressiveViewing() {
        try {
            IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
            IRunTask task = this.engine.createRunTask(report);
            task.setPageHandler((IPageHandler)new RenderTaskTrigger());
            task.run(REPORT_DOCUMENT);
            task.close();
            int i = 0;
            while (i < this.pages.size()) {
                PageContent pageContent = (PageContent)this.pages.get(i);
                IReportDocument reportDocument = this.engine.openReportDocument(REPORT_DOCUMENT);
                IRenderTask renderTask = this.engine.createRenderTask(reportDocument);
                HTMLRenderOption options = new HTMLRenderOption();
                options.setOutputFormat("html");
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                options.setOutputStream((OutputStream)ostream);
                renderTask.setRenderOption((IRenderOption)options);
                renderTask.setPageNumber((long)pageContent.page);
                renderTask.render();
                ProgressiveViewingTest.assertTrue((boolean)renderTask.getErrors().isEmpty());
                renderTask.close();
                reportDocument.close();
                String content = ostream.toString("utf-8");
                ProgressiveViewingTest.assertEquals((String)content, (String)pageContent.content);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ProgressiveViewingTest.fail();
        }
    }

    class PageContent {
        int page;
        String content;

        PageContent(int page, String content) {
            this.page = page;
            this.content = content;
        }
    }

    class RenderTaskTrigger
    implements IPageHandler {
        IRenderTask renderTask;

        RenderTaskTrigger() {
        }

        public void onPage(int pageNumber, boolean checkpoint, IReportDocumentInfo doc) {
            try {
                if (checkpoint) {
                    IReportDocument reportDocument = doc.openReportDocument();
                    this.renderTask = ProgressiveViewingTest.this.engine.createRenderTask(reportDocument);
                    HTMLRenderOption options = new HTMLRenderOption();
                    options.setOutputFormat("html");
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    options.setOutputStream((OutputStream)ostream);
                    this.renderTask.setRenderOption((IRenderOption)options);
                    this.renderTask.setPageNumber((long)pageNumber);
                    this.renderTask.render();
                    this.renderTask.close();
                    reportDocument.close();
                    ProgressiveViewingTest.assertTrue((boolean)this.renderTask.getErrors().isEmpty());
                    String content = ostream.toString("utf-8");
                    ProgressiveViewingTest.assertTrue((content.length() > 1024 ? 1 : 0) != 0);
                    ProgressiveViewingTest.this.pages.add(new PageContent(pageNumber, content));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ProgressiveViewingTest.fail();
            }
        }
    }
}

