/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.RenderOption;

public class RenderTaskTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/render_task_design.xml";

    public void setUp() {
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.engine = this.createReportEngine();
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    public void testRenderOnTransientFile() throws Exception {
        ArchiveFile archive = new ArchiveFile("reportdocument", "rw");
        IReportRunnable report = this.engine.openReportDesign("design.rptdesign");
        IRunTask task = this.engine.createRunTask(report);
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)archive);
        task.run((IDocArchiveWriter)writer);
        task.close();
        archive.saveAs("test.archive");
        ArchiveReader reader = new ArchiveReader((IArchiveFile)archive);
        IReportDocument reportDoc = this.engine.openReportDocument(null, (IDocArchiveReader)reader, new HashMap());
        RenderTaskTest.assertTrue((boolean)reportDoc.getVersion().equals("2.6.1"));
        IRenderTask renderTask = this.engine.createRenderTask(reportDoc);
        long pageNumber = reportDoc.getPageCount();
        RenderTaskTest.assertEquals((long)3L, (long)pageNumber);
        long i = 1L;
        while (i <= pageNumber) {
            renderTask.setPageNumber(i);
            this.assertRender(renderTask, "page" + i + ".html");
            ++i;
        }
        archive.close();
    }

    public void testRender() {
        try {
            this.createReportDocument();
            this.doRenderTest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenderTaskTest.fail();
        }
    }

    protected void doRenderTest() throws Exception {
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        RenderTaskTest.assertTrue((boolean)reportDoc.getVersion().equals("2.6.1"));
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        long pageNumber = reportDoc.getPageCount();
        RenderTaskTest.assertEquals((long)3L, (long)pageNumber);
        long i = 1L;
        while (i <= pageNumber) {
            task.setPageNumber(i);
            this.assertRender(task, "page" + i + ".html");
            ++i;
        }
        task.setPageRange("1, 3");
        this.assertRender(task, "page13.html");
        task.setPageRange("1-2, 3");
        this.assertRender(task, "page123.html");
        task.setPageRange("all");
        this.assertRender(task, "pageAll.html");
        task.setBookmark("__TOC_0");
        this.assertRender(task, "pageToc0.html");
        task.setBookmark("__TOC_1");
        this.assertRender(task, "pageToc1.html");
        task.setBookmark("__TOC_2");
        this.assertRender(task, "pageToc2.html");
        task.close();
        reportDoc.close();
    }

    private void assertRender(IRenderTask task, String outputFileName) throws EngineException {
        this.removeFile(outputFileName);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputFileName(outputFileName);
        task.setRenderOption((IRenderOption)option);
        task.render();
        File htmlFile = new File(outputFileName);
        RenderTaskTest.assertTrue((boolean)htmlFile.exists());
        RenderTaskTest.assertTrue((htmlFile.length() != 0L ? 1 : 0) != 0);
        this.removeFile(outputFileName);
    }

    public void testRenderPDFFromDocument() throws Exception {
        String outputFileName = ".render_pdf_from_document.pdf";
        this.createReportDocument();
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("pdf");
        option.setOutputFileName(outputFileName);
        task.setRenderOption((IRenderOption)option);
        task.render();
        File pdfFile = new File(outputFileName);
        RenderTaskTest.assertTrue((boolean)pdfFile.exists());
        RenderTaskTest.assertTrue((pdfFile.length() != 0L ? 1 : 0) != 0);
        this.removeFile(outputFileName);
        task.close();
        reportDoc.close();
    }

    public void testCloseOnExitRenderOption() throws EngineException {
        String[] formats;
        String design = "org/eclipse/birt/report/engine/api/testCloseOnExit.rptdesign";
        IReportDocument document = this.createReportDocument(design);
        String[] stringArray = formats = new String[]{"html", "pdf", "postscript", "ppt", "doc", "xls"};
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            RenderTaskTest.assertEquals((boolean)false, (boolean)this.isRenderTaskCloseStreamOnExit(document, format, false));
            RenderTaskTest.assertEquals((boolean)true, (boolean)this.isRenderTaskCloseStreamOnExit(document, format, true));
            ++n2;
        }
        document.close();
    }

    public void testGetPageCount() throws EngineException {
        String design = "org/eclipse/birt/report/engine/api/TestGetPageCount.rptdesign";
        IReportDocument document = this.createReportDocument(design);
        this.test(document, "pdf");
        this.test(document, "html");
    }

    private void test(IReportDocument document, String format) throws EngineException {
        this.testRenderPageCount(document, 1, format, new RenderItemSetter(){

            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setReportlet("grid");
            }
        });
        this.testRenderPageCount(document, 1, format, new RenderItemSetter(){

            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setPageNumber(1L);
            }
        });
        this.testRenderPageCount(document, 2, format, new RenderItemSetter(){

            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setPageRange("1,3");
            }
        });
        this.testRenderPageCount(document, 4, format, new RenderItemSetter(){

            public void setRenderItem(IRenderTask task) throws EngineException {
                task.setPageRange("all");
            }
        });
    }

    private void testRenderPageCount(IReportDocument document, int expectedPageCount, String format, RenderItemSetter renderItemSetter) throws EngineException {
        IRenderTask task = this.createRenderTask(document, format);
        renderItemSetter.setRenderItem(task);
        task.render();
        long pageCount = task.getPageCount();
        task.close();
        RenderTaskTest.assertEquals((long)expectedPageCount, (long)pageCount);
    }

    private IRenderTask createRenderTask(IReportDocument document, String format) {
        IRenderTask task = this.engine.createRenderTask(document);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat(format);
        options.setOutputStream((OutputStream)new ByteArrayOutputStream());
        options.setHtmlPagination(true);
        task.setRenderOption((IRenderOption)options);
        return task;
    }

    private boolean isRenderTaskCloseStreamOnExit(IReportDocument document, String format, boolean closeOnExit) throws EngineException {
        IRenderTask task = this.engine.createRenderTask(document);
        RenderOption options = new RenderOption();
        options.setOutputFormat(format);
        TestOutputStream output = new TestOutputStream();
        options.setOutputStream((OutputStream)output);
        options.closeOutputStreamOnExit(closeOnExit);
        task.setRenderOption((IRenderOption)options);
        task.render();
        task.close();
        return output.isClosed();
    }

    private static interface RenderItemSetter {
        public void setRenderItem(IRenderTask var1) throws EngineException;
    }

    private static class TestOutputStream
    extends FilterOutputStream {
        private boolean isClosed = false;

        public TestOutputStream() {
            super(new ByteArrayOutputStream());
        }

        public void close() throws IOException {
            super.close();
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

