/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ReportRunnableTest
extends EngineCase {
    protected IReportRunnable runnable = null;
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/ReportRunnableTest.rptdesign";
    static final String REPORT_DESIGN = "ReportRunnableTest.rptdesign";

    public void setUp() throws Exception {
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.engine = this.createReportEngine();
        this.runnable = this.engine.openReportDesign(REPORT_DESIGN);
    }

    public void tearDown() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        this.removeFile(REPORT_DESIGN);
    }

    public void testGetImage() {
        try {
            IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
            IImage img = runnable.getImage("img.jpg");
            ReportRunnableTest.assertTrue((img != null ? 1 : 0) != 0);
            ReportRunnableTest.assertEquals((Object)runnable, (Object)img.getReportRunnable());
            ReportRunnableTest.assertTrue((boolean)"img.jpg".equals(img.getID()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportRunnableTest.fail();
        }
    }

    public void testGetDesignHandle() {
        IReportRunnable runnableA = null;
        DesignElementHandle designHandleA = null;
        try {
            runnableA = this.engine.openReportDesign(REPORT_DESIGN);
            designHandleA = runnableA.getDesignHandle();
            ReportRunnableTest.assertTrue((designHandleA != null ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportRunnableTest.fail();
        }
    }

    public void testRerenderTask() throws Exception {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask runTask = this.engine.createRunTask(report);
        runTask.run("reportdocument");
        runTask.close();
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        IReportRunnable pRunnable = reportDoc.getPreparedRunnable();
        IRenderTask task = this.engine.createRenderTask(reportDoc, pRunnable);
        HTMLRenderOption option = new HTMLRenderOption();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        option.setOutputStream((OutputStream)out);
        task.setRenderOption((IRenderOption)option);
        task.render();
        String outputString = out.toString();
        ReportRunnableTest.assertTrue((outputString.indexOf("after onPrepare") > 0 ? 1 : 0) != 0);
        task.close();
        reportDoc.close();
    }
}

