/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;

public class EngineLoggerTest
extends TestCase {
    static final String FINE_LOG = "FINE_LOG_RECORD";
    static final String FINEST_LOG = "FINEST_LOG_RECORD";
    static final String WARNING_LOG = "WARNING_LOG_RECORD";
    private static FileHandler rootLoggerHandler;

    public void setUp() {
        this.removeFile(new File("./utest"));
        new File("./utest/").mkdirs();
    }

    private static void setupRootLogger(String logFile, Level logLevel) throws IOException {
        Logger logger = Logger.getLogger("");
        if (rootLoggerHandler == null) {
            rootLoggerHandler = new FileHandler(logFile);
            logger.addHandler(rootLoggerHandler);
        }
        logger.setLevel(logLevel);
    }

    private void removeRootLogger() {
        if (rootLoggerHandler != null) {
            Logger logger = Logger.getLogger("");
            logger.removeHandler(rootLoggerHandler);
            rootLoggerHandler.close();
            rootLoggerHandler = null;
        }
    }

    public void tearDown() {
        this.removeFile(new File("./utest/"));
    }

    public void testDefaultLogger() throws Exception {
        EngineLoggerTest.setupRootLogger("./utest/logger.txt", Level.FINE);
        try {
            EngineLogger.startEngineLogging(null, null, null, null, (int)0, (int)0);
            EngineLoggerTest.log();
            EngineLogger.stopEngineLogging();
        }
        finally {
            this.removeRootLogger();
        }
        this.checkLogging("./utest/logger.txt", 0, 1, 1);
    }

    public void testFileLogger() throws Exception {
        EngineLogger.startEngineLogging(null, (String)"./utest/", (String)"filelogger.txt", (Level)Level.OFF, (int)0, (int)0);
        EngineLoggerTest.log();
        EngineLoggerTest.assertFalse((boolean)new File("./utest/filelogger.txt").exists());
        EngineLogger.changeLogLevel((Level)Level.WARNING);
        EngineLoggerTest.log();
        EngineLoggerTest.assertTrue((boolean)new File("./utest/filelogger.txt").exists());
        EngineLogger.stopEngineLogging();
        this.checkLogging("./utest/filelogger.txt", 0, 0, 1);
    }

    public void testUserLogger() throws Exception {
        FileHandler fileHandle = new FileHandler("./utest/logger.txt");
        try {
            Logger logger = Logger.getAnonymousLogger();
            logger.addHandler(fileHandle);
            logger.setLevel(Level.ALL);
            logger.setUseParentHandlers(false);
            try {
                EngineLogger.startEngineLogging((Logger)logger, null, null, (Level)Level.FINE, (int)0, (int)0);
                EngineLoggerTest.log();
                EngineLogger.setLogger(null);
                EngineLoggerTest.log();
                EngineLogger.stopEngineLogging();
            }
            finally {
                logger.removeHandler(fileHandle);
            }
        }
        finally {
            fileHandle.close();
        }
        this.checkLogging("./utest/logger.txt", 0, 1, 1);
    }

    public void testThreadLogger() throws Exception {
        EngineLoggerTest.setupRootLogger("./utest/logger.txt", Level.FINEST);
        try {
            EngineLogger.startEngineLogging(null, null, null, null, (int)0, (int)0);
            EngineLoggerTest.logThread("./utest/logger1.txt", Level.WARNING);
            EngineLoggerTest.logThread("./utest/logger2.txt", Level.FINE);
            EngineLoggerTest.log();
            EngineLogger.stopEngineLogging();
        }
        finally {
            this.removeRootLogger();
        }
        EngineLoggerTest.waitLogThreads();
        this.checkLogging("./utest/logger.txt", 1, 1, 1);
        this.checkLogging("./utest/logger1.txt", 0, 0, 1);
        this.checkLogging("./utest/logger2.txt", 0, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitLogThreads() {
        while (LogThread.count.get() > 0) {
            AtomicInteger atomicInteger = LogThread.count;
            synchronized (atomicInteger) {
                try {
                    LogThread.count.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void logThread(String logFile, Level logLevel) {
        new Thread(new LogThread(logFile, logLevel)).start();
    }

    private static void log() {
        Logger logger = Logger.getLogger("org.eclipse.birt.report.engine");
        logger.log(Level.FINEST, FINEST_LOG);
        logger.log(Level.FINE, FINE_LOG);
        logger.log(Level.WARNING, WARNING_LOG);
    }

    private String getFileContent(String fileName) throws IOException {
        FileInputStream in = new FileInputStream(fileName);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int readSize = in.read(buffer);
            while (readSize > 0) {
                out.write(buffer, 0, readSize);
                readSize = in.read(buffer);
            }
            String string = out.toString("utf-8");
            return string;
        }
        finally {
            in.close();
        }
    }

    static int count(String buffer, String pattern) {
        Matcher matcher = Pattern.compile(pattern).matcher(buffer);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    private void checkLogging(String logFile, int finestCount, int fineCount, int warningCount) throws IOException {
        String content = this.getFileContent(logFile);
        EngineLoggerTest.assertEquals((int)finestCount, (int)EngineLoggerTest.count(content, FINEST_LOG));
        EngineLoggerTest.assertEquals((int)fineCount, (int)EngineLoggerTest.count(content, FINE_LOG));
        EngineLoggerTest.assertEquals((int)warningCount, (int)EngineLoggerTest.count(content, WARNING_LOG));
    }

    private void removeFile(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.removeFile(child);
                ++n2;
            }
        }
        file.delete();
    }

    private static class LogThread
    implements Runnable {
        static AtomicInteger count = new AtomicInteger();
        String logFile;
        Level logLevel;

        LogThread(String logFile, Level logLevel) {
            this.logFile = logFile;
            this.logLevel = logLevel;
            count.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                FileHandler handler = new FileHandler(this.logFile);
                try {
                    Logger logger = Logger.getAnonymousLogger();
                    logger.addHandler(handler);
                    logger.setLevel(this.logLevel);
                    logger.setUseParentHandlers(false);
                    EngineLogger.setThreadLogger((Logger)logger);
                    try {
                        EngineLoggerTest.log();
                    }
                    finally {
                        EngineLogger.setThreadLogger(null);
                    }
                }
                catch (Throwable throwable) {
                    handler.close();
                    count.decrementAndGet();
                    AtomicInteger atomicInteger = count;
                    synchronized (atomicInteger) {
                        count.notify();
                    }
                    throw throwable;
                }
                handler.close();
                count.decrementAndGet();
                AtomicInteger atomicInteger = count;
                synchronized (atomicInteger) {
                    count.notify();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

