/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DataGenerationEngine;
import org.eclipse.birt.report.engine.data.dte.DataPresentationEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.DesignFileException;

public class DataEngineTest
extends TestCase {
    private static final int MODE_GENERATION = 0;
    private static final int MODE_PRESENTATION = 1;
    private String SINGLE_DATASET_DESIGN = "SingleDataSet.xml";
    private String NESTED_DATASET_DESIGN = "NestedDataSet.xml";
    private String SUBQUERY_DATASET_DESIGN = "SubqueryDataSet.xml";
    private String ARCHIVE_PATH = "docArchive";
    private String ARCHIVE_METANAME = "metaName";
    IDocArchiveWriter archWriter;
    IDocArchiveReader archReader;

    private Report getReport(String designName) throws DesignFileException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(designName);
        DataEngineTest.assertTrue((in != null ? 1 : 0) != 0);
        ReportParser parser = new ReportParser();
        Report report = parser.parse("", in);
        DataEngineTest.assertTrue((report != null ? 1 : 0) != 0);
        return report;
    }

    private IDataEngine getDataEngine(Report report, String archivePath, String archiveMetaName, int mode) throws Exception {
        ExecutionContext context = new ExecutionContext();
        if (mode == 0) {
            this.archWriter = new FileArchiveWriter(archivePath);
            this.archWriter.initialize();
            DataGenerationEngine dataGenEngine = new DataGenerationEngine(null, context, this.archWriter);
            dataGenEngine.prepare(report, null);
            return dataGenEngine;
        }
        if (mode == 1) {
            this.archReader = new FileArchiveReader(archivePath);
            this.archReader.open();
            DataPresentationEngine dataPresEngine = new DataPresentationEngine(null, context, this.archReader);
            dataPresEngine.prepare(report, null);
            return dataPresEngine;
        }
        return null;
    }

    protected String loadResource(String resourceName) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        DataEngineTest.assertTrue((in != null ? 1 : 0) != 0);
        byte[] buffer = new byte[in.available()];
        in.read(buffer);
        return new String(buffer);
    }

    private void delete(File dir) {
        if (dir.isFile()) {
            dir.delete();
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 1;
            while (i < files.length) {
                this.delete(files[i]);
                ++i;
            }
            dir.delete();
        }
    }

    public void tearDown() {
        File file = new File(this.ARCHIVE_PATH);
        if (file.exists()) {
            this.delete(file);
        }
        if ((file = new File(this.ARCHIVE_METANAME)).exists()) {
            this.delete(file);
        }
    }

    public void test() throws Exception {
        this.doTestSingleQGeneration();
        this.doTestSingleQPresentation();
        this.doTestNestedQGeneration();
        this.doTestNestedQPresentation();
        this.doTestSubqueryGeneration();
        this.doTestSubqueryPresentation();
    }

    public void doTestSingleQGeneration() throws Exception {
        Report report = this.getReport(this.SINGLE_DATASET_DESIGN);
        IDataEngine dataEngine = this.getDataEngine(report, this.ARCHIVE_PATH, this.ARCHIVE_METANAME, 0);
        Iterator iter = report.getQueries().iterator();
        IQueryResultSet resultSet = null;
        String goldenFile = "SingleDataSet.txt";
        String goldenStr = this.loadResource(goldenFile);
        String resultStr = "";
        while (iter.hasNext()) {
            IQueryDefinition query = (IQueryDefinition)iter.next();
            Map map = query.getBindings();
            Object[] columns = map.keySet().toArray(new String[0]);
            Arrays.sort(columns);
            resultSet = (IQueryResultSet)dataEngine.execute((IDataQueryDefinition)query);
            int i = 0;
            while (resultSet.next() && i < 3) {
                int j = 0;
                while (j < columns.length) {
                    resultStr = String.valueOf(resultStr) + resultSet.getResultIterator().getString((String)columns[j]);
                    ++j;
                }
                ++i;
            }
        }
        resultSet.close();
        dataEngine.shutdown();
        this.archWriter.finish();
        DataEngineTest.assertEquals((String)goldenStr, (String)resultStr);
    }

    public void doTestSingleQPresentation() throws Exception {
        Report report = this.getReport(this.SINGLE_DATASET_DESIGN);
        IDataEngine dataEngine = this.getDataEngine(report, this.ARCHIVE_PATH, this.ARCHIVE_METANAME, 1);
        Iterator iter = report.getQueries().iterator();
        IQueryResultSet resultSet = null;
        String goldenFile = "SingleDataSet.txt";
        String goldenStr = this.loadResource(goldenFile);
        String resultStr = "";
        while (iter.hasNext()) {
            IQueryDefinition query = (IQueryDefinition)iter.next();
            Map map = query.getBindings();
            Object[] columns = map.keySet().toArray(new String[0]);
            Arrays.sort(columns);
            resultSet = (IQueryResultSet)dataEngine.execute((IDataQueryDefinition)query);
            int i = 0;
            while (resultSet.next() && i < 3) {
                int j = 0;
                while (j < columns.length) {
                    resultStr = String.valueOf(resultStr) + resultSet.getResultIterator().getString((String)columns[j]);
                    ++j;
                }
                ++i;
            }
        }
        resultSet.close();
        dataEngine.shutdown();
        this.archReader.close();
        DataEngineTest.assertEquals((String)goldenStr, (String)resultStr);
    }

    public void doTestNestedQGeneration() throws Exception {
        Report report = this.getReport(this.NESTED_DATASET_DESIGN);
        IDataEngine dataEngine = this.getDataEngine(report, this.ARCHIVE_PATH, this.ARCHIVE_METANAME, 0);
        Iterator iter = report.getQueries().iterator();
        String goldenFile = "NestedDataSet.txt";
        String goldenStr = this.loadResource(goldenFile);
        String resultStr = "";
        IQueryDefinition childQuery = (IQueryDefinition)iter.next();
        IQueryDefinition parentQuery = (IQueryDefinition)iter.next();
        IQueryResultSet parentRSet = null;
        IQueryResultSet childRSet = null;
        parentRSet = (IQueryResultSet)dataEngine.execute((IDataQueryDefinition)parentQuery);
        while (parentRSet.next()) {
            Map parentMap = parentQuery.getBindings();
            for (String nextPar : parentMap.keySet()) {
                Object value = parentRSet.getValue(nextPar);
                resultStr = value != null ? String.valueOf(resultStr) + value.toString() : String.valueOf(resultStr) + "null";
            }
            childRSet = (IQueryResultSet)dataEngine.execute((IBaseResultSet)parentRSet, (IDataQueryDefinition)childQuery, null, false);
            while (childRSet.next()) {
                Map map = childQuery.getBindings();
                Object[] columns = map.keySet().toArray(new String[0]);
                Arrays.sort(columns);
                int j = 0;
                while (j < columns.length) {
                    Object value = childRSet.getValue((String)columns[j]);
                    resultStr = value != null ? String.valueOf(resultStr) + value.toString() : String.valueOf(resultStr) + "null";
                    ++j;
                }
            }
            childRSet.close();
        }
        parentRSet.close();
        dataEngine.shutdown();
        this.archWriter.finish();
        DataEngineTest.assertEquals((String)goldenStr, (String)resultStr);
    }

    public void doTestNestedQPresentation() throws Exception {
        Report report = this.getReport(this.NESTED_DATASET_DESIGN);
        IDataEngine dataEngine = this.getDataEngine(report, this.ARCHIVE_PATH, this.ARCHIVE_METANAME, 1);
        Iterator iter = report.getQueries().iterator();
        String goldenFile = "NestedDataSet.txt";
        String goldenStr = this.loadResource(goldenFile);
        String resultStr = "";
        IQueryDefinition childQuery = (IQueryDefinition)iter.next();
        IQueryDefinition parentQuery = (IQueryDefinition)iter.next();
        IQueryResultSet parentRSet = null;
        IQueryResultSet childRSet = null;
        parentRSet = (IQueryResultSet)dataEngine.execute((IDataQueryDefinition)parentQuery);
        while (parentRSet.next()) {
            Map parentMap = parentQuery.getBindings();
            for (String nextPar : parentMap.keySet()) {
                Object value = parentRSet.getValue(nextPar);
                resultStr = value != null ? String.valueOf(resultStr) + value.toString() : String.valueOf(resultStr) + "null";
            }
            childRSet = (IQueryResultSet)dataEngine.execute((IBaseResultSet)parentRSet, (IDataQueryDefinition)childQuery, null, false);
            while (childRSet.next()) {
                Map map = childQuery.getBindings();
                Object[] columns = map.keySet().toArray(new String[0]);
                Arrays.sort(columns);
                int j = 0;
                while (j < columns.length) {
                    Object value = childRSet.getValue((String)columns[j]);
                    resultStr = value != null ? String.valueOf(resultStr) + value.toString() : String.valueOf(resultStr) + "null";
                    ++j;
                }
            }
            childRSet.close();
        }
        parentRSet.close();
        dataEngine.shutdown();
        this.archReader.close();
        DataEngineTest.assertEquals((String)goldenStr, (String)resultStr);
    }

    public void doTestSubqueryGeneration() throws Exception {
        Report report = this.getReport(this.SUBQUERY_DATASET_DESIGN);
        IDataEngine dataEngine = this.getDataEngine(report, this.ARCHIVE_PATH, this.ARCHIVE_METANAME, 0);
        Iterator iter = report.getQueries().iterator();
        IQueryResultSet resultSet = null;
        String goldenFile = "SubqueryDataSet.txt";
        String goldenStr = this.loadResource(goldenFile);
        String resultStr = "";
        while (iter.hasNext()) {
            IBaseQueryDefinition query = (IBaseQueryDefinition)iter.next();
            resultSet = (IQueryResultSet)dataEngine.execute((IDataQueryDefinition)query);
            while (resultSet.next()) {
                int startGroup = resultSet.getStartingGroupLevel();
                if (startGroup != 0 && startGroup != 1) continue;
                Iterator groupIterator = query.getGroups().iterator();
                IGroupDefinition group = (IGroupDefinition)groupIterator.next();
                Iterator subQueryIter = group.getSubqueries().iterator();
                IBaseQueryDefinition subQuery = (IBaseQueryDefinition)subQueryIter.next();
                IQueryResultSet subResultSet = (IQueryResultSet)dataEngine.execute((IBaseResultSet)resultSet, (IDataQueryDefinition)subQuery, null, false);
                Map map = subQuery.getBindings();
                resultStr = String.valueOf(resultStr) + this.getResultSet(subResultSet, map.keySet());
                subResultSet.close();
            }
        }
        resultSet.close();
        dataEngine.shutdown();
        this.archWriter.finish();
        DataEngineTest.assertEquals((String)goldenStr, (String)resultStr);
    }

    private String getResultSet(IQueryResultSet resultSet, Set columnsSet) throws Exception {
        String res = "";
        Object[] columns = columnsSet.toArray(new String[0]);
        Arrays.sort(columns);
        while (resultSet.next()) {
            int j = 0;
            while (j < columns.length) {
                res = String.valueOf(res) + resultSet.getString((String)columns[j]);
                ++j;
            }
        }
        return res;
    }

    public void doTestSubqueryPresentation() throws Exception {
        Report report = this.getReport(this.SUBQUERY_DATASET_DESIGN);
        IDataEngine dataEngine = this.getDataEngine(report, this.ARCHIVE_PATH, this.ARCHIVE_METANAME, 1);
        Iterator iter = report.getQueries().iterator();
        IQueryResultSet resultSet = null;
        String goldenFile = "SubqueryDataSet.txt";
        String goldenStr = this.loadResource(goldenFile);
        String resultStr = "";
        while (iter.hasNext()) {
            IBaseQueryDefinition query = (IBaseQueryDefinition)iter.next();
            resultSet = (IQueryResultSet)dataEngine.execute((IDataQueryDefinition)query);
            while (resultSet.next()) {
                int startGroup = resultSet.getStartingGroupLevel();
                if (startGroup != 0 && startGroup != 1) continue;
                Iterator groupIterator = query.getGroups().iterator();
                IGroupDefinition group = (IGroupDefinition)groupIterator.next();
                Iterator subQueryIter = group.getSubqueries().iterator();
                IBaseQueryDefinition subQuery = (IBaseQueryDefinition)subQueryIter.next();
                IQueryResultSet subResultSet = (IQueryResultSet)dataEngine.execute((IBaseResultSet)resultSet, (IDataQueryDefinition)subQuery, null, false);
                Map map = subQuery.getBindings();
                resultStr = String.valueOf(resultStr) + this.getResultSet(subResultSet, map.keySet());
                subResultSet.close();
            }
        }
        resultSet.close();
        dataEngine.shutdown();
        this.archReader.close();
        DataEngineTest.assertEquals((String)goldenStr, (String)resultStr);
    }
}

