/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DataGenerationEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.DesignFileException;

public class NamedExpressionTest
extends TestCase {
    private static final int MODE_GENERATION = 0;
    private String NAMED_EXPRESSION_DESIGN = "NamedExpression.xml";
    private String NAMED_EXPRESSION_FILENAME = "NamedExpression";

    private Report getReport(String designName) throws DesignFileException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(designName);
        NamedExpressionTest.assertTrue((in != null ? 1 : 0) != 0);
        ReportParser parser = new ReportParser();
        Report report = parser.parse("", in);
        NamedExpressionTest.assertTrue((report != null ? 1 : 0) != 0);
        return report;
    }

    private IDataEngine getDataEngine(Report report, IDocArchiveWriter arch, String archiveMetaName, int mode) throws Exception {
        ExecutionContext context = new ExecutionContext();
        if (mode == 0) {
            DataGenerationEngine dataGenEngine = new DataGenerationEngine(null, context, arch);
            dataGenEngine.prepare(report, null);
            return dataGenEngine;
        }
        return null;
    }

    protected String loadResource(String resourceName) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        NamedExpressionTest.assertTrue((in != null ? 1 : 0) != 0);
        byte[] buffer = new byte[in.available()];
        in.read(buffer);
        return new String(buffer);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.delete(this.NAMED_EXPRESSION_FILENAME);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delete(this.NAMED_EXPRESSION_FILENAME);
    }

    public void testNamedExpression() throws Exception {
        Report report = this.getReport(this.NAMED_EXPRESSION_DESIGN);
        assert (report.getContentCount() == 5);
        Map namedExpr = report.getContent(0).getUserProperties();
        NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
        namedExpr = report.getContent(1).getUserProperties();
        NamedExpressionTest.assertEquals((int)2, (int)namedExpr.size());
        namedExpr = report.getUserProperties();
        NamedExpressionTest.assertEquals((int)2, (int)namedExpr.size());
        ReportItemDesign reportItem = report.getContent(2);
        namedExpr = reportItem.getUserProperties();
        NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
        assert (reportItem instanceof TableItemDesign);
        TableItemDesign tableItem = (TableItemDesign)reportItem;
        TableBandDesign tableBand = (TableBandDesign)tableItem.getHeader();
        int i = 0;
        while (i < tableBand.getRowCount()) {
            this.assertRow(tableBand.getRow(i), 1);
            ++i;
        }
        tableBand = (TableBandDesign)tableItem.getFooter();
        i = 0;
        while (i < tableBand.getRowCount()) {
            this.assertRow(tableBand.getRow(i), 1);
            ++i;
        }
        tableBand = (TableBandDesign)tableItem.getDetail();
        i = 0;
        while (i < tableBand.getRowCount()) {
            this.assertRow(tableBand.getRow(i), 1);
            ++i;
        }
        GroupDesign tableGroup = tableItem.getGroup(0);
        tableBand = (TableBandDesign)tableGroup.getHeader();
        int i2 = 0;
        while (i2 < tableBand.getRowCount()) {
            this.assertRow(tableBand.getRow(i2), 1);
            ++i2;
        }
        tableBand = (TableBandDesign)tableGroup.getFooter();
        i2 = 0;
        while (i2 < tableBand.getRowCount()) {
            this.assertRow(tableBand.getRow(i2), 1);
            ++i2;
        }
        reportItem = report.getContent(3);
        namedExpr = reportItem.getUserProperties();
        NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
        assert (reportItem instanceof ListItemDesign);
        ListItemDesign listItem = (ListItemDesign)reportItem;
        ListBandDesign listBand = (ListBandDesign)listItem.getHeader();
        int i3 = 0;
        while (i3 < listBand.getContentCount()) {
            namedExpr = listBand.getContent(i3).getUserProperties();
            NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
            ++i3;
        }
        listBand = (ListBandDesign)listItem.getFooter();
        i3 = 0;
        while (i3 < listBand.getContentCount()) {
            namedExpr = listBand.getContent(i3).getUserProperties();
            NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
            ++i3;
        }
        listBand = (ListBandDesign)listItem.getDetail();
        i3 = 0;
        while (i3 < listBand.getContentCount()) {
            namedExpr = listBand.getContent(i3).getUserProperties();
            NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
            ++i3;
        }
        GroupDesign listGroup = listItem.getGroup(0);
        listBand = (ListBandDesign)listGroup.getHeader();
        int i4 = 0;
        while (i4 < listBand.getContentCount()) {
            namedExpr = listBand.getContent(i4).getUserProperties();
            NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
            ++i4;
        }
        listBand = (ListBandDesign)listGroup.getFooter();
        i4 = 0;
        while (i4 < listBand.getContentCount()) {
            namedExpr = listBand.getContent(i4).getUserProperties();
            NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
            ++i4;
        }
        reportItem = report.getContent(4);
        assert (reportItem instanceof GridItemDesign);
        GridItemDesign gridItem = (GridItemDesign)reportItem;
        namedExpr = gridItem.getUserProperties();
        NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
        int i5 = 0;
        while (i5 < gridItem.getRowCount()) {
            RowDesign row = gridItem.getRow(i5);
            namedExpr = row.getUserProperties();
            NamedExpressionTest.assertEquals((int)1, (int)namedExpr.size());
            ++i5;
        }
    }

    private void assertRow(RowDesign row, int expected) {
        Map namedExpr = row.getUserProperties();
        NamedExpressionTest.assertTrue((namedExpr != null ? 1 : 0) != 0);
        NamedExpressionTest.assertEquals((int)expected, (int)namedExpr.size());
    }

    private void delete(String fileName) {
        File delFile = new File(fileName);
        if (delFile.exists()) {
            delFile.delete();
        }
    }
}

