/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.css;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTMLProcessorTest
extends TestCase {
    protected String getStyle(HashMap styles, Object element, String property) {
        HashMap style = (HashMap)styles.get(element);
        return (String)style.get(property);
    }

    protected String getStyleAttribute(Element element, String attribute) {
        return element.getAttribute(attribute);
    }

    public void testExecute() throws Exception {
        Document doc = this.getDomTree();
        HashMap styles = new HashMap();
        new HTMLProcessor(null, null).execute((Element)doc.getFirstChild(), styles);
        Element iEle = (Element)doc.getFirstChild().getFirstChild();
        HTMLProcessorTest.assertEquals((String)iEle.getTagName(), (String)"span");
        HTMLProcessorTest.assertEquals((String)"red", (String)this.getStyle(styles, iEle, "color"));
        Element fontEle = (Element)iEle.getNextSibling();
        HTMLProcessorTest.assertEquals((String)fontEle.getTagName(), (String)"font");
        HTMLProcessorTest.assertEquals((String)"blue", (String)this.getStyleAttribute(fontEle, "color"));
        HTMLProcessorTest.assertEquals((String)"4", (String)this.getStyleAttribute(fontEle, "size"));
        HTMLProcessorTest.assertEquals((String)"news", (String)this.getStyleAttribute(fontEle, "face"));
        Element uEle = (Element)fontEle.getNextSibling();
        HTMLProcessorTest.assertEquals((String)uEle.getTagName(), (String)"span");
        HTMLProcessorTest.assertEquals((String)"overline underline", (String)this.getStyle(styles, uEle, "text-decoration"));
    }

    private Document getDomTree() throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element body = doc.createElement("body");
        doc.appendChild(body);
        Element iEle = doc.createElement("i");
        iEle.setAttribute("style", "color:red ");
        body.appendChild(iEle);
        Element fontEle = doc.createElement("font");
        fontEle.setAttribute("color", "blue");
        fontEle.setAttribute("size", "4");
        fontEle.setAttribute("face", "news");
        body.appendChild(fontEle);
        Element uEle = doc.createElement("u");
        uEle.setAttribute("style", "text-decoration:overline");
        body.appendChild(uEle);
        return doc;
    }
}

