/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.report.engine.toc.ByteArrayRAInputStream;
import org.eclipse.birt.report.engine.toc.ByteArrayRAOutputStream;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCReader;
import org.eclipse.birt.report.engine.toc.TOCTestCase;
import org.eclipse.birt.report.engine.toc.TOCWriter;

public class TOCVersionTest
extends TOCTestCase {
    static final String TOC_TREE_V1 = "toc.v1.dat";
    static final String TOC_TREE_V2 = "toc.v2.dat";
    static final String TOC_TREE_V3 = "toc.v3.dat";
    static final String GOLDEN_TOC = "<entry nodeId=\"null\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <entry nodeId=\"__TOC_1\" tocValue=\"list\">        <entry nodeId=\"__TOC_1_0\" tocValue=\"list-header\"/>        <group nodeId=\"__TOC_1_1\" tocValue=\"group\">            <entry nodeId=\"__TOC_1_1_0\" tocValue=\"list-group-header\"/>            <entry nodeId=\"__TOC_1_1_1\" tocValue=\"detail\"/>            <entry nodeId=\"__TOC_1_1_2\" tocValue=\"group-footer\"/>        </group>        <entry nodeId=\"__TOC_1_2\" tocValue=\"list-footer\"/>    </entry>    <entry nodeId=\"__TOC_2\" tocValue=\"footer\"/></entry>";
    static final String GOLDEN_TOC_V3 = "<entry nodeId=\"/\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <entry nodeId=\"__TOC_1\" tocValue=\"list\">        <entry nodeId=\"__TOC_2\" tocValue=\"list-header\"/>        <group nodeId=\"__TOC_3\" tocValue=\"group\">            <entry nodeId=\"__TOC_4\" tocValue=\"list-group-header\"/>            <entry nodeId=\"__TOC_5\" tocValue=\"detail\"/>            <entry nodeId=\"__TOC_6\" tocValue=\"group-footer\"/>        </group>        <entry nodeId=\"__TOC_7\" tocValue=\"list-footer\"/>    </entry>    <entry nodeId=\"__TOC_8\" tocValue=\"footer\"/></entry>";

    public void testReadV1() throws IOException {
        RAInputStream in = this.openResource(TOC_TREE_V1);
        TOCReader reader = new TOCReader(in, ((Object)((Object)this)).getClass().getClassLoader());
        TOCVersionTest.assertEquals((String)"__Version : 1.0", (String)reader.getVersion());
        ITreeNode root = reader.readTree();
        String tocTree = this.toString(root);
        TOCVersionTest.assertEquals((String)GOLDEN_TOC.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
        reader.close();
        in.close();
    }

    public void testReadV2() throws IOException {
        RAInputStream in = this.openResource(TOC_TREE_V2);
        TOCReader reader = new TOCReader(in, ((Object)((Object)this)).getClass().getClassLoader());
        TOCVersionTest.assertEquals((String)"__Version : 2.0", (String)reader.getVersion());
        ITreeNode root = reader.readTree();
        String tocTree = this.toString(root);
        TOCVersionTest.assertEquals((String)GOLDEN_TOC.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
        reader.close();
        in.close();
    }

    public void testReadV3() throws IOException {
        RAInputStream in = this.openResource(TOC_TREE_V3);
        TOCReader reader = new TOCReader(in, ((Object)((Object)this)).getClass().getClassLoader());
        TOCVersionTest.assertEquals((String)"__Version : 3.0", (String)reader.getVersion());
        ITreeNode root = reader.readTree();
        String tocTree = this.toString(root);
        TOCVersionTest.assertEquals((String)GOLDEN_TOC_V3.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
        reader.close();
        in.close();
    }

    public void testStrComp() {
        this.compare("__TOC_0", "__TOC_1");
        this.compare("__TOC_0", "__TOC_9");
        this.compare("__TOC_0", "__TOC_10");
        this.compare("__TOC_9", "__TOC_10");
        this.compare("__TOC_10", "__TOC_11");
        this.compare("__TOC_3", "__TOC_11");
    }

    void compare(String s, String t) {
        int v = s.compareTo(t);
        if (v > 0) {
            System.out.println(String.valueOf(s) + " > " + t);
        } else if (v < 0) {
            System.out.println(String.valueOf(s) + " < " + t);
        } else {
            System.out.println(String.valueOf(s) + " = " + t);
        }
    }

    RAInputStream openResource(String resource) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[1024];
        int size = in.read(buffer);
        while (size > 0) {
            out.write(buffer, 0, size);
            size = in.read(buffer);
        }
        in.close();
        return new ByteArrayRAInputStream(out.toByteArray());
    }

    protected byte[] writeTOC() throws IOException {
        ByteArrayRAOutputStream out = new ByteArrayRAOutputStream();
        TOCWriter writer = new TOCWriter((RAOutputStream)out);
        TOCBuilder builder = new TOCBuilder((ITOCWriter)writer);
        TOCEntry reportHeader = builder.startEntry(null, (Object)"report-header", null, -1L);
        builder.closeEntry(reportHeader);
        TOCEntry list = builder.startEntry(null, (Object)"list", null, -1L);
        TOCEntry listHeader = builder.startEntry(list, (Object)"list-header", null, -1L);
        builder.closeEntry(listHeader);
        TOCEntry group = builder.startGroupEntry(list, (Object)"group", null, null, -1L);
        TOCEntry group21Header = builder.startEntry(group, (Object)"list-group-header", null, -1L);
        builder.closeEntry(group21Header);
        TOCEntry detail = builder.startEntry(group, (Object)"detail", null, null, -1L);
        builder.closeEntry(detail);
        TOCEntry group21Footer = builder.startEntry(group, (Object)"group-footer", null, null, -1L);
        builder.closeEntry(group21Footer);
        builder.closeGroupEntry(group);
        TOCEntry listFooter = builder.startEntry(list, (Object)"list-footer", null, null, -1L);
        builder.closeEntry(listFooter);
        builder.closeEntry(list);
        TOCEntry footer = builder.startEntry(null, (Object)"footer", null, -1L);
        builder.closeEntry(footer);
        writer.close();
        out.close();
        return out.toByteArray();
    }
}

