/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.datafeed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.birt.chart.internal.datafeed.ChartVariableHelper;

public class ChartVariableHelperTest
extends TestCase {
    private String fCategoryExpr = "row[\"COUNTRY\"]";
    private String fSeriesExpr = "row[\"CREDILIMIT\"]";
    private String fSeriesName = "Series 1";
    Object[] fParams = new String[4];
    private ChartVariableHelper fTestInstance;

    protected void setUp() throws Exception {
        this.fParams[1] = this.fCategoryExpr;
        this.fParams[2] = this.fSeriesExpr;
        this.fParams[3] = this.fSeriesName;
        this.fTestInstance = new ChartVariableHelper();
    }

    public void testParseChartVariables() throws SecurityException, NoSuchMethodException {
        Method m = ChartVariableHelper.class.getDeclaredMethod("parseChartVariables", String.class, String.class, String.class, String.class);
        m.setAccessible(true);
        try {
            String v1Src = "categoryData + \":\" + valueData + \":\" + valueSeriesName";
            String v1Target = "row[\"COUNTRY\"] + \":\" + row[\"CREDILIMIT\"] + \":\" + \"Series 1\"";
            this.fParams[0] = v1Src;
            Object result = m.invoke((Object)this.fTestInstance, this.fParams);
            ChartVariableHelperTest.assertEquals((Object)v1Target, (Object)result);
            String v2Src = "categoryData + \":\" + row[\"valueData\"] + \":\" + valueSeriesName";
            String v2Target = "row[\"COUNTRY\"] + \":\" + row[\"valueData\"] + \":\" + \"Series 1\"";
            this.fParams[0] = v2Src;
            result = m.invoke((Object)this.fTestInstance, this.fParams);
            ChartVariableHelperTest.assertEquals((Object)v2Target, (Object)result);
            String v3Src = "categoryData + \":\" + valueData + \":\" + valueSeriesName\n//This is C plus plus comments.";
            String v3Target = "row[\"COUNTRY\"] + \":\" + row[\"CREDILIMIT\"] + \":\" + \"Series 1\"\n//This is C plus plus comments.";
            this.fParams[0] = v3Src;
            result = m.invoke((Object)this.fTestInstance, this.fParams);
            ChartVariableHelperTest.assertEquals((Object)v3Target, (Object)result);
            String v4Src = "//This is C plus plus comments.\ncategoryData + \":\" + valueData + \":\" + valueSeriesName";
            String v4Target = "//This is C plus plus comments.\nrow[\"COUNTRY\"] + \":\" + row[\"CREDILIMIT\"] + \":\" + \"Series 1\"";
            this.fParams[0] = v4Src;
            result = m.invoke((Object)this.fTestInstance, this.fParams);
            ChartVariableHelperTest.assertEquals((Object)v4Target, (Object)result);
            String v5Src = "/*This is C plus \nplus comments.*/\ncategoryData + \":\" + valueData + \":\" + valueSeriesName";
            String v5Target = "/*This is C plus \nplus comments.*/\nrow[\"COUNTRY\"] + \":\" + row[\"CREDILIMIT\"] + \":\" + \"Series 1\"";
            this.fParams[0] = v5Src;
            result = m.invoke((Object)this.fTestInstance, this.fParams);
            ChartVariableHelperTest.assertEquals((Object)v5Target, (Object)result);
            String v6Src = "/*This is C plus \nplus comments.*/\n(categoryData)+valueData + \":\" + valueSeriesName";
            String v6Target = "/*This is C plus \nplus comments.*/\n(row[\"COUNTRY\"])+row[\"CREDILIMIT\"] + \":\" + \"Series 1\"";
            this.fParams[0] = v6Src;
            result = m.invoke((Object)this.fTestInstance, this.fParams);
            ChartVariableHelperTest.assertEquals((Object)v6Target, (Object)result);
        }
        catch (IllegalArgumentException e) {
            ChartVariableHelperTest.fail((String)"Exception happened, failed to test.");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            ChartVariableHelperTest.fail((String)"Exception happened, failed to test.");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            ChartVariableHelperTest.fail((String)"Exception happened, failed to test.");
            e.printStackTrace();
        }
        m.setAccessible(false);
    }

    public static void main(String[] args) {
        new TestSuite(ChartVariableHelperTest.class);
    }
}

