/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import junit.framework.TestCase;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.util.ChartUtil;

public class ChartUtilTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testIsColorTransparent() {
        ChartUtilTest.assertFalse((boolean)ChartUtil.isColorTransparent((ColorDefinition)ColorDefinitionImpl.BLUE()));
        ChartUtilTest.assertTrue((boolean)ChartUtil.isColorTransparent((ColorDefinition)ColorDefinitionImpl.TRANSPARENT()));
    }

    public void testIsShadowDefined() {
        Label label = LabelImpl.create();
        ChartUtilTest.assertFalse((boolean)ChartUtil.isShadowDefined((Label)label));
        label.setShadowColor(ColorDefinitionImpl.BLACK());
        ChartUtilTest.assertTrue((boolean)ChartUtil.isShadowDefined((Label)label));
    }

    public void testMathGT() {
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathGT((double)1.000000001, (double)1.0));
        ChartUtilTest.assertFalse((boolean)ChartUtil.mathGT((double)1.00000000001, (double)1.0));
    }

    public void testMathLT() {
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathLT((double)1.0, (double)1.000000001));
        ChartUtilTest.assertFalse((boolean)ChartUtil.mathLT((double)1.0, (double)1.00000000001));
    }

    public void testMathEqual() {
        ChartUtilTest.assertFalse((boolean)ChartUtil.mathEqual((double)1.000000001, (double)1.0));
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathEqual((double)1.00000000001, (double)1.0));
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathEqual((double)1.0, (double)1.00000000001));
    }

    public void testGetQuadrant() {
        ChartUtilTest.assertEquals((int)-1, (int)ChartUtil.getQuadrant((double)0.0));
        ChartUtilTest.assertEquals((int)-2, (int)ChartUtil.getQuadrant((double)90.0));
        ChartUtilTest.assertEquals((int)-3, (int)ChartUtil.getQuadrant((double)180.0));
        ChartUtilTest.assertEquals((int)-4, (int)ChartUtil.getQuadrant((double)270.0));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.getQuadrant((double)45.0));
        ChartUtilTest.assertEquals((int)2, (int)ChartUtil.getQuadrant((double)-200.0));
        ChartUtilTest.assertEquals((int)3, (int)ChartUtil.getQuadrant((double)-100.0));
        ChartUtilTest.assertEquals((int)4, (int)ChartUtil.getQuadrant((double)-45.0));
    }

    public void testCompareVersion() {
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"2", (String)"2"));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"2", (String)"2."));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"2", (String)"2.0"));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.compareVersion((String)"3", (String)"2"));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.compareVersion((String)"3.", (String)"2"));
        ChartUtilTest.assertEquals((int)-16, (int)ChartUtil.compareVersion((String)"3.1", (String)"3.17"));
        ChartUtilTest.assertEquals((int)-15, (int)ChartUtil.compareVersion((String)"3.2", (String)"3.17"));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"3.1.", (String)"3.1.0"));
        ChartUtilTest.assertEquals((int)2, (int)ChartUtil.compareVersion((String)"3.1.2", (String)"3.1"));
        ChartUtilTest.assertEquals((int)-1, (int)ChartUtil.compareVersion((String)"3.1.2", (String)"3.1.3"));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.compareVersion((String)"3.1.1.5", (String)"3.1"));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"3.1.1.5", (String)"3.1.1.5.0"));
        ChartUtilTest.assertEquals((int)-1, (int)ChartUtil.compareVersion((String)"3.1.1.5", (String)"3.1.1.6"));
    }
}

