/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.script.data;

import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.script.api.data.ISeriesGrouping;
import org.eclipse.birt.chart.tests.script.BaseChartTestCase;

public class SeriesGroupingTest
extends BaseChartTestCase {
    public void testGroupInterval() {
        ISeriesGrouping grouping = this.getChartWithoutAxes().getCategory().getGrouping();
        SeriesGroupingTest.assertEquals((double)grouping.getGroupInterval(), (double)0.0, (double)1.0E-5f);
        grouping.setGroupInterval(1.0);
        SeriesGroupingTest.assertEquals((double)grouping.getGroupInterval(), (double)1.0, (double)1.0E-5f);
    }

    public void testGroupType() {
        ISeriesGrouping grouping = this.getChartWithoutAxes().getCategory().getGrouping();
        SeriesGroupingTest.assertEquals((String)grouping.getGroupType(), (String)DataType.TEXT_LITERAL.getLiteral());
        grouping.setGroupType(DataType.NUMERIC_LITERAL.getLiteral());
        SeriesGroupingTest.assertEquals((String)"Test setting group type", (String)grouping.getGroupType(), (String)DataType.NUMERIC_LITERAL.getLiteral());
        grouping.setGroupType("Num");
        SeriesGroupingTest.assertEquals((String)"Test invalid group type", (String)grouping.getGroupType(), (String)DataType.TEXT_LITERAL.getLiteral());
    }

    public void testGroupUnit() {
        ISeriesGrouping grouping = this.getChartWithoutAxes().getCategory().getGrouping();
        SeriesGroupingTest.assertEquals((String)grouping.getGroupUnit(), (String)GroupingUnitType.DAYS_LITERAL.getLiteral());
        grouping.setGroupUnit(GroupingUnitType.SECONDS_LITERAL.getLiteral());
        SeriesGroupingTest.assertEquals((String)"Test setting group unit", (String)grouping.getGroupUnit(), (String)GroupingUnitType.SECONDS_LITERAL.getLiteral());
        grouping.setGroupUnit("dd");
        SeriesGroupingTest.assertEquals((String)"Test invalid group unit", (String)grouping.getGroupUnit(), (String)GroupingUnitType.DAYS_LITERAL.getLiteral());
    }

    public void testEnabled() {
        ISeriesGrouping grouping = this.getChartWithoutAxes().getCategory().getGrouping();
        SeriesGroupingTest.assertEquals((boolean)grouping.isEnabled(), (boolean)true);
        grouping.setEnabled(false);
        SeriesGroupingTest.assertEquals((boolean)grouping.isEnabled(), (boolean)false);
    }
}

