/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.AbstractElementRecord;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CompoundRecordTest
extends BaseTestCase {
    CompoundRecord compoundRecord = null;
    MockupActivityRecord activityRecord = null;
    ActivityStack activityStack = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.compoundRecord = new CompoundRecord("SampleCompoundRecord");
        this.activityRecord = new MockupActivityRecord(1);
        this.activityStack = new ActivityStack(null);
    }

    protected void tearDown() throws Exception {
        this.compoundRecord = null;
        this.activityRecord = null;
        this.activityStack = null;
    }

    public void testAppend() {
        List records = this.compoundRecord.getRecords();
        CompoundRecordTest.assertEquals((int)0, (int)records.size());
        this.activityStack.execute((IActivityRecord)this.activityRecord);
        this.compoundRecord.append((ActivityRecord)this.activityRecord);
        CompoundRecordTest.assertEquals((int)1, (int)records.size());
    }

    public void testUndo() {
        MockupActivityRecord record1 = new MockupActivityRecord(1);
        MockupActivityRecord record2 = new MockupActivityRecord(1);
        this.activityStack.execute((IActivityRecord)record1);
        this.activityStack.execute((IActivityRecord)record2);
        CompoundRecordTest.assertEquals((int)1, (int)record1.getState());
        CompoundRecordTest.assertEquals((int)1, (int)record2.getState());
        this.compoundRecord.append((ActivityRecord)record1);
        this.compoundRecord.append((ActivityRecord)record2);
        this.compoundRecord.undo();
        CompoundRecordTest.assertEquals((int)2, (int)record1.getState());
        CompoundRecordTest.assertEquals((int)2, (int)record2.getState());
    }

    public void testRedo() {
        MockupActivityRecord record1 = new MockupActivityRecord(1);
        MockupActivityRecord record2 = new MockupActivityRecord(2);
        this.activityStack.execute((IActivityRecord)record1);
        this.activityStack.execute((IActivityRecord)record2);
        CompoundRecordTest.assertEquals((int)1, (int)record1.getState());
        CompoundRecordTest.assertEquals((int)1, (int)record2.getState());
        this.compoundRecord.append((ActivityRecord)record1);
        this.compoundRecord.append((ActivityRecord)record2);
        this.compoundRecord.undo();
        CompoundRecordTest.assertEquals((int)2, (int)record1.getState());
        CompoundRecordTest.assertEquals((int)2, (int)record2.getState());
        this.compoundRecord.redo();
        CompoundRecordTest.assertEquals((int)3, (int)record1.getState());
        CompoundRecordTest.assertEquals((int)3, (int)record2.getState());
    }

    public void testCanUndo() {
        MockupActivityRecord record1 = new MockupActivityRecord(1);
        MockupActivityRecord record2 = new MockupActivityRecord(2);
        this.activityStack.execute((IActivityRecord)record1);
        this.activityStack.execute((IActivityRecord)record2);
        this.compoundRecord.append((ActivityRecord)record1);
        this.compoundRecord.append((ActivityRecord)record2);
        CompoundRecordTest.assertEquals((boolean)true, (boolean)record1.canUndo);
        CompoundRecordTest.assertEquals((boolean)true, (boolean)record2.canUndo);
        CompoundRecordTest.assertEquals((boolean)true, (boolean)this.compoundRecord.canUndo());
        record1.canUndo = true;
        record2.canUndo = false;
        CompoundRecordTest.assertEquals((boolean)false, (boolean)this.compoundRecord.canUndo());
    }

    public void testCanRedo() {
        MockupActivityRecord record1 = new MockupActivityRecord(1);
        MockupActivityRecord record2 = new MockupActivityRecord(2);
        this.activityStack.execute((IActivityRecord)record1);
        this.activityStack.execute((IActivityRecord)record2);
        this.compoundRecord.append((ActivityRecord)record1);
        this.compoundRecord.append((ActivityRecord)record2);
        CompoundRecordTest.assertEquals((boolean)false, (boolean)this.compoundRecord.canRedo());
        record1.canRedo = true;
        record2.canRedo = true;
        CompoundRecordTest.assertEquals((boolean)true, (boolean)this.compoundRecord.canRedo());
    }

    public void testPop() {
        CompoundRecordTest.assertNull((Object)this.compoundRecord.pop());
        MockupActivityRecord record1 = new MockupActivityRecord(1);
        this.activityStack.execute((IActivityRecord)record1);
        this.compoundRecord.append((ActivityRecord)record1);
        CompoundRecordTest.assertEquals((Object)((Object)record1), (Object)this.compoundRecord.pop());
        CompoundRecordTest.assertNull((Object)this.compoundRecord.pop());
    }

    public void testExecute() {
        this.compoundRecord.execute();
        MockupActivityRecord record1 = new MockupActivityRecord(1);
        MockupActivityRecord record2 = new MockupActivityRecord(2);
        this.activityStack.execute((IActivityRecord)record1);
        this.activityStack.execute((IActivityRecord)record2);
        this.compoundRecord.append((ActivityRecord)record1);
        this.compoundRecord.append((ActivityRecord)record2);
        this.compoundRecord.execute();
    }

    class MockupActivityRecord
    extends AbstractElementRecord {
        boolean canUndo = false;
        boolean canRedo = false;
        int activityID;

        public boolean canRedo() {
            return this.canRedo;
        }

        public boolean canUndo() {
            return this.canUndo;
        }

        public MockupActivityRecord(int activityID) {
            this.activityID = activityID;
        }

        public void execute() {
            this.canUndo = true;
            this.canRedo = false;
        }

        public void undo() {
            if (this.canUndo) {
                this.canRedo = true;
                this.canUndo = false;
            }
        }

        public void redo() {
            if (this.canRedo) {
                this.canUndo = true;
                this.canRedo = false;
            }
        }

        public DesignElement getTarget() {
            return new MockupDesignElement();
        }

        public NotificationEvent getEvent() {
            return new MockupEvent();
        }

        public void rollback() {
            this.undo();
        }

        protected final boolean holdEvent(Stack transStack) {
            CompoundRecord cr;
            return transStack != null && !transStack.isEmpty() && (cr = (CompoundRecord)transStack.peek()) instanceof FilterEventsCompoundRecord;
        }
    }

    class MockupDesignElement
    extends DesignElement {
        private int counter = 0;

        MockupDesignElement() {
        }

        public void increase() {
            ++this.counter;
        }

        public void decrease() {
            --this.counter;
        }

        public void apply(ElementVisitor visitor) {
        }

        public String getElementName() {
            return null;
        }

        public DesignElementHandle getHandle(Module rootElement) {
            return null;
        }
    }

    class MockupEvent
    extends NotificationEvent {
        MockupEvent() {
        }

        public int getEventType() {
            return 0;
        }
    }
}

