/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ColorHandleTest
extends BaseTestCase {
    private ColorHandle colorHandle = null;
    private ColorHandle colorHandle1 = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ColorHandleTest.xml", TEST_LOCALE);
        this.colorHandle = this.designHandle.findStyle("My-Style").getColor();
        this.colorHandle1 = this.designHandle.findStyle("My-Style1").getColor();
    }

    public void testSetColor() throws Exception {
        this.colorHandle.setRGB(0xFF00FF);
        ColorHandleTest.assertEquals((int)0xFF00FF, (int)this.colorHandle.getRGB());
        this.colorHandle.setValue((Object)"#FF00FF");
        ColorHandleTest.assertEquals((int)0xFF00FF, (int)this.colorHandle.getRGB());
        this.colorHandle.setValue((Object)"16711935");
        ColorHandleTest.assertEquals((int)0xFF00FF, (int)this.colorHandle.getRGB());
        ColorHandleTest.assertEquals((String)"RGB(255,0,255)", (String)this.colorHandle.getCssValue());
        this.colorHandle.setValue((Object)new Integer(0xFF00F5));
        ColorHandleTest.assertEquals((String)"#FF00F5", (String)this.colorHandle.getStringValue());
        this.colorHandle.setValue((Object)"red");
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getCssValue());
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getStringValue());
        ColorHandleTest.assertEquals((int)0xFF0000, (int)this.colorHandle.getRGB());
        ColorHandleTest.assertEquals((String)"\u7ea2\u8272", (String)this.colorHandle.getDisplayValue());
        this.colorHandle.setValue((Object)"REd");
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getCssValue());
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getStringValue());
        ColorHandleTest.assertEquals((Object)"red", (Object)this.colorHandle.getValue());
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        this.colorHandle.setStringValue("\u7ea2\u8272");
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getCssValue());
        ColorHandleTest.assertEquals((String)"\u7ea2\u8272", (String)this.colorHandle.getDisplayValue());
        this.colorHandle.setStringValue("myColor1");
        ColorHandleTest.assertEquals((String)"myColor1", (String)this.colorHandle.getStringValue());
        ColorHandleTest.assertEquals((String)"sheng lan", (String)this.colorHandle.getDisplayValue());
        this.colorHandle.setValue((Object)"\u7ea2\u8272");
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getCssValue());
        Style style1 = (Style)this.design.findStyle("My-Style2");
        SharedStyleHandle style2Handle = style1.handle((Module)this.design);
        Iterator highlightHandles = style2Handle.highlightRulesIterator();
        ColorHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        ColorHandleTest.assertNotNull((Object)highlightHandle);
        this.colorHandle = highlightHandle.getColor();
        ColorHandleTest.assertNotNull((Object)this.colorHandle);
        this.colorHandle.setRGB(1193046);
        this.colorHandle = highlightHandle.getBackgroundColor();
        ColorHandleTest.assertNotNull((Object)this.colorHandle);
        this.colorHandle.setValue((Object)"myColor2");
    }

    public void testGetColor() throws SemanticException {
        ColorHandleTest.assertEquals((int)0xFF0000, (int)this.colorHandle.getRGB());
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getStringValue());
        ColorHandleTest.assertEquals((int)0xFF00FF, (int)this.colorHandle1.getRGB());
        ColorHandleTest.assertEquals((String)"red", (String)this.colorHandle.getCssValue());
        this.colorHandle.setValue((Object)"#FF00FF");
        ColorHandleTest.assertEquals((String)"RGB(255,0,255)", (String)this.colorHandle.getCssValue());
        ColorHandleTest.assertEquals((String)"#FF00FF", (String)this.colorHandle.getStringValue());
        Style style1 = (Style)this.design.findStyle("My-Style2");
        SharedStyleHandle style2Handle = style1.handle((Module)this.design);
        this.colorHandle = style2Handle.getColor();
        ColorHandleTest.assertNotNull((Object)this.colorHandle);
        ColorHandleTest.assertEquals((String)"black", (String)this.colorHandle.getCssValue());
        Iterator highlightHandles = style2Handle.highlightRulesIterator();
        ColorHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        ColorHandleTest.assertNotNull((Object)highlightHandle);
        this.colorHandle = highlightHandle.getColor();
        ColorHandleTest.assertNotNull((Object)this.colorHandle);
        ColorHandleTest.assertEquals((String)"yellow", (String)this.colorHandle.getCssValue());
        this.colorHandle = highlightHandle.getBackgroundColor();
        ColorHandleTest.assertNotNull((Object)this.colorHandle);
        ColorHandleTest.assertEquals((String)"RGB(18,52,86)", (String)this.colorHandle.getCssValue());
        ColorHandleTest.assertEquals((int)1193046, (int)this.colorHandle.getRGB());
        this.colorHandle = highlightHandle.getBorderBottomColor();
        ColorHandleTest.assertNotNull((Object)this.colorHandle);
        this.colorHandle = this.designHandle.findStyle("My-Style3").getColor();
        ColorHandleTest.assertEquals((String)"myColor1", (String)this.colorHandle.getStringValue());
        ColorHandleTest.assertEquals((int)1193210, (int)this.colorHandle.getRGB());
    }

    public void testGetCSSColors() {
        List colors = this.colorHandle.getCSSColors();
        ColorHandleTest.assertEquals((int)17, (int)colors.size());
    }
}

