/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ComputedColumnHandleTest
extends BaseTestCase {
    public void testSimpleListProperties() throws Exception {
        this.createDesign();
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        this.designHandle.getBody().add((DesignElementHandle)data);
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName("column 1");
        column.setExpression("expression 1");
        column.setAggregateOn("agg 1");
        column.addAggregateOn("agg 2");
        ComputedColumnHandleTest.assertEquals((int)2, (int)column.getAggregateOnList().size());
        column.clearAggregateOnList();
        ComputedColumnHandleTest.assertEquals((int)0, (int)column.getAggregateOnList().size());
        ComputedColumnHandle columnHandle = data.addColumnBinding(column, false);
        AggregationArgument argument = new AggregationArgument();
        argument.setName("arg_1");
        argument.setValue("argument 1");
        columnHandle.addArgument(argument);
        Iterator iter = columnHandle.argumentsIterator();
        ComputedColumnHandleTest.assertTrue((boolean)iter.hasNext());
        columnHandle.removeArgument(argument);
        iter = columnHandle.argumentsIterator();
        ComputedColumnHandleTest.assertFalse((boolean)iter.hasNext());
        columnHandle.addAggregateOn("group 1");
        List aggregates = columnHandle.getAggregateOnList();
        ComputedColumnHandleTest.assertEquals((int)1, (int)aggregates.size());
        columnHandle.removeAggregateOn("group 1");
        aggregates = columnHandle.getAggregateOnList();
        ComputedColumnHandleTest.assertEquals((int)0, (int)aggregates.size());
        columnHandle.setAggregateOn("agg 1");
        columnHandle.addAggregateOn("agg 2");
        ComputedColumnHandleTest.assertEquals((int)2, (int)columnHandle.getAggregateOnList().size());
        columnHandle.clearAggregateOnList();
        ComputedColumnHandleTest.assertEquals((int)0, (int)columnHandle.getAggregateOnList().size());
    }

    public void testArguments() throws Exception {
        this.createDesign();
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        this.designHandle.getBody().add((DesignElementHandle)data);
        ComputedColumn column = StructureFactory.createComputedColumn();
        AggregationArgument argument = StructureFactory.createAggregationArgument();
        argument.setName("argu1");
        argument.setValue("value1");
        column.addArgument(argument);
        argument = StructureFactory.createAggregationArgument();
        argument.setName("argu2");
        argument.setValue("value2");
        column.addArgument(argument);
        column.setName("column1");
        column.setExpression("expression 1");
        data.addColumnBinding(column, false);
        column = StructureFactory.createComputedColumn();
        argument = StructureFactory.createAggregationArgument();
        argument.setName("argu3");
        argument.setValue("value3");
        column.addArgument(argument);
        argument = StructureFactory.createAggregationArgument();
        argument.setValue("value4");
        column.addArgument(argument);
        column.setName("column2");
        column.setExpression("expression 2");
        try {
            data.addColumnBinding(column, false);
            ComputedColumnHandleTest.fail();
        }
        catch (PropertyValueException e) {
            ComputedColumnHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
    }

    public void testSkipComputedColumnValidation() throws Exception {
        this.openDesign("ReportItemHandle_ComputedColumn.xml");
        ScalarParameterHandle paramHandle = (ScalarParameterHandle)this.designHandle.findParameter("MyParam1");
        ComputedColumnHandle columnHandle = (ComputedColumnHandle)paramHandle.getColumnBindings().get(0);
        ComputedColumnHandleTest.assertEquals((String)"sum 2", (String)columnHandle.getAggregateFunction());
        ComputedColumnHandle columnHandle2 = (ComputedColumnHandle)paramHandle.getColumnBindings().get(1);
        ComputedColumnHandleTest.assertEquals((String)"MAX", (String)columnHandle2.getAggregateFunction());
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setProperty("aggregateFunction", (Object)"count 2");
        column.setName("column3");
        PropertyHandle propHandle = paramHandle.getColumnBindings();
        propHandle.addItem((IStructure)column);
        ComputedColumnHandle columnHandle3 = (ComputedColumnHandle)propHandle.get(2);
        ComputedColumnHandleTest.assertEquals((String)"count 2", (String)columnHandle3.getAggregateFunction());
        this.save();
        ComputedColumnHandleTest.assertTrue((boolean)this.compareFile("ReportItemHandle_ComputedColumn_golden.xml"));
    }

    public void testDataTypeInComputedColumn() throws Exception {
        this.openDesign("DataTypeInComputedColumnTest.xml");
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("Data Set");
        List columns = (List)dataSet.getProperty("computedColumns");
        ComputedColumn computedColumn = (ComputedColumn)columns.get(0);
        ComputedColumnHandleTest.assertEquals((String)"any", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumn)columns.get(1);
        ComputedColumnHandleTest.assertNull((Object)computedColumn.getDataType());
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        columns = (List)table.getProperty("boundDataColumns");
        computedColumn = (ComputedColumn)columns.get(0);
        ComputedColumnHandleTest.assertEquals((String)"any", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumn)columns.get(1);
        ComputedColumnHandleTest.assertNull((Object)computedColumn.getDataType());
        ScalarParameterHandle param1 = (ScalarParameterHandle)this.designHandle.findParameter("NewParameter");
        columns = (List)param1.getProperty("boundDataColumns");
        computedColumn = (ComputedColumn)columns.get(0);
        ComputedColumnHandleTest.assertEquals((String)"any", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumn)columns.get(1);
        ComputedColumnHandleTest.assertNull((Object)computedColumn.getDataType());
    }
}

