/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CustomColorHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CustomColorHandleTest
extends BaseTestCase {
    static final String INPUT_FILE_NAME = "CustomColorHandleTest.xml";
    static final String OUTPUT_FILE_NAME = "CustomColorHandleTest_out.xml";
    static final String GOLDEN_FILE_NAME = "CustomColorHandleTest_golden.xml";
    static final String SEMANTIC_CHECK_FILE_NAME = "CustomColorHandleTest1.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(INPUT_FILE_NAME, ULocale.ENGLISH);
    }

    public void testGetRGB() throws Exception {
        Iterator iter = this.designHandle.customColorsIterator();
        CustomColorHandle handle1 = (CustomColorHandle)iter.next();
        CustomColorHandle handle2 = (CustomColorHandle)iter.next();
        CustomColorHandle handle3 = (CustomColorHandle)iter.next();
        CustomColorHandleTest.assertEquals((String)"custom blue", (String)handle1.getName());
        CustomColorHandleTest.assertEquals((String)"#0000FE", (String)handle1.getColor());
        CustomColorHandleTest.assertEquals((int)254, (int)handle1.getRGB());
        handle1.setColor("red");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("GREEN");
        CustomColorHandleTest.assertEquals((int)32768, (int)handle1.getRGB());
        handle1.setColor("GrEEN");
        CustomColorHandleTest.assertEquals((int)32768, (int)handle1.getRGB());
        handle1.setColor("RGB( 100.0%, 0.0%, 0.0%)");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("RGB( 200.%, 0.0%, 0.0%)");
        CustomColorHandleTest.assertEquals((int)-1, (int)handle1.getRGB());
        handle1.setColor("RGB( 200.%, 0.0%, 0.0%)");
        CustomColorHandleTest.assertEquals((int)-1, (int)handle1.getRGB());
        handle1.setColor("RGB( 255, 0, 0)");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("RGB( 255, 0, 0)");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("RGB( 400, 0, 0)");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("RGB( 255, , 0)");
        CustomColorHandleTest.assertEquals((int)-1, (int)handle1.getRGB());
        handle1.setColor("#FF0000");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("#7FFFFFFF");
        CustomColorHandleTest.assertEquals((int)0xFFFFFF, (int)handle1.getRGB());
        handle1.setColor("#80000000");
        CustomColorHandleTest.assertEquals((int)-1, (int)handle1.getRGB());
        handle1.setColor("#F00");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("#F0");
        CustomColorHandleTest.assertEquals((int)240, (int)handle1.getRGB());
        handle1.setColor("0xFF0000");
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle1.getRGB());
        handle1.setColor("0x7FFFFFFF");
        CustomColorHandleTest.assertEquals((int)0xFFFFFF, (int)handle1.getRGB());
        handle1.setColor("0x80000000");
        CustomColorHandleTest.assertEquals((int)-1, (int)handle1.getRGB());
        handle1.setColor("0xF0");
        CustomColorHandleTest.assertEquals((int)240, (int)handle1.getRGB());
        handle1.setColor("123456");
        CustomColorHandleTest.assertEquals((int)123456, (int)handle1.getRGB());
        handle1.setColor("2147483647");
        CustomColorHandleTest.assertEquals((int)Integer.decode("#FFFFFF"), (int)handle1.getRGB());
        handle1.setColor("2147483648");
        CustomColorHandleTest.assertEquals((int)-1, (int)handle1.getRGB());
        CustomColorHandleTest.assertEquals((String)"custom red", (String)handle2.getName());
        CustomColorHandleTest.assertEquals((int)0xFF0000, (int)handle3.getRGB());
    }

    public void testGetSet() throws Exception {
        Iterator iter = this.designHandle.customColorsIterator();
        CustomColorHandle handle1 = (CustomColorHandle)iter.next();
        CustomColorHandleTest.assertEquals((String)"custom blue", (String)handle1.getName());
        CustomColorHandleTest.assertEquals((String)"#0000FE", (String)handle1.getColor());
        CustomColorHandleTest.assertEquals((int)254, (int)handle1.getRGB());
        CustomColorHandleTest.assertEquals((String)"Color1", (String)handle1.getDisplayName());
        CustomColorHandleTest.assertEquals((String)"custom-color1", (String)handle1.getDisplayNameID());
        handle1.setName("cusblue");
        handle1.setColor("#000FD");
        handle1.setDisplayName("Color1_DisplayName");
        handle1.setDisplayNameID("Color1_DisplayName_ID");
        CustomColorHandleTest.assertEquals((String)"cusblue", (String)handle1.getName());
        CustomColorHandleTest.assertEquals((String)"#000FD", (String)handle1.getColor());
        CustomColorHandleTest.assertEquals((int)253, (int)handle1.getRGB());
        CustomColorHandleTest.assertEquals((String)"Color1_DisplayName", (String)handle1.getDisplayName());
        CustomColorHandleTest.assertEquals((String)"Color1_DisplayName_ID", (String)handle1.getDisplayNameID());
    }

    public void testWriter() throws Exception {
        Iterator iter = this.designHandle.customColorsIterator();
        CustomColorHandle handle1 = (CustomColorHandle)iter.next();
        CustomColorHandle handle2 = (CustomColorHandle)iter.next();
        handle1.setName("cusblue");
        handle1.setColor("#000FD");
        handle1.setDisplayName("Color1_DisplayName");
        handle1.setDisplayNameID("Color1_DisplayName_ID");
        handle2.setColor("green");
        this.save();
        CustomColorHandleTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE_NAME));
    }

    public void testSemanticErrors() throws DesignFileException {
        this.openDesign(SEMANTIC_CHECK_FILE_NAME, ULocale.ENGLISH);
        List errors = this.design.getErrorList();
        CustomColorHandleTest.assertEquals((int)2, (int)errors.size());
    }
}

