/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DimensionHandleTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("DimensionHandleTest.xml");
        DimensionHandleTest.assertNotNull((Object)this.designHandle);
    }

    public void testGetDisplayValue() {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DimensionHandle fontSizeHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"pt", (String)fontSizeHandle.getDefaultUnit());
        DimensionHandle backGroundPosXHandle = styleHandle.getBackGroundPositionX();
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        DimensionHandleTest.assertEquals((String)"\u5927\u4e00\u53f7", (String)fontSizeHandle.getDisplayValue());
        DimensionHandleTest.assertEquals((String)"12,000.123cm", (String)backGroundPosXHandle.getDisplayValue());
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        DimensionHandleTest.assertEquals((String)"Larger", (String)fontSizeHandle.getDisplayValue());
        DimensionHandleTest.assertEquals((String)"12,000.123cm", (String)backGroundPosXHandle.getDisplayValue());
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        DimensionHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        DimensionHandle dimensionHandle = highlightHandle.getFontSize();
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        DimensionHandleTest.assertEquals((String)"\u4e2d\u53f7", (String)dimensionHandle.getDisplayValue());
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        DimensionHandleTest.assertEquals((String)"Medium", (String)dimensionHandle.getDisplayValue());
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        dimensionHandle = highlightHandle.getFontSize();
        ThreadResources.setLocale((ULocale)ULocale.CHINA);
        DimensionHandleTest.assertEquals((String)"10mm", (String)dimensionHandle.getDisplayValue());
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        DimensionHandleTest.assertEquals((String)"10mm", (String)dimensionHandle.getDisplayValue());
    }

    public void testGetStringValue() {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DimensionHandle fontSizeHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"larger", (String)fontSizeHandle.getStringValue());
        DimensionHandle backGroundPosXHandle = styleHandle.getBackGroundPositionX();
        DimensionHandleTest.assertEquals((String)"12000.123cm", (String)backGroundPosXHandle.getStringValue());
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        DimensionHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        DimensionHandle dimensionHandle = highlightHandle.getBorderRightWidth();
        DimensionHandleTest.assertNotNull((Object)dimensionHandle);
        DimensionHandleTest.assertNull((Object)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getBorderTopWidth();
        DimensionHandleTest.assertNotNull((Object)dimensionHandle);
        DimensionHandleTest.assertEquals((String)"thin", (String)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getFontSize();
        DimensionHandleTest.assertNotNull((Object)dimensionHandle);
        DimensionHandleTest.assertEquals((String)"medium", (String)dimensionHandle.getStringValue());
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        dimensionHandle = highlightHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"10mm", (String)dimensionHandle.getStringValue());
        styleHandle = this.designHandle.findStyle("My-Style1");
        dimensionHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"10pt", (String)dimensionHandle.getStringValue());
    }

    public void testSetValue() throws Exception {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DimensionHandle fontSizeHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"larger", (String)fontSizeHandle.getStringValue());
        fontSizeHandle.setValue((Object)"smaller");
        DimensionHandleTest.assertEquals((String)"smaller", (String)fontSizeHandle.getStringValue());
        fontSizeHandle.setValue((Object)"12pt");
        DimensionHandleTest.assertEquals((String)"12pt", (String)fontSizeHandle.getStringValue());
        this.design.getSession().setUnits("cm");
        try {
            fontSizeHandle.setValue((Object)"abc");
        }
        catch (SemanticException e) {
            DimensionHandleTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            fontSizeHandle.setValue((Object)"12none-exsit-units");
        }
        catch (SemanticException e) {
            DimensionHandleTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        DimensionHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        DimensionHandle dimensionHandle = highlightHandle.getBorderRightWidth();
        DimensionHandleTest.assertNotNull((Object)dimensionHandle);
        dimensionHandle.setStringValue("12.0mm");
        dimensionHandle = highlightHandle.getFontSize();
        dimensionHandle.setValue((Object)"medium");
        styleHandle = this.designHandle.findStyle("My-Style1");
        dimensionHandle = styleHandle.getFontSize();
        dimensionHandle.setValue((Object)"14pc");
        highlightHandles = styleHandle.highlightRulesIterator();
        DimensionHandleTest.assertNotNull((Object)highlightHandles);
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        dimensionHandle = highlightHandle.getFontSize();
        dimensionHandle.setValue((Object)"22pt");
        this.save();
        DimensionHandleTest.assertTrue((boolean)this.compareFile("DimensionHandleTest_golden.xml"));
    }

    public void testIsKeyword() throws SemanticException {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DimensionHandle fontSizeHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"larger", (String)fontSizeHandle.getStringValue());
        DimensionHandleTest.assertEquals((boolean)true, (boolean)fontSizeHandle.isKeyword());
        fontSizeHandle.setValue((Object)"12pt");
        DimensionHandleTest.assertEquals((boolean)false, (boolean)fontSizeHandle.isKeyword());
    }

    public void testGetMeasure() throws SemanticException {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DimensionHandle fontSizeHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"larger", (String)fontSizeHandle.getStringValue());
        DimensionHandleTest.assertEquals((double)0.0, (double)fontSizeHandle.getMeasure(), (double)0.1);
        fontSizeHandle.setValue((Object)"12pt");
        DimensionHandleTest.assertEquals((double)12.0, (double)fontSizeHandle.getMeasure(), (double)0.1);
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        DimensionHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        DimensionHandle dimensionHandle = highlightHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"medium", (String)dimensionHandle.getStringValue());
        fontSizeHandle.setValue((Object)"15pc");
        DimensionHandleTest.assertEquals((double)15.0, (double)fontSizeHandle.getMeasure(), (double)0.1);
    }

    public void testGetUnits() throws SemanticException {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DimensionHandle fontSizeHandle = styleHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"larger", (String)fontSizeHandle.getStringValue());
        DimensionHandleTest.assertEquals((String)"", (String)fontSizeHandle.getUnits());
        fontSizeHandle.setValue((Object)"12pt");
        DimensionHandleTest.assertEquals((String)"pt", (String)fontSizeHandle.getUnits());
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        DimensionHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        DimensionHandleTest.assertNotNull((Object)highlightHandle);
        DimensionHandle dimensionHandle = highlightHandle.getFontSize();
        DimensionHandleTest.assertEquals((String)"medium", (String)dimensionHandle.getStringValue());
        dimensionHandle.setValue((Object)"15pc");
        DimensionHandleTest.assertEquals((String)"pc", (String)dimensionHandle.getUnits());
        IChoice[] choices = dimensionHandle.getAllowedUnits();
        DimensionHandleTest.assertEquals((int)9, (int)choices.length);
    }

    public void testComputedValue() {
        FreeFormHandle freeFormHandle1 = (FreeFormHandle)this.designHandle.findElement("form1");
        TextItemHandle textHandle1 = (TextItemHandle)this.designHandle.findElement("text1");
        DimensionHandleTest.assertEquals((String)"12px", (String)freeFormHandle1.getStringProperty("fontSize"));
        DimensionHandleTest.assertEquals((String)"3em", (String)freeFormHandle1.getStringProperty("textIndent"));
        DimensionHandleTest.assertEquals((String)"15px", (String)textHandle1.getStringProperty("fontSize"));
        DimensionHandleTest.assertEquals((String)"3em", (String)textHandle1.getStringProperty("textIndent"));
        DimensionHandleTest.assertEquals((String)"12px", (String)freeFormHandle1.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"36px", (String)freeFormHandle1.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"36px", (String)textHandle1.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        FreeFormHandle freeFormHandle2 = (FreeFormHandle)this.designHandle.findElement("form2");
        TextItemHandle textHandle2 = (TextItemHandle)this.designHandle.findElement("text2");
        DimensionHandleTest.assertEquals((String)"12px", (String)freeFormHandle2.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"15px", (String)textHandle2.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"45px", (String)textHandle2.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        FreeFormHandle freeFormHandle3 = (FreeFormHandle)this.designHandle.findElement("form3");
        TextItemHandle textHandle3 = (TextItemHandle)this.designHandle.findElement("text3");
        DimensionHandleTest.assertEquals((String)"14pt", (String)freeFormHandle3.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"70pt", (String)textHandle3.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        FreeFormHandle freeFormHandle4 = (FreeFormHandle)this.designHandle.findElement("form4");
        TextItemHandle textHandle4 = (TextItemHandle)this.designHandle.findElement("text4");
        DimensionHandleTest.assertEquals((String)"12pt", (String)freeFormHandle4.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"36pt", (String)textHandle4.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        FreeFormHandle freeFormHandle5 = (FreeFormHandle)this.designHandle.findElement("form5");
        TextItemHandle textHandle5 = (TextItemHandle)this.designHandle.findElement("text5");
        DimensionHandleTest.assertEquals((String)"20px", (String)freeFormHandle5.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"60px", (String)textHandle5.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        FreeFormHandle freeFormHandle6 = (FreeFormHandle)this.designHandle.findElement("form6");
        FreeFormHandle innerFreeFormHandle6 = (FreeFormHandle)this.designHandle.findElement("innerForm6");
        TextItemHandle textHandle6 = (TextItemHandle)this.designHandle.findElement("text6");
        DimensionHandleTest.assertEquals((String)"19px", (String)freeFormHandle6.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"57px", (String)textHandle6.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"19px", (String)freeFormHandle6.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"38px", (String)innerFreeFormHandle6.getDimensionProperty("backgroundPositionX").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"0px", (String)textHandle6.getDimensionProperty("backgroundPositionX").getAbsoluteValue().toString());
        TextItemHandle textHandle7 = (TextItemHandle)this.designHandle.findElement("text7");
        DimensionHandleTest.assertEquals((String)"18px", (String)textHandle7.getDimensionProperty("textIndent").getAbsoluteValue().toString());
        TextItemHandle textHandle9 = (TextItemHandle)this.designHandle.findElement("text9");
        FreeFormHandle innerFreeFormHandle9 = (FreeFormHandle)this.designHandle.findElement("innerForm9");
        DimensionHandleTest.assertEquals((String)"20px", (String)innerFreeFormHandle9.getDimensionProperty("fontSize").getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"30px", (String)textHandle9.getDimensionProperty("textIndent").getAbsoluteValue().toString());
    }

    public void testFontSizeAbsoluteValue() throws SemanticException {
        FreeFormHandle freeFormHandle8 = (FreeFormHandle)this.designHandle.findElement("form8");
        TextItemHandle textHandle8 = (TextItemHandle)this.designHandle.findElement("text8");
        DimensionHandle fontSizeOnForm = freeFormHandle8.getDimensionProperty("fontSize");
        DimensionHandle fontSizeOnText = textHandle8.getDimensionProperty("fontSize");
        fontSizeOnText.setStringValue("small");
        DimensionHandleTest.assertEquals((String)"small", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"10pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnForm.setStringValue("12px");
        DimensionHandleTest.assertEquals((String)"12px", (String)fontSizeOnForm.getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"12px", (String)fontSizeOnForm.getValue().toString());
        fontSizeOnText.setStringValue("2em");
        DimensionHandleTest.assertEquals((String)"2em", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"24px", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("3ex");
        DimensionHandleTest.assertEquals((String)"3ex", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"18px", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("50%");
        DimensionHandleTest.assertEquals((String)"50%", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"6px", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnForm.setStringValue("2em");
        DimensionHandleTest.assertEquals((String)"24pt", (String)fontSizeOnForm.getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"2em", (String)fontSizeOnForm.getValue().toString());
        fontSizeOnText.setStringValue("2em");
        DimensionHandleTest.assertEquals((String)"2em", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"48pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("3ex");
        DimensionHandleTest.assertEquals((String)"3ex", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"36pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("50%");
        DimensionHandleTest.assertEquals((String)"50%", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"12pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnForm.setStringValue(null);
        DimensionHandleTest.assertEquals((String)"12pt", (String)fontSizeOnForm.getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"medium", (String)fontSizeOnForm.getValue().toString());
        fontSizeOnText.setStringValue("2em");
        DimensionHandleTest.assertEquals((String)"2em", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"24pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("3ex");
        DimensionHandleTest.assertEquals((String)"3ex", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"18pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("50%");
        DimensionHandleTest.assertEquals((String)"50%", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"6pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnForm.setStringValue("large");
        DimensionHandleTest.assertEquals((String)"14pt", (String)fontSizeOnForm.getAbsoluteValue().toString());
        DimensionHandleTest.assertEquals((String)"large", (String)fontSizeOnForm.getValue().toString());
        fontSizeOnText.setStringValue("2em");
        DimensionHandleTest.assertEquals((String)"2em", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"28pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("3ex");
        DimensionHandleTest.assertEquals((String)"3ex", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"21pt", (String)fontSizeOnText.getAbsoluteValue().toString());
        fontSizeOnText.setStringValue("50%");
        DimensionHandleTest.assertEquals((String)"50%", (String)fontSizeOnText.getValue().toString());
        DimensionHandleTest.assertEquals((String)"7pt", (String)fontSizeOnText.getAbsoluteValue().toString());
    }

    public void testUnits() throws Exception {
        List errors = this.designHandle.getErrorList();
        DimensionHandleTest.assertEquals((int)1, (int)errors.size());
        FreeFormHandle freeFormHandle1 = (FreeFormHandle)this.designHandle.findElement("form1");
        DimensionHandle dimensionHandle = freeFormHandle1.getDimensionProperty("x");
        DimensionHandleTest.assertEquals((String)("12" + dimensionHandle.getDefaultUnit()), (String)freeFormHandle1.getX().getStringValue());
    }

    public void testLocale() throws Exception {
        this.createDesign(new ULocale("fi", "FI"));
        ImageHandle image = this.designHandle.getElementFactory().newImage("image1");
        this.designHandle.getBody().add((DesignElementHandle)image);
        image.setWidth("3,3cm");
        DimensionHandleTest.assertEquals((String)"3.3cm", (String)image.getWidth().getStringValue());
    }
}

