/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.List;
import org.eclipse.birt.report.model.api.CustomColorHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.LibraryUtil;

public class ElementExporterTest
extends BaseTestCase {
    public void testExportingLabel() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label1");
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_1.xml"));
    }

    public void testExportingLabelWithStyle() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label2");
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_2.xml"));
    }

    public void testExportingLabelWithExtends() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label3");
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_3.xml"));
    }

    public void testExportingTable() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("table1");
        ElementExportUtil.exportElement((DesignElementHandle)tableHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_4.xml"));
    }

    public void testExportingDuplicateLabel() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label1");
        labelHandle.setName("libLabel");
        try {
            ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
            ElementExporterTest.fail();
        }
        catch (Exception e) {
            ElementExporterTest.assertTrue((boolean)(e instanceof NameException));
        }
    }

    public void testExportingStyle() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        SharedStyleHandle styleHandle = this.designHandle.findStyle("style2");
        ElementExportUtil.exportElement((DesignElementHandle)styleHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_5.xml"));
    }

    public void testExportingDataMumble() throws Exception {
        this.openDesign("ElementExporterTest_5.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        DataSetHandle dataSetHandle = this.designHandle.findDataSet("dataSet1");
        ElementExportUtil.exportElement((DesignElementHandle)dataSetHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        dataSetHandle = this.libraryHandle.findDataSet("dataSet1");
        ElementExporterTest.assertEquals((String)"dataSource1", (String)dataSetHandle.getDataSourceName());
        ElementExporterTest.assertEquals(null, (Object)dataSetHandle.getDataSource());
        DataSourceHandle dataSourceHandle = this.designHandle.findDataSource("dataSource1");
        ElementExportUtil.exportElement((DesignElementHandle)dataSourceHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_6.xml"));
    }

    public void testExportingCustomColor() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("colorPalette");
        CustomColorHandle colorHandle = (CustomColorHandle)propHandle.getAt(0);
        ElementExportUtil.exportStructure((StructureHandle)colorHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        try {
            ElementExportUtil.exportStructure((StructureHandle)colorHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
            ElementExporterTest.fail();
        }
        catch (PropertyValueException e) {
            ElementExporterTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_7.xml"));
    }

    public void testExportingOneLabelInTable() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("innerLabel");
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_8.xml"));
    }

    public void testExportingOneLabelInMasterPage() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("labelInMasterPage");
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_9.xml"));
    }

    public void testExportingOneLabelToNewLibraryFile() throws Exception {
        String libraryFile;
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("labelInMasterPage");
        String libraryDir = String.valueOf(this.getTempFolder()) + "/output/";
        File file = new File(libraryDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((file = new File(libraryFile = String.valueOf(libraryDir) + "ElementExporterTestLibrary_out_10.xml")).exists()) {
            file.delete();
        }
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (String)libraryFile, (boolean)false);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_10.xml", "ElementExporterTestLibrary_out_10.xml"));
    }

    public void testExportDesignToNewLibraryFile() throws Exception {
        this.testExportDesignToNewLibraryFile("ElementExporterTest.xml", "ElementExporterTestLibrary_out_12.xml");
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_12.xml", "ElementExporterTestLibrary_out_12.xml"));
        String libraryFile = String.valueOf(this.getTempFolder()) + "/output/" + "ElementExporterTestLibrary_out_12.xml";
        ReportDesignHandle newDesign = this.sessionHandle.createDesign();
        ElementFactory factory = newDesign.getElementFactory();
        newDesign.getMasterPages().add((DesignElementHandle)factory.newGraphicMasterPage("My Page"));
        try {
            ElementExportUtil.exportDesign((ReportDesignHandle)newDesign, (String)libraryFile, (boolean)false, (boolean)true);
            ElementExporterTest.fail();
        }
        catch (NameException nameException) {}
        newDesign.getMasterPages().drop(0);
        newDesign.getBody().add((DesignElementHandle)factory.newLabel(""));
        try {
            ElementExportUtil.exportDesign((ReportDesignHandle)newDesign, (String)libraryFile, (boolean)true, (boolean)false);
            ElementExporterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest1.xml", "ElementExporterTestLibrary_out_13.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Library));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest2.xml", "ElementExporterTestLibrary_out_14.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Library));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest3.xml", "ElementExporterTestLibrary_out_15.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Cell));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest1.xml", "ElementExporterTestLibrary_out_13.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Library));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest2.xml", "ElementExporterTestLibrary_out_14.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Library));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest3.xml", "ElementExporterTestLibrary_out_15.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Cell));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest1.xml", "ElementExporterTestLibrary_out_13.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Library));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest2.xml", "ElementExporterTestLibrary_out_14.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Library));
        }
        try {
            this.testExportDesignToNewLibraryFile("ElementExporterTest3.xml", "ElementExporterTestLibrary_out_15.xml");
            ElementExporterTest.fail();
        }
        catch (ContentException e) {
            ElementExporterTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
            ElementExporterTest.assertTrue((boolean)(e.getElement() instanceof Cell));
        }
    }

    private void testExportDesignToNewLibraryFile(String inputFile, String outputFile) throws Exception {
        String libraryFile;
        this.openDesign(inputFile, ULocale.ENGLISH);
        String libraryDir = String.valueOf(this.getTempFolder()) + "/output/";
        File file = new File(libraryDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((file = new File(libraryFile = String.valueOf(libraryDir) + outputFile)).exists()) {
            file.delete();
        }
        ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (String)libraryFile, (boolean)true, (boolean)true);
    }

    public void testExportingOneLabelWithUserProperty() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label5");
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_11.xml"));
    }

    public void testExportingExtendItemWithSignificativeName() throws Exception {
        this.testExportDesignToNewLibraryFile("ElementExporterTest_4.xml", "ElementExporterTestLibrary_out_13.xml");
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_13.xml", "ElementExporterTestLibrary_out_13.xml"));
    }

    public void testExportingEmbeddedImage() throws Exception {
        this.openDesign("DesignUsesLibraryEmbeddedImage.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("images");
        EmbeddedImageHandle embeddedImageHandle = (EmbeddedImageHandle)propHandle.getAt(0);
        ElementExportUtil.exportStructure((StructureHandle)embeddedImageHandle, (LibraryHandle)this.libraryHandle, (boolean)true);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_14.xml"));
    }

    public void testHasLibrary() throws Exception {
        this.openDesign("ModelUtilTest_hasContainLibrary.xml");
        this.openLibrary("Containlibrary.xml");
        try {
            ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)true, (boolean)true);
            ElementExporterTest.fail();
        }
        catch (SemanticException e) {
            ElementExporterTest.assertEquals((String)"Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY", (String)e.getErrorCode());
        }
        this.libraryHandle.setFileName("notcontainlibrary.xml");
        LibraryUtil.hasLibrary((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle);
        this.libraryHandle.close();
        this.openLibrary("RelativeContainlibrary.xml");
        try {
            ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)true, (boolean)true);
            ElementExporterTest.fail();
        }
        catch (SemanticException e) {
            ElementExporterTest.assertEquals((String)"Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY", (String)e.getErrorCode());
        }
    }

    public void testExportDesign() throws Exception {
        this.openDesign("ElementExporterTest_6.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        DataItemHandle itemHandle = (DataItemHandle)this.designHandle.getElementByID(5L);
        ElementExporterTest.assertNull((Object)itemHandle.getName());
        ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)true, (boolean)true);
        itemHandle = (DataItemHandle)this.libraryHandle.findElement("NewData1");
        ElementExporterTest.assertEquals((int)1, (int)itemHandle.getListProperty("boundDataColumns").size());
        itemHandle = (DataItemHandle)this.libraryHandle.findElement("NewData");
        ElementExporterTest.assertNotNull((Object)this.libraryHandle.findCube("testCube"));
    }

    public void testExportPropertyBinding() throws Exception {
        this.openDesign("ElementExporterTest_PropertyBinding.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)false, (boolean)false);
        DataSetHandle dsHandle = (DataSetHandle)this.libraryHandle.getDataSets().get(0);
        long id = dsHandle.getID();
        List propertyBindings = this.libraryHandle.getListProperty("propertyBindings");
        PropertyBinding propBinding = (PropertyBinding)propertyBindings.get(0);
        ElementExporterTest.assertEquals((long)id, (long)propBinding.getID().longValue());
        DataSetHandle designDsHandle = (DataSetHandle)this.designHandle.getDataSets().get(0);
        ElementExporterTest.assertFalse((designDsHandle.getID() == id ? 1 : 0) != 0);
    }

    public void testExportXtabFromLibrary() throws Exception {
        this.openDesign("ExportXtab.xml");
        this.openLibrary("Library_5.xml");
        ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)true, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_15.xml"));
    }

    public void testCanExport() throws Exception {
        this.openDesign("ElementExporterTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        DataSetHandle ds = this.designHandle.findDataSet("dataSet1");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)ds, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)ds));
        ScriptDataSetHandle tmpDs = this.libraryHandle.getElementFactory().newScriptDataSet("dataSet1");
        this.libraryHandle.getDataSets().add((DesignElementHandle)tmpDs);
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)ds, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)ds, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)ds));
        SharedStyleHandle style1 = this.designHandle.findStyle("style1");
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)style1, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)style1));
        TableHandle table = (TableHandle)this.designHandle.findElement("table1");
        GroupHandle group = (GroupHandle)table.getGroups().get(0);
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)group, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)group));
        CustomColorHandle color1 = (CustomColorHandle)this.designHandle.customColorsIterator().next();
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)color1, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)color1));
        CustomColor tmpColor1 = StructureFactory.createCustomColor();
        tmpColor1.setName("customColor1");
        this.libraryHandle.getPropertyHandle("colorPalette").addItem((IStructure)tmpColor1);
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StructureHandle)color1, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)color1, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StructureHandle)color1));
    }

    public void testExportLabelWithoutNameToLib() throws Exception {
        this.openDesign("ExportLabelToLibTest.xml");
        this.openLibrary("ExportLabelToLibTestLibrary.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.getElementByID(6L);
        ElementExporterTest.assertNull((Object)labelHandle.getName());
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExporterTest.assertNull((Object)labelHandle.getName());
        GridHandle gridHandle = (GridHandle)this.designHandle.getElementByID(25L);
        LabelHandle labelWithoutName = (LabelHandle)this.designHandle.getElementByID(41L);
        LabelHandle labelWithName = (LabelHandle)this.designHandle.getElementByID(43L);
        ElementExporterTest.assertNull((Object)gridHandle.getName());
        ElementExporterTest.assertNull((Object)labelWithoutName.getName());
        ElementExporterTest.assertNotNull((Object)labelWithName.getName());
        ElementExportUtil.exportElement((DesignElementHandle)gridHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExporterTest.assertNull((Object)gridHandle.getName());
        ElementExporterTest.assertNull((Object)labelWithoutName.getName());
        ElementExporterTest.assertNotNull((Object)labelWithName.getName());
        gridHandle = (GridHandle)this.designHandle.getElementByID(50L);
        try {
            ElementExportUtil.exportElement((DesignElementHandle)gridHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
            ElementExporterTest.fail();
        }
        catch (NameException e) {
            ElementExporterTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        gridHandle = (GridHandle)this.designHandle.getElementByID(60L);
        try {
            ElementExportUtil.exportElement((DesignElementHandle)gridHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
            ElementExporterTest.fail();
        }
        catch (NameException e) {
            ElementExporterTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportLableToLibTest_golden.xml"));
    }

    public void testDropDuplicatedElement() throws Exception {
        this.openDesign("DropDuplicatedElementTest.xml");
        this.openLibrary("DropDuplicatedElementTestLibrary.xml");
        DesignElementHandle rptElement_a = this.designHandle.findElement("a");
        DesignElementHandle rptElement_b = this.designHandle.findElement("b");
        ElementExporterTest.assertNotNull((Object)rptElement_a.getRoot());
        ElementExporterTest.assertNotNull((Object)rptElement_b.getRoot());
        DesignElementHandle tableHandle = this.designHandle.getElementByID(7L);
        DesignElementHandle libElement_a = this.libraryHandle.findElement("a");
        DesignElementHandle libElement_b = this.libraryHandle.findElement("b");
        ElementExporterTest.assertNotNull((Object)libElement_a.getRoot());
        ElementExporterTest.assertNotNull((Object)libElement_b.getRoot());
        ElementExportUtil.exportElement((DesignElementHandle)tableHandle, (LibraryHandle)this.libraryHandle, (boolean)true);
        ElementExporterTest.assertNull((Object)libElement_a.getRoot());
        ElementExporterTest.assertNull((Object)libElement_b.getRoot());
        libElement_a = this.libraryHandle.findElement("a");
        libElement_b = this.libraryHandle.findElement("b");
        ElementExporterTest.assertNotNull((Object)libElement_a.getRoot());
        ElementExporterTest.assertNotNull((Object)libElement_b.getRoot());
    }

    public void testCanExportExtendedItem() throws Exception {
        this.openDesign("ExtendedItemExporterTest.xml");
        this.openLibrary("ExtendedItemExporterTestLibrary.xml");
        DesignElementHandle handle = this.designHandle.findElement("action1");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (boolean)true));
        handle = this.designHandle.findElement("testBox");
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (boolean)true));
    }

    public void testExportTableWithBindingRef() throws Exception {
        this.openDesign("ElementExporterTest_1.xml");
        this.openLibrary("ExportLabelToLibTestLibrary.xml");
        ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)true, (boolean)false);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_16.xml"));
    }

    public void testExportMasterPage() throws Exception {
        this.openDesign("ExportMasterPageTest.xml");
        this.openLibrary("ExportMasterPageTestLibrary.xml");
        MasterPageHandle handle = this.designHandle.findMasterPage("NewSimpleMasterPage");
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        handle = this.designHandle.findMasterPage("Simple MasterPage");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExportUtil.exportElement((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportMasterPageTest_golden.xml"));
    }

    public void testExportStyle() throws Exception {
        this.openDesign("ExportStyleTest.xml");
        this.openLibrary("ExportStyleTestLibrary.xml");
        SharedStyleHandle handle = this.designHandle.findStyle("crosstab");
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        handle = this.designHandle.findStyle("report");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExportUtil.exportElement((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportStyleTest_golden.xml"));
    }

    public void testExportStyleToTheme() throws Exception {
        this.openDesign("ExportStyleToThemeTest.xml");
        this.openLibrary("ExportStyleToThemeTestLibrary.xml");
        ThemeHandle theme = this.libraryHandle.findTheme("theme1");
        SharedStyleHandle style = this.designHandle.findStyle("style1");
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((StyleHandle)style, (ThemeHandle)theme, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((StyleHandle)style, (ThemeHandle)theme, (boolean)true));
        style = this.designHandle.findStyle("report");
        ElementExportUtil.exportStyle((StyleHandle)style, (ThemeHandle)theme, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportStyleToThemeTest_golden.xml"));
    }

    public void testExportExpressionValues() throws Exception {
        this.openDesign("ExportExpressionValuesTest.xml");
        this.openLibrary("ElementExporterTestLibrary.xml");
        ElementExportUtil.exportDesign((ReportDesignHandle)this.designHandle, (LibraryHandle)this.libraryHandle, (boolean)false, (boolean)false);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportExpressionValuesTest_golden.xml"));
    }

    public void testExportXtabWithDuplicatedElementName() throws Exception {
        this.openDesign("ExportXtabWithDuplicatedElementNameTest.xml");
        this.openLibrary("ExportXtabWithDuplicatedElementNameTestLibrary.xml");
        CubeHandle handle = this.designHandle.findCube("Cube");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        handle = this.designHandle.findElement("table");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        handle = this.designHandle.findElement("table1");
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)false));
        try {
            ElementExportUtil.exportElement((DesignElementHandle)handle, (LibraryHandle)this.libraryHandle, (boolean)true);
            ElementExporterTest.fail();
        }
        catch (SemanticException e) {
            ElementExporterTest.assertEquals((String)"Error.SemanticException.EXPORT_ELEMENT_FAIL", (String)e.getErrorCode());
            ElementExporterTest.assertEquals((String)"Duplicated element name in target library, the element NewMeasure View1 can not be exported. Please rename the exported element name.", (String)e.getLocalizedMessage());
        }
    }

    public void testExportCubeWithDuplicatedName() throws Exception {
        this.openDesign("ExportCubeWithDuplicatedNameTest.xml");
        this.openLibrary("ExportCubeWithDuplicatedNameTestLib.xml");
        CubeHandle cube = this.designHandle.findCube("Cube");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExportUtil.exportElement((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportCubeWithDuplicatedNameTestLib_golden.xml"));
    }

    public void testExportCubeWithDuplicatedDimensionName() throws Exception {
        this.openDesign("ExportCubeWithDuplicatedNameTest.xml");
        this.openLibrary("ExportCubeWithDuplicatedNameTestLib_1.xml");
        CubeHandle cube = this.designHandle.findCube("Cube");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExportUtil.exportElement((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportCubeWithDuplicatedNameTestLib_1_golden.xml"));
        this.openLibrary("ExportCubeWithDuplicatedNameTestLib_2.xml");
        ElementExporterTest.assertTrue((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true));
        ElementExporterTest.assertFalse((boolean)ElementExportUtil.canExport((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)false));
        ElementExportUtil.exportElement((DesignElementHandle)cube, (LibraryHandle)this.libraryHandle, (boolean)true);
        this.save((ModuleHandle)this.libraryHandle);
        ElementExporterTest.assertTrue((boolean)this.compareFile("ExportCubeWithDuplicatedNameTestLib_2_golden.xml"));
    }

    public void testExportingTableWithTheme() throws Exception {
        this.openDesign("ElementExporterTest4.xml");
        this.createLibrary();
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("table");
        ElementExportUtil.exportElement((DesignElementHandle)tableHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        this.saveLibrary();
        ElementExporterTest.assertTrue((boolean)this.compareFile("ElementExporterTestLibrary_golden_17.xml"));
    }
}

