/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class FactoryElementHandleTest
extends BaseTestCase {
    private static final String FILE_NAME = "FactoryElementHandleTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetAllFactoryStyles() throws Exception {
        this.openDesign(FILE_NAME);
        List factoryStyles = null;
        StyleHandle styleHandle = null;
        DesignElementHandle freeForm = this.designHandle.findElement("My First Form");
        factoryStyles = freeForm.getFactoryElementHandle().getAllFactoryStyles();
        FactoryElementHandleTest.assertEquals((int)2, (int)factoryStyles.size());
        styleHandle = (StyleHandle)factoryStyles.get(0);
        FactoryElementHandleTest.assertEquals((Object)freeForm.getStyle(), (Object)styleHandle);
        styleHandle = (StyleHandle)factoryStyles.get(1);
        FactoryElementHandleTest.assertEquals((String)((ElementDefn)freeForm.getDefn()).getSelector(), (String)styleHandle.getName());
        freeForm = this.designHandle.findElement("Child Form");
        factoryStyles = freeForm.getFactoryElementHandle().getAllFactoryStyles();
        FactoryElementHandleTest.assertEquals((int)2, (int)factoryStyles.size());
        styleHandle = (StyleHandle)factoryStyles.get(0);
        FactoryElementHandleTest.assertEquals((String)"red", (String)styleHandle.getColor().getStringValue());
        FactoryElementHandleTest.assertEquals((String)"x-small", (String)styleHandle.getFontSize().getStringValue());
        styleHandle = (StyleHandle)factoryStyles.get(1);
        FactoryElementHandleTest.assertEquals((String)((ElementDefn)freeForm.getDefn()).getSelector(), (String)styleHandle.getName());
        DesignElementHandle extendedItem = this.designHandle.findElement("testMatrix_1");
        factoryStyles = extendedItem.getFactoryElementHandle().getAllFactoryStyles();
        FactoryElementHandleTest.assertEquals((int)1, (int)factoryStyles.size());
        styleHandle = (StyleHandle)factoryStyles.get(0);
        FactoryElementHandleTest.assertEquals((String)((ElementDefn)extendedItem.getDefn()).getSelector(), (String)styleHandle.getName());
        extendedItem = this.designHandle.findElement("testMatrix");
        factoryStyles = extendedItem.getFactoryElementHandle().getAllFactoryStyles();
        FactoryElementHandleTest.assertEquals((int)3, (int)factoryStyles.size());
        styleHandle = (StyleHandle)factoryStyles.get(0);
        FactoryElementHandleTest.assertEquals((String)((ElementDefn)extendedItem.getDefn()).getSelector(), (String)styleHandle.getName());
        styleHandle = (StyleHandle)factoryStyles.get(1);
        FactoryElementHandleTest.assertEquals((String)"testing-box-detail", (String)styleHandle.getName());
        styleHandle = (StyleHandle)factoryStyles.get(2);
        FactoryElementHandleTest.assertEquals((String)"testPredefinedStyle1", (String)styleHandle.getName());
        DesignElementHandle cell = this.designHandle.getElementByID(10L);
        factoryStyles = cell.getFactoryElementHandle().getAllFactoryStyles();
        FactoryElementHandleTest.assertEquals((int)2, (int)factoryStyles.size());
        styleHandle = (StyleHandle)factoryStyles.get(0);
        FactoryElementHandleTest.assertEquals((String)"table-detail-cell", (String)styleHandle.getName());
        FactoryElementHandleTest.assertTrue((boolean)cell.getElement().getElementSelectors().contains(styleHandle.getName()));
        styleHandle = (StyleHandle)factoryStyles.get(1);
        DesignElementHandle column = this.designHandle.getElementByID(20L);
        FactoryElementHandleTest.assertEquals((String)column.getStringProperty("fontWeight"), (String)styleHandle.getFontWeight());
        FactoryElementHandleTest.assertEquals((String)column.getStringProperty("fontStyle"), (String)styleHandle.getFontStyle());
        FactoryElementHandleTest.assertEquals((String)column.getStringProperty("fontVariant"), (String)styleHandle.getFontVariant());
    }
}

