/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class GroupPropertyHandleTest
extends BaseTestCase {
    ElementFactory elemFactory = null;
    DesignElementHandle handle1 = null;
    DesignElementHandle handle2 = null;
    DesignElementHandle handle3 = null;
    GroupElementHandle groupElementHandle = null;
    GroupPropertyHandle groupPropertyHandle1 = null;
    GroupPropertyHandle groupPropertyHandle2 = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.createDesign();
        this.elemFactory = new ElementFactory((Module)this.design);
        this.handle1 = this.elemFactory.newGraphicMasterPage("page1");
        this.handle2 = this.elemFactory.newGraphicMasterPage("page2");
        this.handle3 = this.elemFactory.newGraphicMasterPage("page3");
        this.handle1.setStringProperty("type", "custom");
        this.handle2.setStringProperty("type", "custom");
        this.handle3.setStringProperty("type", "custom");
        ArrayList<DesignElementHandle> elements = new ArrayList<DesignElementHandle>();
        elements.add(this.handle1);
        elements.add(this.handle2);
        elements.add(this.handle3);
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("height");
        this.groupPropertyHandle2 = this.groupElementHandle.getPropertyHandle("comments");
    }

    public void testGetStringValue() throws SemanticException {
        this.handle1.setProperty("comments", (Object)"Who am I?");
        this.handle2.setProperty("comments", (Object)"Who am I?");
        this.handle3.setProperty("comments", (Object)"Who am I?");
        this.handle1.setProperty("height", (Object)"12pt");
        this.handle2.setProperty("height", (Object)"13pt");
        this.handle3.setProperty("height", (Object)"12cm");
        GroupPropertyHandleTest.assertNull(null, (Object)this.groupPropertyHandle1.getStringValue());
        GroupPropertyHandleTest.assertEquals((String)"Who am I?", (String)this.groupPropertyHandle2.getStringValue());
        this.handle2.setProperty("height", (Object)"12pt");
        this.handle3.setProperty("height", (Object)"12pt");
        GroupPropertyHandleTest.assertEquals((String)"12pt", (String)this.groupPropertyHandle1.getStringValue());
    }

    public void testGetValue() throws SemanticException {
        this.handle1.setProperty("comments", (Object)"Who am I?");
        this.handle2.setProperty("comments", (Object)"Who am I?");
        this.handle3.setProperty("comments", (Object)"Who am I?");
        this.handle1.setProperty("height", (Object)"12pt");
        this.handle2.setProperty("height", (Object)"13pt");
        this.handle3.setProperty("height", (Object)"12cm");
        GroupPropertyHandleTest.assertNull(null, (Object)this.groupPropertyHandle1.getValue());
        GroupPropertyHandleTest.assertEquals((Object)"Who am I?", (Object)this.groupPropertyHandle2.getValue());
        this.handle2.setProperty("height", (Object)"12pt");
        this.handle3.setProperty("height", (Object)"12pt");
        GroupPropertyHandleTest.assertTrue((boolean)(this.groupPropertyHandle1.getValue() instanceof DimensionValue));
        DimensionValue dimensionValue = (DimensionValue)this.groupPropertyHandle1.getValue();
        GroupPropertyHandleTest.assertEquals((Object)12.0, (Object)dimensionValue.getMeasure());
        GroupPropertyHandleTest.assertEquals((String)"pt", (String)dimensionValue.getUnits());
        TextDataHandle textHandle1 = this.elemFactory.newTextData(null);
        TextDataHandle textHandle2 = this.elemFactory.newTextData(null);
        TextDataHandle textHandle3 = this.elemFactory.newTextData(null);
        this.designHandle.getBody().add((DesignElementHandle)textHandle1);
        this.designHandle.getBody().add((DesignElementHandle)textHandle2);
        this.designHandle.getBody().add((DesignElementHandle)textHandle3);
        ArrayList<TextDataHandle> list = new ArrayList<TextDataHandle>();
        list.add(textHandle1);
        list.add(textHandle2);
        list.add(textHandle3);
        SimpleGroupElementHandle groupHElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, list);
        GroupPropertyHandle propHandle = groupHElementHandle.getPropertyHandle("valueExpr");
        textHandle1.setValueExpr("value");
        textHandle2.setValueExpr("value");
        textHandle3.setValueExpr("value");
        GroupPropertyHandleTest.assertTrue((boolean)(propHandle.getValue() instanceof Expression));
        Expression expr = (Expression)propHandle.getValue();
        GroupPropertyHandleTest.assertEquals((String)"value", (String)expr.getStringExpression());
        textHandle1.setProperty("valueExpr", (Object)new Expression((Object)"value", "constant"));
        textHandle2.setProperty("valueExpr", (Object)new Expression((Object)"value", "constant"));
        textHandle3.setProperty("valueExpr", (Object)new Expression((Object)"value", "constant"));
        GroupPropertyHandleTest.assertTrue((boolean)(propHandle.getValue() instanceof Expression));
        expr = (Expression)propHandle.getValue();
        GroupPropertyHandleTest.assertEquals((String)"value", (String)expr.getStringExpression());
        GroupPropertyHandleTest.assertEquals((String)"constant", (String)expr.getType());
        textHandle1.setProperty("valueExpr", (Object)new Expression((Object)"value", "constant"));
        textHandle2.setProperty("valueExpr", (Object)new Expression((Object)"value", "javascript"));
        textHandle3.setProperty("valueExpr", (Object)new Expression((Object)"value2", "constant"));
        GroupPropertyHandleTest.assertNull((Object)propHandle.getValue());
        textHandle3.setProperty("valueExpr", (Object)new Expression((Object)"value", "constant"));
        GroupPropertyHandleTest.assertNull((Object)propHandle.getValue());
    }

    public void testSetValue() throws SemanticException {
        this.groupPropertyHandle2.setValue((Object)"Rock likes soccer");
        GroupPropertyHandleTest.assertEquals((String)"Rock likes soccer", (String)this.handle1.getStringProperty("comments"));
        GroupPropertyHandleTest.assertEquals((String)"Rock likes soccer", (String)this.handle2.getStringProperty("comments"));
        GroupPropertyHandleTest.assertEquals((String)"Rock likes soccer", (String)this.handle3.getStringProperty("comments"));
        this.groupPropertyHandle1.setValue((Object)"1pt");
        GroupPropertyHandleTest.assertEquals((String)"1pt", (String)this.handle1.getStringProperty("height"));
        GroupPropertyHandleTest.assertEquals((String)"1pt", (String)this.handle2.getStringProperty("height"));
        GroupPropertyHandleTest.assertEquals((String)"1pt", (String)this.handle3.getStringProperty("height"));
    }

    public void testVisibility() {
        this.createDesign();
        this.elemFactory = new ElementFactory((Module)this.design);
        this.handle1 = this.elemFactory.newTextItem("text1");
        this.handle2 = this.elemFactory.newTextItem("text2");
        ArrayList<DesignElementHandle> elements = new ArrayList<DesignElementHandle>();
        elements.add(this.handle1);
        elements.add(this.handle2);
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("dataSet");
        GroupPropertyHandleTest.assertTrue((boolean)this.groupPropertyHandle1.isVisible());
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.isReadOnly());
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("noprop");
        GroupPropertyHandleTest.assertNull((Object)this.groupPropertyHandle1);
        this.handle1 = this.elemFactory.newLabel("label1");
        this.handle2 = this.elemFactory.newFreeForm("form1");
        this.handle3 = this.elemFactory.newLabel("label2");
        elements = new ArrayList();
        elements.add(this.handle1);
        elements.add(this.handle2);
        elements.add(this.handle3);
        ReportDesignHandle Handle = this.design.handle();
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)Handle, elements);
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("x");
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.isVisible());
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.isReadOnly());
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("dataSet");
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.isVisible());
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.isReadOnly());
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("height");
        GroupPropertyHandleTest.assertTrue((boolean)this.groupPropertyHandle1.isVisible());
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.isReadOnly());
    }

    public void testEquals() {
        GroupPropertyHandleTest.assertTrue((boolean)this.groupPropertyHandle1.equals((Object)this.handle1.getPropertyHandle("height")));
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.equals((Object)this.handle1.getPropertyHandle("width")));
        GraphicMasterPageHandle handle4 = this.elemFactory.newGraphicMasterPage("page4");
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.equals((Object)handle4.getPropertyHandle("width")));
        GroupPropertyHandleTest.assertTrue((boolean)this.groupPropertyHandle1.equals((Object)this.groupElementHandle.getPropertyHandle("height")));
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.equals((Object)this.groupElementHandle.getPropertyHandle("width")));
        ArrayList<DesignElementHandle> elements = new ArrayList<DesignElementHandle>();
        elements.add(this.handle1);
        elements.add(this.handle2);
        elements.add(this.handle3);
        SimpleGroupElementHandle groupElementHandle1 = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupPropertyHandleTest.assertFalse((boolean)this.groupPropertyHandle1.equals((Object)groupElementHandle1.getPropertyHandle("width")));
    }

    public void testgetReferenceElementValueList() throws DesignFileException {
        this.openDesign("PropertyHandleTest_1.xml");
        LabelHandle label2 = (LabelHandle)this.designHandle.getComponents().get(1);
        LabelHandle label1 = (LabelHandle)this.designHandle.getComponents().get(0);
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(label2);
        elements.add(label1);
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupPropertyHandle groupPropertyHandle = this.groupElementHandle.getPropertyHandle("dataSet");
        List list = groupPropertyHandle.getReferenceableElementList();
        GroupPropertyHandleTest.assertEquals((int)3, (int)list.size());
        GroupPropertyHandleTest.assertEquals((String)"a", (String)((DesignElementHandle)list.get(0)).getName());
        GroupPropertyHandleTest.assertEquals((String)"b", (String)((DesignElementHandle)list.get(1)).getName());
        GroupPropertyHandleTest.assertEquals((String)"c", (String)((DesignElementHandle)list.get(2)).getName());
        groupPropertyHandle = this.groupElementHandle.getPropertyHandle("style");
        list = groupPropertyHandle.getReferenceableElementList();
        GroupPropertyHandleTest.assertEquals((int)2, (int)list.size());
        DataSetHandle dataSet1 = (DataSetHandle)this.designHandle.getDataSets().get(0);
        DataSetHandle dataSet2 = (DataSetHandle)this.designHandle.getDataSets().get(1);
        elements.clear();
        elements.add(dataSet1);
        elements.add(dataSet2);
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        groupPropertyHandle = this.groupElementHandle.getPropertyHandle("dataSource");
        GroupPropertyHandleTest.assertEquals((int)2, (int)groupPropertyHandle.getReferenceableElementList().size());
    }

    public void testGetLocalValue() throws Exception {
        LabelHandle label = this.designHandle.getElementFactory().newLabel("local");
        LabelHandle parentLabel = this.designHandle.getElementFactory().newLabel("parent");
        LabelHandle childLabel = this.designHandle.getElementFactory().newLabel("child");
        LabelHandle styledLabel = this.designHandle.getElementFactory().newLabel("styled");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        style.setBorderLeftStyle("double");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        this.designHandle.getBody().add((DesignElementHandle)label);
        this.designHandle.getBody().add((DesignElementHandle)childLabel);
        this.designHandle.getBody().add((DesignElementHandle)styledLabel);
        this.designHandle.getComponents().add((DesignElementHandle)parentLabel);
        childLabel.setExtends((DesignElementHandle)parentLabel);
        parentLabel.setProperty("borderLeftStyle", (Object)"double");
        styledLabel.setStyle(style);
        label.setProperty("borderLeftStyle", (Object)"double");
        ArrayList<LabelHandle> elements = new ArrayList<LabelHandle>();
        elements.add(childLabel);
        elements.add(styledLabel);
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("borderLeftStyle");
        GroupPropertyHandleTest.assertNotNull((Object)this.groupPropertyHandle1);
        GroupPropertyHandleTest.assertEquals((String)"double", (String)this.groupPropertyHandle1.getStringValue());
        GroupPropertyHandleTest.assertNull((Object)this.groupPropertyHandle1.getLocalStringValue());
        elements.add(label);
        this.groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        this.groupPropertyHandle1 = this.groupElementHandle.getPropertyHandle("borderLeftStyle");
        GroupPropertyHandleTest.assertNotNull((Object)this.groupPropertyHandle1);
        GroupPropertyHandleTest.assertEquals((String)"double", (String)this.groupPropertyHandle1.getStringValue());
        GroupPropertyHandleTest.assertEquals((String)"double", (String)this.groupPropertyHandle1.getLocalStringValue());
    }
}

