/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class JoinConditionHandleTest
extends BaseTestCase {
    private String fileName = "JoinConditionHandleTest.xml";
    private JoinConditionHandle joinConditionHandle;

    public void setUp() throws DesignFileException {
        this.openDesign(this.fileName);
        JointDataSetHandle dataSet = this.designHandle.findJointDataSet("JointDataSet");
        Iterator joinConditionsIterator = dataSet.joinConditionsIterator();
        this.joinConditionHandle = (JoinConditionHandle)joinConditionsIterator.next();
    }

    public void testGetValue() {
        JoinConditionHandleTest.assertEquals((String)"inner", (String)this.joinConditionHandle.getJoinType());
        JoinConditionHandleTest.assertEquals((String)"eq", (String)this.joinConditionHandle.getOperator());
        JoinConditionHandleTest.assertEquals((String)"DataSet1", (String)this.joinConditionHandle.getLeftDataSet());
        JoinConditionHandleTest.assertEquals((String)"DataSet2", (String)this.joinConditionHandle.getRightDataSet());
        JoinConditionHandleTest.assertEquals((String)"leftExpression", (String)this.joinConditionHandle.getLeftExpression());
        JoinConditionHandleTest.assertEquals((String)"rightExpression", (String)this.joinConditionHandle.getRightExpression());
    }

    public void testSetValue() throws SemanticException {
        this.joinConditionHandle.setJoinType("left-out");
        JoinConditionHandleTest.assertEquals((String)"left-out", (String)this.joinConditionHandle.getJoinType());
        String operator = "eq";
        this.joinConditionHandle.setOperator(operator);
        JoinConditionHandleTest.assertEquals((String)operator, (String)this.joinConditionHandle.getOperator());
        String leftDataSet = "DataSet1";
        this.joinConditionHandle.setLeftDataSet(leftDataSet);
        JoinConditionHandleTest.assertEquals((String)leftDataSet, (String)this.joinConditionHandle.getLeftDataSet());
        String rightDataSet = "DataSet2";
        this.joinConditionHandle.setRightDataSet(rightDataSet);
        JoinConditionHandleTest.assertEquals((String)rightDataSet, (String)this.joinConditionHandle.getRightDataSet());
        String leftExpression = "leftExpression";
        this.joinConditionHandle.setLeftExpression(leftExpression);
        JoinConditionHandleTest.assertEquals((String)leftExpression, (String)this.joinConditionHandle.getLeftExpression());
        String rightExpression = "rightExpression";
        this.joinConditionHandle.setRightExpression(rightExpression);
        JoinConditionHandleTest.assertEquals((String)rightExpression, (String)this.joinConditionHandle.getRightExpression());
    }
}

