/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class JointDataSetHandleTest
extends BaseTestCase {
    private String fileName = "JointDataSetHandleTest.xml";
    private String semanticfileName = "JointDataSetHandleTest_Semantic.xml";
    private String fileNameForRelation = "JointDataSetHandleTest_1.xml";
    private JointDataSetHandle dataSet;

    public void setUp() throws DesignFileException {
        this.openDesign(this.fileName);
        this.dataSet = this.designHandle.findJointDataSet("JointDataSet");
    }

    public void testUnsupportedMethods() {
        JointDataSetHandleTest.assertFalse((boolean)this.dataSet.filtersIterator().hasNext());
        JointDataSetHandleTest.assertFalse((boolean)this.dataSet.resultSetIterator().hasNext());
        JointDataSetHandleTest.assertFalse((boolean)this.dataSet.computedColumnsIterator().hasNext());
        JointDataSetHandleTest.assertFalse((boolean)this.dataSet.columnHintsIterator().hasNext());
        JointDataSetHandleTest.assertFalse((boolean)this.dataSet.parametersIterator().hasNext());
        JointDataSetHandleTest.assertFalse((boolean)this.dataSet.paramBindingsIterator().hasNext());
        JointDataSetHandleTest.assertNotNull((Object)this.dataSet.getCachedMetaDataHandle());
        JointDataSetHandleTest.assertEquals((int)0, (int)this.dataSet.getCachedRowCount());
        JointDataSetHandleTest.assertEquals((int)0, (int)this.dataSet.getDataSetRowLimit());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getAfterClose());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getAfterOpen());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getBeforeClose());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getBeforeOpen());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getDataSource());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getDataSourceName());
        JointDataSetHandleTest.assertNull((Object)this.dataSet.getOnFetch());
    }

    public void testDataSetNames() {
        List dataSets = this.dataSet.getElement().getListProperty((Module)this.design, "dataSets");
        JointDataSetHandleTest.assertEquals((int)2, (int)dataSets.size());
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("DataSet1"), (Object)((ElementRefValue)dataSets.get(0)).getElement());
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("DataSet2"), (Object)((ElementRefValue)dataSets.get(1)).getElement());
    }

    public void testRemoveDataSet() throws SemanticException {
        this.dataSet.removeDataSet("DataSet2");
        List names = this.dataSet.getDataSetNames();
        JointDataSetHandleTest.assertEquals((int)1, (int)names.size());
        JointDataSetHandleTest.assertEquals((Object)"DataSet1", names.get(0));
    }

    public void testAddDataSet() throws SemanticException {
        this.dataSet.addDataSet("DataSet3");
        List dataSets = this.dataSet.getElement().getListProperty((Module)this.design, "dataSets");
        JointDataSetHandleTest.assertEquals((int)3, (int)dataSets.size());
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("DataSet1"), (Object)((ElementRefValue)dataSets.get(0)).getElement());
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("DataSet2"), (Object)((ElementRefValue)dataSets.get(1)).getElement());
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("DataSet3"), (Object)((ElementRefValue)dataSets.get(2)).getElement());
    }

    public void testSematicCheck() throws DesignFileException {
        this.openDesign(this.semanticfileName);
        this.dataSet = this.designHandle.findJointDataSet("JointDataSet");
        List errors = this.design.getErrorList();
        JointDataSetHandleTest.assertEquals((int)2, (int)errors.size());
        ErrorDetail detail = (ErrorDetail)errors.get(0);
        JointDataSetHandleTest.assertSame((Object)this.dataSet.getElement(), (Object)detail.getElement());
        JointDataSetHandleTest.assertEquals((String)"Error.SemanticError.DATA_SET_MISSED_IN_JOINT_DATA_SET", (String)detail.getErrorCode());
        detail = (ErrorDetail)errors.get(1);
        JointDataSetHandleTest.assertSame((Object)this.dataSet.getElement(), (Object)detail.getElement());
        JointDataSetHandleTest.assertEquals((String)"Error.SemanticError.DATA_SET_MISSED_IN_JOINT_DATA_SET", (String)detail.getErrorCode());
    }

    public void testReference() throws Exception {
        this.openDesign(this.fileNameForRelation);
        JointDataSetHandle jdsHandle = this.designHandle.findJointDataSet("Data Set");
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum((DataSetHandle)jdsHandle));
        DataSetHandle dsHandle = (DataSetHandle)this.design.findDataSet("Data Set1").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set2").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set3").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        jdsHandle.addDataSet("Data Set3");
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum((DataSetHandle)jdsHandle));
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set3").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().undo();
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().redo();
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().undo();
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        jdsHandle.removeDataSet("Data Set1");
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set1").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().undo();
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().redo();
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().undo();
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        jdsHandle.drop();
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set1").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set2").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)0, (int)this.countNum(dsHandle));
        this.designHandle.getCommandStack().undo();
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set2").getHandle(this.design.getRoot());
        JointDataSetHandleTest.assertEquals((int)1, (int)this.countNum(dsHandle));
        dsHandle = (DataSetHandle)this.design.findDataSet("Data Set1").getHandle(this.design.getRoot());
        dsHandle.drop();
        JointDataSetHandleTest.assertNull((Object)this.design.findDataSet("Data Set1"));
        this.designHandle.getCommandStack().undo();
        JointDataSetHandleTest.assertNotNull((Object)this.design.findDataSet("Data Set1"));
    }

    private int countNum(DataSetHandle dsHandle) {
        DataSet ds = (DataSet)dsHandle.getElement();
        return ds.getClientList().size();
    }

    public void testReferenceAfterDropDataSet() throws SemanticException {
        DataSetHandle ds1 = this.designHandle.findDataSet("DataSet1");
        DataSetHandle ds2 = this.designHandle.findDataSet("DataSet2");
        ds1.dropAndClear();
        List datasets = this.dataSet.getListProperty("dataSets");
        JointDataSetHandleTest.assertEquals((int)1, (int)datasets.size());
        Iterator clients = ds2.clientsIterator();
        JointDataSetHandleTest.assertTrue((boolean)clients.hasNext());
        this.dataSet.drop();
        clients = ds2.clientsIterator();
        JointDataSetHandleTest.assertFalse((boolean)clients.hasNext());
    }
}

