/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.ByteArrayOutputStream;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LayoutTableTest
extends BaseTestCase {
    private String fileName = "LayoutTableTest1.xml";
    private String filled_fileName = "LayoutTableTest2.xml";
    private String effectiveSpans_fileName = "LayoutTableTest3.xml";
    private String layout_fileName = "LayoutTableTest4.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testLayoutFillsEmptyCells() throws Exception {
        this.openDesign(this.filled_fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table2");
        CellHandle cell = this.getCellInTableSlot(table, 2, 0, 0);
        LayoutTableTest.assertEquals((int)3, (int)cell.getColumn());
        this.save();
    }

    public void testContentLayout() throws Exception {
        this.openDesign(this.fileName);
        this.os = new ByteArrayOutputStream();
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        LayoutTableTest.assertNotNull((Object)table);
        LayoutTable layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table2");
        LayoutTableTest.assertNotNull((Object)table);
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table3");
        LayoutTableTest.assertNotNull((Object)table);
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table10");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table11");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table14");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table16");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table17");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table20");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table21");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table22");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table24");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table25");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table27");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table28");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table30");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table31");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table32");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table33");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        table = (TableHandle)this.designHandle.findElement("My table34");
        layout = ((TableItem)table.getElement()).getLayoutModel((Module)this.design);
        this.os.write(layout.getLayoutString().getBytes());
        this.os.close();
        LayoutTableTest.assertTrue((boolean)this.compareFile("LayoutTableTest1_golden.txt"));
    }

    public void testEffectiveSpans() throws Exception {
        this.openDesign(this.effectiveSpans_fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        CellHandle cell = this.getCellInTableSlot(table, 2, 0, 0);
        LayoutTableTest.assertEquals((int)1, (int)LayoutUtil.getEffectiveRowSpan((CellHandle)cell));
        LayoutTableTest.assertEquals((int)1, (int)LayoutUtil.getEffectiveColumnSpan((CellHandle)cell));
        cell = this.getCellInTableSlot(table, 2, 1, 0);
        LayoutTableTest.assertEquals((int)1, (int)LayoutUtil.getEffectiveRowSpan((CellHandle)cell));
        LayoutTableTest.assertEquals((int)2, (int)LayoutUtil.getEffectiveColumnSpan((CellHandle)cell));
        table = (TableHandle)this.designHandle.findElement("My table2");
        cell = this.getCellInTableSlot(table, 2, 0, 1);
        LayoutTableTest.assertEquals((int)1, (int)LayoutUtil.getEffectiveRowSpan((CellHandle)cell));
        LayoutTableTest.assertEquals((int)1, (int)LayoutUtil.getEffectiveColumnSpan((CellHandle)cell));
        cell = this.getCellInTableSlot(table, 2, 1, 0);
        LayoutTableTest.assertEquals((int)1, (int)LayoutUtil.getEffectiveRowSpan((CellHandle)cell));
        LayoutTableTest.assertEquals((int)2, (int)LayoutUtil.getEffectiveColumnSpan((CellHandle)cell));
    }

    private CellHandle getCellInTableSlot(TableHandle table, int slotID, int rowIndex, int cellIndex) {
        RowHandle row = (RowHandle)table.getSlot(slotID).get(rowIndex);
        CellHandle cell = (CellHandle)row.getSlot(0).get(cellIndex);
        return cell;
    }

    public void testInvalidLayout() throws Exception {
        this.openDesign(this.layout_fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        LayoutTableTest.assertFalse((boolean)LayoutUtil.isValidLayout((TableItem)((TableItem)table.getElement()), (Module)this.design));
        table = (TableHandle)this.designHandle.findElement("My table2");
        LayoutTableTest.assertTrue((boolean)LayoutUtil.isValidLayout((TableItem)((TableItem)table.getElement()), (Module)this.design));
        table = (TableHandle)this.designHandle.findElement("My table3");
        LayoutTableTest.assertTrue((boolean)LayoutUtil.isValidLayout((TableItem)((TableItem)table.getElement()), (Module)this.design));
        table = (TableHandle)this.designHandle.findElement("My table4");
        LayoutTableTest.assertTrue((boolean)LayoutUtil.isValidLayout((TableItem)((TableItem)table.getElement()), (Module)this.design));
        table = (TableHandle)this.designHandle.findElement("My table5");
        LayoutTableTest.assertFalse((boolean)LayoutUtil.isValidLayout((TableItem)((TableItem)table.getElement()), (Module)this.design));
    }
}

