/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ParameterValidationUtilTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBoolean() throws Exception {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        String value = null;
        ParameterValidationUtilTest.assertEquals(null, (Object)ParameterValidationUtil.validate((String)"boolean", null, null, (ULocale)ULocale.JAPAN));
        ParameterValidationUtilTest.assertEquals(null, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)"", (ULocale)ULocale.JAPAN));
        value = "\u771f";
        ParameterValidationUtilTest.assertEquals((Object)Boolean.TRUE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)new ULocale("aa")));
        ParameterValidationUtilTest.assertEquals((Object)Boolean.TRUE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)new ULocale("aa")));
        value = "\u5047";
        ParameterValidationUtilTest.assertEquals((Object)Boolean.FALSE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)new ULocale("aa")));
        ParameterValidationUtilTest.assertEquals((Object)Boolean.FALSE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)new ULocale("aa")));
        value = "true";
        ParameterValidationUtilTest.assertEquals((Object)Boolean.TRUE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)ULocale.JAPAN));
        ParameterValidationUtilTest.assertEquals((Object)Boolean.TRUE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)ULocale.JAPAN));
        value = "false";
        ParameterValidationUtilTest.assertEquals((Object)Boolean.FALSE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)ULocale.JAPAN));
        ParameterValidationUtilTest.assertEquals((Object)Boolean.FALSE, (Object)ParameterValidationUtil.validate((String)"boolean", null, (String)value, (ULocale)ULocale.JAPAN));
        try {
            ParameterValidationUtil.validate((String)"boolean", null, (String)"tru", (ULocale)ULocale.JAPAN);
            ParameterValidationUtilTest.fail();
        }
        catch (ValidationValueException e) {
            System.out.println(e.getMessage());
            ParameterValidationUtilTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            ParameterValidationUtil.validate((String)"boolean", null, (String)"fals", (ULocale)ULocale.JAPAN);
            ParameterValidationUtilTest.fail();
        }
        catch (ValidationValueException e) {
            System.out.println(e.getMessage());
            ParameterValidationUtilTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testNumber() throws Exception {
        double input = 123.4564;
        String value = "123.0";
        ThreadResources.setLocale((ULocale)ULocale.FRANCE);
        NumberFormatter formatter = new NumberFormatter(ThreadResources.getLocale());
        formatter.applyPattern("General Number");
        value = formatter.format(input);
        ParameterValidationUtilTest.assertEquals((String)"123.456", (String)ParameterValidationUtil.validate((String)"float", (String)"General Number", (String)value, (ULocale)ULocale.FRANCE).toString());
        ThreadResources.setLocale((ULocale)ULocale.CHINA);
        formatter = new NumberFormatter(ThreadResources.getLocale());
        formatter.applyPattern("General Number");
        value = formatter.format(input);
        ParameterValidationUtilTest.assertEquals((String)"123.456", (String)ParameterValidationUtil.validate((String)"float", (String)"General Number", (String)value, (ULocale)ULocale.CHINA).toString());
        Object resultVal = ParameterValidationUtil.validate((String)"decimal", (String)"General Number", (String)value, (ULocale)ULocale.CHINA);
        ParameterValidationUtilTest.assertTrue((boolean)(resultVal instanceof BigDecimal));
        ParameterValidationUtilTest.assertEquals((String)"123.456", (String)resultVal.toString());
        try {
            ParameterValidationUtil.validate((String)"decimal", (String)"Scientific", (String)"ergh", (ULocale)ULocale.FRANCE);
            ParameterValidationUtilTest.fail();
        }
        catch (ValidationValueException e) {
            System.out.println(e.getMessage());
            ParameterValidationUtilTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        formatter.applyPattern("General Number");
        value = formatter.format(input);
        resultVal = ParameterValidationUtil.validate((String)"integer", (String)"Unformatted", (String)value, (ULocale)ULocale.CHINA);
        ParameterValidationUtilTest.assertTrue((boolean)(resultVal instanceof Integer));
        ParameterValidationUtilTest.assertEquals((String)"123", (String)resultVal.toString());
        ParameterValidationUtilTest.assertEquals((String)"13", (String)ParameterValidationUtil.validate((String)"integer", (String)"Scientific", (String)"13c1.9ab2", (ULocale)ULocale.CHINA).toString());
    }

    public void testTime() throws Exception {
        String value1 = "12:30:31";
        Time date = (Time)ParameterValidationUtil.validate((String)"time", (String)"General Date", (String)value1);
        ParameterValidationUtilTest.assertEquals((String)"12:30:31", (String)date.toString());
        String value2 = "122a:30:31";
        try {
            ParameterValidationUtil.validate((String)"time", (String)"General Date", (String)value2);
            ParameterValidationUtilTest.fail();
        }
        catch (ValidationValueException e) {
            ParameterValidationUtilTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testDate() throws Exception {
        String value1 = "1998-09-13";
        java.sql.Date date = (java.sql.Date)ParameterValidationUtil.validate((String)"date", (String)"General Date", (String)value1);
        ParameterValidationUtilTest.assertEquals((String)"1998-09-13", (String)date.toString());
        String value2 = "1992a-123-12";
        try {
            ParameterValidationUtil.validate((String)"date", (String)"General Date", (String)value2);
            ParameterValidationUtilTest.fail();
        }
        catch (ValidationValueException e) {
            ParameterValidationUtilTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testDateTime() throws Exception {
        String value1 = "1998-09-13 20:01:44";
        this.testDateTimeByFormat("General Date", value1);
        String value2 = "1998-09-13 00:00:00";
        this.testDateTimeByFormat("Long Date", value2);
        String value3 = "1998-09-13 00:00:00";
        this.testDateTimeByFormat("Medium Date", value3);
        String value4 = "1998-09-13 00:00:00";
        this.testDateTimeByFormat("Short Date", value4);
        String value5 = "1970-01-01 20:01:44";
        this.testDateTimeByFormat("Long Time", value5);
        String value6 = "1970-01-01 20:01:44";
        this.testDateTimeByFormat("Medium Time", value6);
        String value7 = "1970-01-01 20:01:00";
        this.testDateTimeByFormat("Short Time", value7);
    }

    private void testDateTimeByFormat(String format, String result) throws Exception {
        ThreadResources.setLocale((ULocale)ULocale.JAPAN);
        String value = null;
        SimpleDateFormat formatPattern = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar dateCal = Calendar.getInstance((ULocale)ThreadResources.getLocale());
        dateCal.set(1998, 8, 13, 20, 1, 44);
        DateFormatter formatter = new DateFormatter(ThreadResources.getLocale());
        formatter.applyPattern(format);
        value = formatter.format(dateCal.getTime());
        String resultJAP = formatPattern.format(ParameterValidationUtil.validate((String)"dateTime", (String)format, (String)value, (ULocale)ULocale.JAPAN) == null ? null : ParameterValidationUtil.validate((String)"dateTime", (String)format, (String)value, (ULocale)ULocale.JAPAN));
        ParameterValidationUtilTest.assertEquals((String)result, (String)resultJAP);
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        dateCal = Calendar.getInstance((ULocale)ThreadResources.getLocale());
        dateCal.set(1998, 8, 13, 20, 1, 44);
        formatter = new DateFormatter(ThreadResources.getLocale());
        formatter.applyPattern(format);
        value = formatter.format(dateCal.getTime());
        String resultEN = formatPattern.format(ParameterValidationUtil.validate((String)"dateTime", (String)format, (String)value, (ULocale)ULocale.ENGLISH) == null ? null : ParameterValidationUtil.validate((String)"dateTime", (String)format, (String)value, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)result, (String)resultEN);
        ParameterValidationUtilTest.assertEquals((String)resultJAP, (String)resultEN);
        Object obj = ParameterValidationUtil.validate((String)"dateTime", null, (String)"1/1/1999 4:50:10 am", (ULocale)ULocale.US);
        ParameterValidationUtilTest.assertNotNull((Object)obj);
        ParameterValidationUtilTest.assertTrue((boolean)(obj instanceof Date));
        try {
            ParameterValidationUtil.validate((String)"dateTime", null, (String)"1999-2-27", (ULocale)ULocale.US);
            ParameterValidationUtilTest.fail();
        }
        catch (ValidationValueException e) {
            ParameterValidationUtilTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testString() throws Exception {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        String value = null;
        ParameterValidationUtilTest.assertEquals(null, (Object)ParameterValidationUtil.validate((String)"string", null, value, (ULocale)ULocale.ENGLISH));
        value = "";
        ParameterValidationUtilTest.assertEquals((Object)"", (Object)ParameterValidationUtil.validate((String)"string", null, (String)value, (ULocale)ULocale.ENGLISH));
        value = "ab CD e";
        ParameterValidationUtilTest.assertEquals((Object)"ab CD e", (Object)ParameterValidationUtil.validate((String)"string", null, (String)value, (ULocale)ULocale.ENGLISH));
        value = "ab $#";
        ParameterValidationUtilTest.assertEquals((Object)"ab $#", (Object)ParameterValidationUtil.validate((String)"string", null, (String)value, (ULocale)ULocale.ENGLISH));
        value = "(444)444-4444";
        ParameterValidationUtilTest.assertEquals((Object)"4444444444", (Object)ParameterValidationUtil.validate((String)"string", (String)"Phone Number", (String)value, (ULocale)ULocale.ENGLISH));
    }

    public void testGetDisplayValue() {
        Calendar dateCal = Calendar.getInstance((ULocale)ThreadResources.getLocale());
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date dateValue = dateCal.getTime();
        ParameterValidationUtilTest.assertEquals((String)"13 septembre 1998", (String)ParameterValidationUtil.getDisplayValue((String)"dateTime", (String)"Long Date", (Object)dateValue, (ULocale)ULocale.FRANCE));
        ParameterValidationUtilTest.assertEquals((String)"Sep 13, 1998 8:01 PM", (String)ParameterValidationUtil.getDisplayValue((String)"dateTime", null, (Object)dateValue));
        dateValue = new java.sql.Date(100, 0, 1);
        ParameterValidationUtilTest.assertEquals((String)"1 janvier 2000", (String)ParameterValidationUtil.getDisplayValue((String)"date", (String)"Long Date", (Object)dateValue, (ULocale)ULocale.FRANCE));
        ParameterValidationUtilTest.assertEquals((String)"January 1, 2000", (String)ParameterValidationUtil.getDisplayValue((String)"date", (String)"Long Date", (Object)dateValue, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)"Jan 1, 2000", (String)ParameterValidationUtil.getDisplayValue((String)"date", null, (Object)dateValue));
        Time timeValue = new Time(14, 20, 30);
        ParameterValidationUtilTest.assertEquals((String)"2:20:30 PM", (String)ParameterValidationUtil.getDisplayValue((String)"time", (String)"Medium Time", (Object)timeValue, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)"14:20:30", (String)ParameterValidationUtil.getDisplayValue((String)"time", (String)"Medium Time", (Object)timeValue, (ULocale)ULocale.FRANCE));
        ParameterValidationUtilTest.assertEquals((String)"2:20:30 PM", (String)ParameterValidationUtil.getDisplayValue((String)"time", null, (Object)timeValue));
        Double doubleValue = new Double("12345.456");
        ParameterValidationUtilTest.assertEquals((String)"12345.456", (String)ParameterValidationUtil.getDisplayValue((String)"float", (String)"General Number", (Object)doubleValue, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)"12345,456", (String)ParameterValidationUtil.getDisplayValue((String)"float", (String)"General Number", (Object)doubleValue, (ULocale)ULocale.GERMAN));
        ParameterValidationUtilTest.assertEquals((String)"Currency12345", (String)ParameterValidationUtil.getDisplayValue((String)"float", (String)"Currency", (Object)doubleValue, (ULocale)ULocale.GERMAN));
        Integer integerValue = new Integer("12345");
        ParameterValidationUtilTest.assertEquals((String)"12345", (String)ParameterValidationUtil.getDisplayValue((String)"integer", (String)"General Number", (Object)integerValue, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)"12345", (String)ParameterValidationUtil.getDisplayValue((String)"integer", (String)"General Number", (Object)integerValue, (ULocale)ULocale.GERMAN));
        ParameterValidationUtilTest.assertEquals((String)"Currency12345", (String)ParameterValidationUtil.getDisplayValue((String)"float", (String)"Currency", (Object)integerValue, (ULocale)ULocale.GERMAN));
        BigDecimal decimalValue = new BigDecimal("12345678.1234");
        ParameterValidationUtilTest.assertEquals((String)"12.345.678,12", (String)ParameterValidationUtil.getDisplayValue((String)"decimal", (String)"Standard", (Object)decimalValue, (ULocale)ULocale.GERMAN));
        ParameterValidationUtilTest.assertEquals((String)"12,345,678.12", (String)ParameterValidationUtil.getDisplayValue((String)"decimal", (String)"Standard", (Object)decimalValue, (ULocale)ULocale.ENGLISH));
        String stringValue = "0211234567";
        ParameterValidationUtilTest.assertEquals((String)"(021)123-4567", (String)ParameterValidationUtil.getDisplayValue((String)"string", (String)"Phone Number", (Object)stringValue, (ULocale)ULocale.GERMAN));
        ParameterValidationUtilTest.assertEquals((String)"(021)123-4567", (String)ParameterValidationUtil.getDisplayValue((String)"string", (String)"Phone Number", (Object)stringValue, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)"021123-4567", (String)ParameterValidationUtil.getDisplayValue((String)"string", (String)"Zip Code + 4", (Object)stringValue, (ULocale)ULocale.GERMAN));
        ParameterValidationUtilTest.assertEquals((String)"false", (String)ParameterValidationUtil.getDisplayValue((String)"boolean", null, (Object)Boolean.FALSE, (ULocale)ULocale.ENGLISH));
        ParameterValidationUtilTest.assertEquals((String)"\u5047", (String)ParameterValidationUtil.getDisplayValue((String)"boolean", null, (Object)Boolean.FALSE, (ULocale)new ULocale("aa")));
    }
}

