/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SimpleMasterPageHandleTest
extends BaseTestCase {
    private final String INPUT_FILE_NAME = "SimpleMasterPageHandleTest.xml";
    private final String GOLDEN_FILE_NAME = "SimpleMasterPageHandleTest_golden.xml";
    private final String ERROR_INPUT_FILE_NAME = "SimpleMasterPageHandleTest_1.xml";
    SimpleMasterPageHandle mHandle = null;
    SimpleMasterPage page = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("SimpleMasterPageHandleTest.xml");
    }

    public void testProperties() throws Exception {
        this.mHandle = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Page1");
        SimpleMasterPageHandleTest.assertNotNull((Object)this.mHandle);
        SimpleMasterPageHandleTest.assertTrue((boolean)this.mHandle.showHeaderOnFirst());
        SimpleMasterPageHandleTest.assertFalse((boolean)this.mHandle.showFooterOnLast());
        SimpleMasterPageHandleTest.assertTrue((boolean)this.mHandle.isFloatingFooter());
        this.mHandle.setShowHeaderOnFirst(false);
        this.mHandle.setShowFooterOnLast(true);
        this.mHandle.setFloatingFooter(true);
        SimpleMasterPageHandleTest.assertFalse((boolean)this.mHandle.showHeaderOnFirst());
        SimpleMasterPageHandleTest.assertTrue((boolean)this.mHandle.showFooterOnLast());
        SimpleMasterPageHandleTest.assertTrue((boolean)this.mHandle.isFloatingFooter());
        SimpleMasterPageHandleTest.assertEquals((String)"0.5in", (String)this.mHandle.getHeaderHeight().getDisplayValue());
        SimpleMasterPageHandleTest.assertEquals((String)"in", (String)this.mHandle.getHeaderHeight().getDefaultUnit());
        SimpleMasterPageHandleTest.assertEquals((String)"0.5in", (String)this.mHandle.getFooterHeight().getDisplayValue());
        SimpleMasterPageHandleTest.assertEquals((String)"in", (String)this.mHandle.getFooterHeight().getDefaultUnit());
    }

    public void testSlots() throws Exception {
        this.mHandle = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Page1");
        SlotHandle slot = this.mHandle.getPageHeader();
        SimpleMasterPageHandleTest.assertEquals((int)1, (int)slot.getCount());
        SimpleMasterPageHandleTest.assertEquals((String)"text1", (String)slot.get(0).getName());
        slot = this.mHandle.getPageFooter();
        SimpleMasterPageHandleTest.assertEquals((int)1, (int)slot.getCount());
        SimpleMasterPageHandleTest.assertEquals((String)"free-form1", (String)slot.get(0).getName());
    }

    public void testSemanticErrors() throws Exception {
        try {
            this.openDesign("SimpleMasterPageHandleTest_1.xml");
        }
        catch (DesignFileException ex) {
            List list = ex.getErrorList();
            SimpleMasterPageHandleTest.assertEquals((int)2, (int)list.size());
            ErrorDetail e = (ErrorDetail)list.get(0);
            SimpleMasterPageHandleTest.assertEquals((String)"Error.ContentException.SLOT_IS_FULL", (String)e.getErrorCode());
            e = (ErrorDetail)list.get(1);
            SimpleMasterPageHandleTest.assertEquals((String)"Error.ContentException.SLOT_IS_FULL", (String)e.getErrorCode());
        }
    }

    public void testWriterSimpleMasterPage() throws Exception {
        this.mHandle = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Page1");
        this.mHandle.setShowFooterOnLast(true);
        this.mHandle.setShowHeaderOnFirst(true);
        this.mHandle.setFloatingFooter(false);
        this.mHandle.getPageFooter().drop(0);
        this.save();
        SimpleMasterPageHandleTest.assertTrue((boolean)this.compareFile("SimpleMasterPageHandleTest_golden.xml"));
    }
}

