/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.report.model.api.ApiTestUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TableColumnBandTest
extends BaseTestCase {
    private String fileName = "TableColumnBandTest.xml";
    private String shiftFileName = "TableShiftColumnBandTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testColumnCopy() throws Exception {
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        TableColumnBandTest.assertNotNull((Object)table);
        ColumnBandData data = table.copyColumn(1);
        TableColumnBandTest.assertEquals((int)2, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        table = (TableHandle)this.designHandle.findElement("My table2");
        TableColumnBandTest.assertNotNull((Object)table);
        data = table.copyColumn(2);
        TableColumnBandTest.assertEquals((int)1, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        TableColumn column = ApiTestUtil.getCopiedColumn((ColumnBandData)data);
        TableColumnBandTest.assertEquals((int)1, (int)column.getIntProperty((Module)this.design, "repeat"));
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty((Module)this.design, "color"));
        TableColumnBandTest.assertEquals((int)2, (int)ApiTestUtil.getCopiedCell((ColumnBandData)data, (int)0).getRowSpan((Module)this.design));
        table = (TableHandle)this.designHandle.findElement("My table3");
        TableColumnBandTest.assertNotNull((Object)table);
        TableColumnBandTest.assertFalse((boolean)table.canCopyColumn(1));
        try {
            data = table.copyColumn(1);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        TableColumnBandTest.assertFalse((boolean)table.canCopyColumn(2));
        try {
            data = table.copyColumn(2);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        table = (TableHandle)this.designHandle.findElement("My table4");
        TableColumnBandTest.assertNotNull((Object)table);
        TableColumnBandTest.assertFalse((boolean)table.canCopyColumn(1));
        try {
            data = table.copyColumn(1);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        data = table.copyColumn(2);
        TableColumnBandTest.assertEquals((int)2, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        TableColumnBandTest.assertEquals((Object)"black", (Object)ApiTestUtil.getCopiedCell((ColumnBandData)data, (int)1).getProperty((Module)this.design, "color"));
    }

    public void testCopyPasteWithForbiddenLayout() throws Exception {
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        TableColumnBandTest.assertNotNull((Object)table);
        ColumnBandData data = table.copyColumn(1);
        ElementFactory factory = table.getElementFactory();
        TableHandle newTable = factory.newTableItem("newTable1", 2, 0, 1, 0);
        TableColumnBandTest.assertEquals((int)2, (int)newTable.getColumns().getCount());
        TableColumnBandTest.assertFalse((boolean)newTable.canPasteColumn(data, 1, true));
        try {
            newTable.pasteColumn(data, 1, true);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testCopyNoColumnHeader2HasColumn() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table1 = factory.newTableItem("table1", 2, 0, 2, 0);
        TableHandle table2 = factory.newTableItem("table2", 2, 0, 2, 0);
        SlotHandle columns2 = table2.getColumns();
        ColumnHandle column1InTable2 = (ColumnHandle)columns2.get(0);
        ColumnHandle column2InTable2 = (ColumnHandle)columns2.get(1);
        column1InTable2.setStringProperty("color", "aqua");
        column2InTable2.setStringProperty("color", "aqua");
        int numOfColumnsInTable1 = table1.getColumns().getCount();
        int i = 0;
        while (i < numOfColumnsInTable1) {
            table1.getColumns().dropAndClear(0);
            ++i;
        }
        TableColumnBandTest.assertEquals((int)0, (int)table1.getColumns().getCount());
        ColumnBandData data = table1.copyColumn(1);
        table2.pasteColumn(data, 1, true);
        TableColumnBandTest.assertEquals((int)2, (int)columns2.getCount());
        column1InTable2 = (ColumnHandle)columns2.get(0);
        TableColumnBandTest.assertEquals((Object)"black", (Object)column1InTable2.getProperty("color"));
        column2InTable2 = (ColumnHandle)columns2.get(1);
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column2InTable2.getProperty("color"));
    }

    public void testCopyHasColumnHeader2NoColumn() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table1 = factory.newTableItem("table1", 2, 0, 2, 0);
        TableHandle table2 = factory.newTableItem("table2", 2, 0, 2, 0);
        SlotHandle columns1 = table1.getColumns();
        ColumnHandle column1InTable1 = (ColumnHandle)columns1.get(0);
        ColumnHandle column2InTable1 = (ColumnHandle)columns1.get(1);
        column1InTable1.setStringProperty("color", "aqua");
        column2InTable1.setStringProperty("color", "aqua");
        int numOfColumnsInTable1 = table2.getColumns().getCount();
        int i = 0;
        while (i < numOfColumnsInTable1) {
            table2.getColumns().dropAndClear(0);
            ++i;
        }
        TableColumnBandTest.assertEquals((int)0, (int)table2.getColumns().getCount());
        ColumnBandData data = table1.copyColumn(1);
        table2.pasteColumn(data, 1, true);
        SlotHandle columns2 = table2.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns2.getCount());
        ColumnHandle column1InTable2 = (ColumnHandle)columns2.get(0);
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column1InTable2.getProperty("color"));
        ColumnHandle column2InTable2 = (ColumnHandle)columns2.get(1);
        column2InTable2 = (ColumnHandle)columns2.get(1);
        TableColumnBandTest.assertEquals((Object)"black", (Object)column2InTable2.getProperty("color"));
    }

    public void testPasteColumnHeader() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table1 = factory.newTableItem("table1", 3, 0, 2, 0);
        TableHandle table2 = factory.newTableItem("table2", 3, 0, 2, 0);
        SlotHandle columns1 = table1.getColumns();
        ColumnHandle column1InTable1 = (ColumnHandle)columns1.get(0);
        column1InTable1.setStringProperty("color", "aqua");
        SlotHandle columns2 = table2.getColumns();
        int numOfColumnsInTable2 = columns2.getCount();
        int i = 0;
        while (i < numOfColumnsInTable2 - 1) {
            columns2.dropAndClear(0);
            ++i;
        }
        ColumnHandle columnInTable2 = (ColumnHandle)columns2.get(0);
        columnInTable2.setRepeatCount(3);
        TableColumnBandTest.assertEquals((int)1, (int)columns2.getCount());
        ColumnBandData data = table1.copyColumn(1);
        table2.pasteColumn(data, 1, true);
        TableColumnBandTest.assertEquals((int)2, (int)columns2.getCount());
        ColumnHandle column1InTable2 = (ColumnHandle)columns2.get(0);
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column1InTable2.getProperty("color"));
        ColumnHandle column2InTable2 = (ColumnHandle)columns2.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)column2InTable2.getRepeatCount());
        TableColumnBandTest.assertEquals((Object)"black", (Object)column2InTable2.getProperty("color"));
        numOfColumnsInTable2 = columns2.getCount();
        int i2 = 0;
        while (i2 < numOfColumnsInTable2 - 1) {
            columns2.dropAndClear(0);
            ++i2;
        }
        columnInTable2 = (ColumnHandle)columns2.get(0);
        columnInTable2.setRepeatCount(3);
        TableColumnBandTest.assertEquals((int)1, (int)columns2.getCount());
        data = table1.copyColumn(1);
        table2.pasteColumn(data, 3, true);
        TableColumnBandTest.assertEquals((int)2, (int)columns2.getCount());
        column1InTable2 = (ColumnHandle)columns2.get(0);
        TableColumnBandTest.assertEquals((int)2, (int)column1InTable2.getRepeatCount());
        TableColumnBandTest.assertEquals((Object)"black", (Object)column1InTable2.getProperty("color"));
        column2InTable2 = (ColumnHandle)columns2.get(1);
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column2InTable2.getProperty("color"));
        numOfColumnsInTable2 = columns2.getCount();
        columns2.dropAndClear(1);
        columnInTable2 = (ColumnHandle)columns2.get(0);
        columnInTable2.setRepeatCount(3);
        TableColumnBandTest.assertEquals((int)1, (int)columns2.getCount());
        data = table1.copyColumn(1);
        table2.pasteColumn(data, 2, true);
        TableColumnBandTest.assertEquals((int)3, (int)columns2.getCount());
        column1InTable2 = (ColumnHandle)columns2.get(0);
        TableColumnBandTest.assertEquals((int)1, (int)column1InTable2.getRepeatCount());
        TableColumnBandTest.assertEquals((Object)"black", (Object)column1InTable2.getProperty("color"));
        column2InTable2 = (ColumnHandle)columns2.get(1);
        TableColumnBandTest.assertEquals((int)1, (int)column2InTable2.getRepeatCount());
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column2InTable2.getProperty("color"));
        ColumnHandle column3InTable2 = (ColumnHandle)columns2.get(2);
        TableColumnBandTest.assertEquals((int)1, (int)column3InTable2.getRepeatCount());
        TableColumnBandTest.assertEquals((Object)"black", (Object)column3InTable2.getProperty("color"));
    }

    public void testPasteNonMergedCells2MergedCells() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable1");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable1");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        SlotHandle detail = pasteTable.getDetail();
        RowHandle row1 = (RowHandle)detail.get(0);
        RowHandle row2 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)1, (int)row2.getCells().getCount());
        CellHandle cell1 = (CellHandle)row1.getCells().get(0);
        TableColumnBandTest.assertEquals((int)2, (int)cell1.getRowSpan());
        SlotHandle columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        ColumnHandle column2 = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((String)"red", (String)column2.getStringProperty("color"));
        ColumnBandData data = copyTable.copyColumn(1);
        TableColumnBandTest.assertFalse((boolean)pasteTable.canPasteColumn(data, 1, false));
        try {
            pasteTable.pasteColumn(data, 1, false);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_DIFFERENT_LAYOUT", (String)e.getErrorCode());
        }
        pasteTable.pasteColumn(data, 1, true);
        detail = pasteTable.getDetail();
        TableColumnBandTest.assertEquals((int)2, (int)detail.getCount());
        row1 = (RowHandle)detail.get(0);
        row2 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)2, (int)row2.getCells().getCount());
        cell1 = (CellHandle)row1.getCells().get(0);
        TableColumnBandTest.assertEquals((int)1, (int)cell1.getRowSpan());
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        column2 = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((String)"aqua", (String)column2.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)1, (int)column2.getRepeatCount());
        ColumnHandle column1 = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((String)"red", (String)column1.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)1, (int)column2.getRepeatCount());
    }

    public void testPasteMergedCells2NonMergedCells() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable2");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable2");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        SlotHandle detail = pasteTable.getDetail();
        RowHandle row1 = (RowHandle)detail.get(0);
        RowHandle row2 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)2, (int)row2.getCells().getCount());
        SlotHandle columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)1, (int)columns.getCount());
        ColumnHandle column1 = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)2, (int)column1.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column1.getStringProperty("color"));
        ColumnBandData data = copyTable.copyColumn(1);
        TableColumnBandTest.assertEquals((int)1, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        TableColumnBandTest.assertFalse((boolean)pasteTable.canPasteColumn(data, 2, false));
        TableColumnBandTest.assertTrue((boolean)pasteTable.canPasteColumn(data, 2, true));
        try {
            pasteTable.pasteColumn(data, 2, false);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_DIFFERENT_LAYOUT", (String)e.getErrorCode());
        }
        pasteTable.pasteColumn(data, 2, true);
        detail = pasteTable.getDetail();
        TableColumnBandTest.assertEquals((int)2, (int)detail.getCount());
        row1 = (RowHandle)detail.get(0);
        row2 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)1, (int)row2.getCells().getCount());
        CellHandle cell1 = (CellHandle)row1.getCells().get(1);
        TableColumnBandTest.assertEquals((int)2, (int)cell1.getRowSpan());
        TableColumnBandTest.assertEquals((int)1, (int)cell1.getContent().getCount());
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        ColumnHandle column2 = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((String)"yellow", (String)column2.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)1, (int)column2.getRepeatCount());
        column1 = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((String)"aqua", (String)column1.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)1, (int)column2.getRepeatCount());
    }

    public void testPasteWithUndoRedo() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable2");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable2");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        SlotHandle detail = pasteTable.getDetail();
        RowHandle row1 = (RowHandle)detail.get(0);
        RowHandle row2 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)2, (int)row2.getCells().getCount());
        SlotHandle columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)1, (int)columns.getCount());
        ColumnBandData data = copyTable.copyColumn(1);
        pasteTable.pasteColumn(data, 2, true);
        detail = pasteTable.getDetail();
        TableColumnBandTest.assertEquals((int)2, (int)detail.getCount());
        row1 = (RowHandle)detail.get(0);
        row2 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)1, (int)row2.getCells().getCount());
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        this.design.getActivityStack().undo();
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)2, (int)row2.getCells().getCount());
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)1, (int)columns.getCount());
        this.design.getActivityStack().redo();
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        TableColumnBandTest.assertEquals((int)1, (int)row2.getCells().getCount());
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
    }

    public void testColumnWithDifferentLayout() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable3");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable3");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        SlotHandle pasteFooter = pasteTable.getFooter();
        RowHandle pasteFooterRow = (RowHandle)pasteFooter.get(0);
        CellHandle pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(1);
        DesignElementHandle pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof LabelHandle));
        TableColumnBandTest.assertEquals((String)"toReplacedLabel", (String)pasteFooterCellContent.getName());
        ColumnBandData data = copyTable.copyColumn(2);
        pasteTable.pasteColumn(data, 2, true);
        SlotHandle pasteColumns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)3, (int)pasteColumns.getCount());
        ColumnHandle column = (ColumnHandle)pasteColumns.get(0);
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column.getProperty("color"));
        column = (ColumnHandle)pasteColumns.get(1);
        TableColumnBandTest.assertEquals((Object)"red", (Object)column.getProperty("color"));
        column = (ColumnHandle)pasteColumns.get(2);
        TableColumnBandTest.assertEquals((Object)"aqua", (Object)column.getProperty("color"));
        pasteFooter = pasteTable.getFooter();
        pasteFooterRow = (RowHandle)pasteFooter.get(0);
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(1);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof TextItemHandle));
    }

    public void testColumnWithMultiplePaste() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable3");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable3");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        ColumnBandData data = copyTable.copyColumn(2);
        pasteTable.pasteColumn(data, 2, true);
        ColumnBandData clonedData = data.copy();
        pasteTable.pasteColumn(clonedData, 3, true);
        SlotHandle pasteFooter = pasteTable.getFooter();
        RowHandle pasteFooterRow = (RowHandle)pasteFooter.get(0);
        CellHandle pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(1);
        DesignElementHandle pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof TextItemHandle));
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(2);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof TextItemHandle));
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(0);
        TableColumnBandTest.assertEquals((int)0, (int)pasteFooterCell.getContent().getCount());
    }

    public void testInsertAndPasteWithColumn() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable3");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable3");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        ColumnBandData data = copyTable.copyColumn(2);
        pasteTable.insertAndPasteColumn(data, 2);
        SlotHandle columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)3, (int)columns.getCount());
        ColumnHandle column = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)2, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(2);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)4, (int)pasteTable.getColumnCount());
        SlotHandle pasteFooter = pasteTable.getFooter();
        RowHandle pasteFooterRow = (RowHandle)pasteFooter.get(0);
        TableColumnBandTest.assertEquals((int)4, (int)pasteFooterRow.getCells().getCount());
        CellHandle pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(1);
        DesignElementHandle pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof LabelHandle));
        TableColumnBandTest.assertEquals((String)"toReplacedLabel", (String)pasteFooterCellContent.getName());
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(2);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof TextItemHandle));
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(0);
        TableColumnBandTest.assertEquals((int)0, (int)pasteFooterCell.getContent().getCount());
        this.designHandle.getCommandStack().undo();
        pasteTable.insertAndPasteColumn(data, 3);
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        column = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)3, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)4, (int)pasteTable.getColumnCount());
        pasteFooter = pasteTable.getFooter();
        pasteFooterRow = (RowHandle)pasteFooter.get(0);
        TableColumnBandTest.assertEquals((int)4, (int)pasteFooterRow.getCells().getCount());
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(1);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof LabelHandle));
        TableColumnBandTest.assertEquals((String)"toReplacedLabel", (String)pasteFooterCellContent.getName());
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(3);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof TextItemHandle));
        this.designHandle.getCommandStack().undo();
        TableColumnBandTest.assertTrue((boolean)pasteTable.canInsertAndPasteColumn(data, 0));
        pasteTable.insertAndPasteColumn(data, 0);
        columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        column = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((int)3, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        TableColumnBandTest.assertEquals((int)4, (int)pasteTable.getColumnCount());
        pasteFooter = pasteTable.getFooter();
        pasteFooterRow = (RowHandle)pasteFooter.get(0);
        TableColumnBandTest.assertEquals((int)4, (int)pasteFooterRow.getCells().getCount());
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(0);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof TextItemHandle));
        pasteFooterCell = (CellHandle)pasteFooterRow.getCells().get(2);
        pasteFooterCellContent = pasteFooterCell.getContent().get(0);
        TableColumnBandTest.assertTrue((boolean)(pasteFooterCellContent instanceof LabelHandle));
        TableColumnBandTest.assertEquals((String)"toReplacedLabel", (String)pasteFooterCellContent.getName());
    }

    public void testCanInsertAndPaste() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable2");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable2");
        TableColumnBandTest.assertNotNull((Object)pasteTable);
        ColumnBandData data = copyTable.copyColumn(1);
        TableColumnBandTest.assertEquals((int)1, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        TableColumnBandTest.assertTrue((boolean)pasteTable.canInsertAndPasteColumn(data, 1));
        TableColumnBandTest.assertTrue((boolean)pasteTable.canInsertAndPasteColumn(data, 2));
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        TableColumnBandTest.assertNotNull((Object)table);
        data = table.copyColumn(1);
        ElementFactory factory = table.getElementFactory();
        TableHandle newTable = factory.newTableItem("newTable1", 2, 2, 0, 2);
        TableColumnBandTest.assertEquals((int)2, (int)newTable.getColumns().getCount());
        TableColumnBandTest.assertFalse((boolean)newTable.canInsertAndPasteColumn(data, 1));
        newTable = factory.newTableItem("newTable1", 2, 2, 0, 0);
        table = (TableHandle)this.designHandle.findElement("My table5");
        TableColumnBandTest.assertNotNull((Object)table);
        data = newTable.copyColumn(1);
        TableColumnBandTest.assertFalse((boolean)table.canInsertAndPasteColumn(data, 1));
        TableColumnBandTest.assertFalse((boolean)table.canInsertAndPasteColumn(data, 2));
    }

    public void testInsertPasteWithoutColumns() throws Exception {
        this.openDesign(this.fileName);
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle newTable = factory.newTableItem("newTable1", 2, 0, 2, 0);
        TableColumnBandTest.assertEquals((int)2, (int)newTable.getColumns().getCount());
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table5");
        TableColumnBandTest.assertNotNull((Object)table);
        ColumnBandData data = newTable.copyColumn(1);
        TableColumnBandTest.assertFalse((boolean)table.canInsertAndPasteColumn(data, 1));
        TableColumnBandTest.assertTrue((boolean)table.canInsertAndPasteColumn(data, 2));
        table.insertAndPasteColumn(data, 2);
        TableColumnBandTest.assertEquals((int)3, (int)table.getColumnCount());
        SlotHandle columns = table.getColumns();
        TableColumnBandTest.assertEquals((int)3, (int)columns.getCount());
        SlotHandle detail = table.getDetail();
        RowHandle row1 = (RowHandle)detail.get(0);
        TableColumnBandTest.assertEquals((int)2, (int)row1.getCells().getCount());
        row1 = (RowHandle)detail.get(1);
        TableColumnBandTest.assertEquals((int)3, (int)row1.getCells().getCount());
    }

    public void testInsertAndPasteForColumn() throws Exception {
        this.openDesign(this.fileName);
        TableHandle copyTable = (TableHandle)this.designHandle.findElement("CopyTable4");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        TableHandle pasteTable = (TableHandle)this.designHandle.findElement("PasteTable4");
        TableColumnBandTest.assertNotNull((Object)copyTable);
        ColumnBandData data = copyTable.copyColumn(1);
        pasteTable.insertAndPasteColumn(data, 1);
        SlotHandle columns = pasteTable.getColumns();
        TableColumnBandTest.assertEquals((int)3, (int)columns.getCount());
        ColumnHandle column = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(2);
        TableColumnBandTest.assertEquals((int)2, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        RowHandle row = (RowHandle)pasteTable.getDetail().get(0);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(1);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(2);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(3);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        this.design.getActivityStack().undo();
        data = data.copy();
        pasteTable.insertAndPasteColumn(data, 2);
        column = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)2, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(2);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        row = (RowHandle)pasteTable.getDetail().get(0);
        cell = (CellHandle)row.getCells().get(0);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(1);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(2);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getRowSpan());
        TableColumnBandTest.assertEquals((int)1, (int)cell.getContent().getCount());
        cell = (CellHandle)row.getCells().get(3);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        this.design.getActivityStack().undo();
        data = data.copy();
        pasteTable.insertAndPasteColumn(data, 3);
        TableColumnBandTest.assertEquals((int)2, (int)columns.getCount());
        column = (ColumnHandle)columns.get(0);
        TableColumnBandTest.assertEquals((int)3, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"aqua", (String)column.getStringProperty("color"));
        column = (ColumnHandle)columns.get(1);
        TableColumnBandTest.assertEquals((int)1, (int)column.getRepeatCount());
        TableColumnBandTest.assertEquals((String)"red", (String)column.getStringProperty("color"));
        row = (RowHandle)pasteTable.getDetail().get(0);
        cell = (CellHandle)row.getCells().get(0);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(1);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)row.getCells().get(2);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        TableColumnBandTest.assertEquals((int)0, (int)cell.getContent().getCount());
        cell = (CellHandle)row.getCells().get(3);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getRowSpan());
        TableColumnBandTest.assertEquals((int)1, (int)cell.getContent().getCount());
    }

    public void testShiftSuccessfully() throws Exception {
        this.openDesign(this.shiftFileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("Table1");
        TableColumnBandTest.assertNotNull((Object)table);
        table.shiftColumn(2, 3);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_1.xml"));
        this.designHandle.getCommandStack().undo();
        table.shiftColumn(2, 4);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_2.xml"));
        this.designHandle.getCommandStack().undo();
        TableColumnBandTest.assertTrue((boolean)table.canShiftColumn(2, 2));
        table.shiftColumn(2, 2);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_3.xml"));
        table.shiftColumn(4, 1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_4.xml"));
        this.designHandle.getCommandStack().undo();
        table.shiftColumn(4, 2);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_5.xml"));
        this.designHandle.getCommandStack().undo();
        table.shiftColumn(3, 2);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_6.xml"));
        table.shiftColumn(3, 0);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableShiftColumnBand_golden_7.xml"));
    }

    public void testShiftFailed() throws Exception {
        this.openDesign(this.fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table3");
        TableColumnBandTest.assertNotNull((Object)table);
        TableColumnBandTest.assertFalse((boolean)table.canShiftColumn(2, 0));
        try {
            table.shiftColumn(2, 0);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        TableColumnBandTest.assertFalse((boolean)table.canShiftColumn(1, 2));
        try {
            table.shiftColumn(1, 2);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        table = (TableHandle)this.designHandle.findElement("My table4");
        TableColumnBandTest.assertNotNull((Object)table);
        TableColumnBandTest.assertFalse((boolean)table.canShiftColumn(1, 2));
        try {
            table.shiftColumn(1, 2);
            TableColumnBandTest.fail();
        }
        catch (SemanticException e) {
            TableColumnBandTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testOperationsOnCopiedTable() throws SemanticException, CloneNotSupportedException {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1", 3);
        this.designHandle.getBody().add((DesignElementHandle)table);
        TableHandle table1 = (TableHandle)table.copy().getHandle(this.designHandle.getModule());
        table1.setName("table2");
        TableColumnBandTest.assertNotNull((Object)table1.getLayoutModel());
        this.designHandle.getBody().add((DesignElementHandle)table1);
        TableColumnBandTest.assertTrue((boolean)table1.canCopyColumn(1));
        TableColumnBandTest.assertTrue((boolean)table1.canCopyColumn(2));
        TableColumnBandTest.assertTrue((boolean)table1.canPasteColumn(table1.copyColumn(1), 1, false));
        TableItem table2 = (TableItem)table.getElement().clone();
        TableColumnBandTest.assertNotNull((Object)table2.getLayoutModel(this.designHandle.getModule()));
        TableColumnBandTest.assertTrue((boolean)((TableHandle)table2.getHandle(this.designHandle.getModule())).canCopyColumn(1));
        TableColumnBandTest.assertTrue((boolean)((TableHandle)table2.getHandle(this.designHandle.getModule())).canCopyColumn(2));
    }

    public void testPasteColumn() throws Exception {
        this.openDesign("TableColumnBandTest_1.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("test1");
        TableColumnBandTest.assertEquals((int)4, (int)table.getColumnCount());
        RowHandle row = (RowHandle)table.getDetail().get(1);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        TableColumnBandTest.assertEquals((int)0, (int)cell.getContent().getCount());
        cell = (CellHandle)row.getCells().get(1);
        String expected = ((LabelHandle)cell.getContent().getContents().get(0)).getText();
        ColumnBandData data = table.copyColumn(2);
        table.pasteColumn(data, 3, true);
        TableColumnBandTest.assertEquals((int)4, (int)table.getColumnCount());
        cell = (CellHandle)row.getCells().get(2);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getContent().getCount());
        String result = ((LabelHandle)cell.getContent().getContents().get(0)).getText();
        TableColumnBandTest.assertEquals((String)expected, (String)result);
        table = (TableHandle)this.designHandle.findElement("test2");
        TableColumnBandTest.assertEquals((int)4, (int)table.getColumnCount());
        row = (RowHandle)table.getDetail().get(1);
        cell = (CellHandle)row.getCells().get(0);
        expected = ((LabelHandle)cell.getContent().getContents().get(0)).getText();
        cell = (CellHandle)row.getCells().get(2);
        TableColumnBandTest.assertEquals((int)0, (int)cell.getContent().getCount());
        data = table.copyColumn(1);
        table.insertAndPasteColumn(data, 3);
        TableColumnBandTest.assertEquals((int)5, (int)table.getColumnCount());
        cell = (CellHandle)row.getCells().get(2);
        result = ((LabelHandle)cell.getContent().getContents().get(0)).getText();
        TableColumnBandTest.assertEquals((String)expected, (String)result);
    }

    public void testInsertColumn() throws Exception {
        this.openDesign("TableInsertColumnBandTest.xml");
        long maxId = this.design.getNextID();
        TableHandle table = (TableHandle)this.designHandle.findElement("test1");
        table.insertColumn(1, -1);
        SlotHandle detail = table.getDetail();
        TableColumnBandTest.assertEquals((int)5, (int)((RowHandle)detail.get(0)).getCells().getCount());
        TableColumnBandTest.assertEquals((int)5, (int)((RowHandle)detail.get(1)).getCells().getCount());
        CellHandle cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(1);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        TableColumnBandTest.assertEquals((long)11L, (long)cell.getID());
        cell = (CellHandle)((RowHandle)detail.get(1)).getCells().get(0);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getRowSpan());
        TableColumnBandTest.assertEquals((int)1, (int)cell.getColumnSpan());
        this.designHandle.getCommandStack().undo();
        table.insertColumn(1, 1);
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(0);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(1);
        TableColumnBandTest.assertEquals((int)0, (int)cell.getContent().getCount());
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(2);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getContent().getCount());
        this.designHandle.getCommandStack().undo();
        table.insertColumn(2, 1);
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(1);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getContent().getCount());
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(2);
        TableColumnBandTest.assertEquals((int)1, (int)cell.getRowSpan());
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(3);
        TableColumnBandTest.assertEquals((int)2, (int)cell.getRowSpan());
        this.designHandle.getCommandStack().undo();
        table.insertColumn(4, 1);
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(3);
        TableColumnBandTest.assertTrue((cell.getID() == 14L ? 1 : 0) != 0);
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(4);
        TableColumnBandTest.assertTrue((cell.getID() > maxId ? 1 : 0) != 0);
        cell = (CellHandle)((RowHandle)detail.get(1)).getCells().get(4);
        TableColumnBandTest.assertTrue((cell.getID() > maxId ? 1 : 0) != 0);
        this.designHandle.getCommandStack().undo();
        table.insertColumn(4, -1);
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(3);
        TableColumnBandTest.assertTrue((cell.getID() > maxId ? 1 : 0) != 0);
        cell = (CellHandle)((RowHandle)detail.get(0)).getCells().get(4);
        TableColumnBandTest.assertTrue((cell.getID() == 14L ? 1 : 0) != 0);
        cell = (CellHandle)((RowHandle)detail.get(1)).getCells().get(3);
        TableColumnBandTest.assertEquals((long)18L, (long)cell.getID());
        table = (TableHandle)this.designHandle.findElement("test2");
        table.insertColumn(1, 1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_golden.xml"));
        this.designHandle.getCommandStack().undo();
        table.insertColumn(2, -1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_golden_1.xml"));
        this.designHandle.getCommandStack().undo();
        table.insertColumn(2, 1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_golden_2.xml"));
        this.designHandle.getCommandStack().undo();
        table.insertColumn(3, -1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_golden_3.xml"));
        this.designHandle.getCommandStack().undo();
        table.insertColumn(3, 1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_golden_4.xml"));
        this.openDesign("TableInsertColumnBandTest_1.xml");
        table = (TableHandle)this.designHandle.findElement("Table");
        table.insertColumn(1, 1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_rowSpan_golden_1.xml"));
        this.openDesign("TableInsertColumnBandTest_2.xml");
        table = (TableHandle)this.designHandle.findElement("Table");
        table.insertColumn(2, 1);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableInsertColumnBandTest_colSpan_golden_1.xml"));
    }

    private boolean reorderColumns(TableHandle tableHandle, int[] indexMappings) throws SemanticException {
        if (indexMappings == null) {
            return false;
        }
        int columnCount = tableHandle.getColumnCount();
        if (indexMappings.length != columnCount) {
            return false;
        }
        int[] checkedArray = new int[indexMappings.length];
        System.arraycopy(indexMappings, 0, checkedArray, 0, indexMappings.length);
        Arrays.sort(checkedArray);
        int i = 0;
        while (i < checkedArray.length) {
            if (checkedArray[i] != i) {
                return false;
            }
            ++i;
        }
        ArrayList<Integer> cachedIndices = new ArrayList<Integer>();
        int i2 = 1;
        while (i2 <= columnCount) {
            cachedIndices.add(new Integer(i2));
            ++i2;
        }
        try {
            this.designHandle.getCommandStack().startTrans("reorder columns");
            i2 = 0;
            while (i2 < columnCount) {
                Integer targetColumn = new Integer(indexMappings[i2] + 1);
                int currentIndex = cachedIndices.indexOf(targetColumn);
                assert (currentIndex != -1);
                if (currentIndex != i2 && currentIndex != i2 + 1) {
                    int target = i2 + 1;
                    if (currentIndex + 1 > i2 + 1) {
                        target = i2;
                    }
                    tableHandle.shiftColumn(currentIndex + 1, target);
                    if (currentIndex < i2) {
                        cachedIndices.add(i2 + 1, targetColumn);
                        cachedIndices.remove(currentIndex);
                    } else {
                        cachedIndices.remove(currentIndex);
                        cachedIndices.add(i2 + 1 - 1, targetColumn);
                    }
                }
                ++i2;
            }
        }
        catch (SemanticException e) {
            this.designHandle.getCommandStack().rollback();
            throw e;
        }
        this.designHandle.getCommandStack().commit();
        return true;
    }

    public void testReorderColumns() throws Exception {
        this.openDesign(this.shiftFileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("Table1");
        TableColumnBandTest.assertNotNull((Object)table);
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 3;
        this.reorderColumns(table, nArray);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableReorderColumnBand_golden_1.xml"));
        this.designHandle.getCommandStack().undo();
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[1] = 2;
        nArray2[2] = 1;
        this.reorderColumns(table, nArray2);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableReorderColumnBand_golden_2.xml"));
        this.designHandle.getCommandStack().undo();
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        this.reorderColumns(table, nArray3);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableReorderColumnBand_golden_3.xml"));
        this.designHandle.getCommandStack().undo();
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        this.reorderColumns(table, nArray4);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableReorderColumnBand_golden_4.xml"));
        int[] nArray5 = new int[4];
        nArray5[0] = 3;
        nArray5[1] = 1;
        nArray5[2] = 2;
        this.reorderColumns(table, nArray5);
        this.save();
        TableColumnBandTest.assertTrue((boolean)this.compareFile("TableReorderColumnBand_golden_5.xml"));
    }
}

