/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TableItemHandleTest
extends BaseTestCase {
    private static final String fileName = "TableItemHandleTest.xml";
    private static final String fileCopyName = "TableItemHandleTest_1.xml";
    private static final String tableWidthTestFileName = "TableItemHandleTest_2.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testRowCopyPasteAction() throws Exception {
        this.openDesign(fileCopyName);
        TableHandle table1 = (TableHandle)this.designHandle.findElement("My table1");
        TableHandle table2 = (TableHandle)this.designHandle.findElement("My table2");
        TableHandle table3 = (TableHandle)this.designHandle.findElement("My table3");
        TableItemHandleTest.assertNotNull((Object)table1);
        TableItemHandleTest.assertEquals((int)13, (int)table1.getColumnCount());
        RowOperationParameters parameters1 = new RowOperationParameters(0, 0, 0);
        RowOperationParameters parameters2 = new RowOperationParameters(0, 0, 1);
        RowOperationParameters parameters3 = new RowOperationParameters(2, -1, 1);
        RowOperationParameters parameters4 = new RowOperationParameters(0, -1, 0);
        RowOperationParameters parameters5 = new RowOperationParameters(2, -1, 1);
        RowOperationParameters parameters6 = new RowOperationParameters(0, 1, 0);
        TableItemHandleTest.assertTrue((boolean)table1.canCopyRow(parameters1));
        TableItemHandleTest.assertFalse((boolean)table1.canCopyRow(parameters2));
        TableItemHandleTest.assertFalse((boolean)table1.canCopyRow(parameters5));
        IDesignElement clonedData = table1.copyRow(parameters1);
        TableRow clonedRow = (TableRow)clonedData.getHandle((Module)this.design).getElement();
        Cell cell = (Cell)clonedRow.getContentsSlot().get(0);
        Object obj = cell.getSlot(0).getContents().get(0);
        TableItemHandleTest.assertTrue((boolean)(obj instanceof DataItem));
        TableItemHandleTest.assertEquals((Object)"PHONE", (Object)((DataItem)obj).getLocalProperty(null, "resultSetColumn"));
        TableItemHandleTest.assertNull((Object)clonedRow.getContainer());
        try {
            table1.copyRow(parameters5);
            TableItemHandleTest.fail((String)"fail to copy Row ");
        }
        catch (SemanticException e) {
            TableItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        TableItemHandleTest.assertTrue((boolean)table1.canPasteRow(clonedData, parameters1));
        TableItemHandleTest.assertTrue((boolean)table1.canPasteRow(clonedData, parameters6));
        TableItemHandleTest.assertFalse((boolean)table3.canPasteRow(clonedData, parameters4));
        TableItemHandleTest.assertFalse((boolean)table1.canPasteRow(clonedData, parameters3));
        table1.pasteRow(clonedData, parameters6);
        this.save();
        TableItemHandleTest.assertTrue((boolean)this.compareFile("TableRowCopy_golden_1.xml"));
        try {
            table1.pasteRow(null, parameters6);
            TableItemHandleTest.fail((String)"fail to paste Row because copied row is null");
        }
        catch (IllegalArgumentException e) {
            TableItemHandleTest.assertEquals((String)"empty row to paste.", (String)e.getMessage());
        }
        RowOperationParameters parameters7 = new RowOperationParameters(0, 1, -1);
        RowOperationParameters parameters9 = new RowOperationParameters(2, -1, 2);
        TableItemHandleTest.assertTrue((boolean)table2.canInsertRow(parameters4));
        TableItemHandleTest.assertFalse((boolean)table1.canInsertRow(parameters7));
        TableItemHandleTest.assertFalse((boolean)table2.canInsertRow(parameters1));
        parameters5.setDestIndex(2);
        TableItemHandleTest.assertFalse((boolean)table1.canInsertRow(parameters5));
        try {
            table2.insertRow(parameters1);
            TableItemHandleTest.fail((String)"table2 insert error ");
        }
        catch (SemanticException e) {
            TableItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_INSERT_FORBIDDEN", (String)e.getErrorCode());
        }
        table2.insertRow(parameters4);
        this.save();
        TableItemHandleTest.assertTrue((boolean)this.compareFile("TableRowCopy_golden_2.xml"));
        table2.insertRow(parameters4);
        this.save();
        TableItemHandleTest.assertTrue((boolean)this.compareFile("TableRowCopy_golden_3.xml"));
        clonedRow = (TableRow)clonedRow.clone();
        parameters1.setSourceIndex(0);
        TableItemHandleTest.assertFalse((boolean)table1.canShiftRow(parameters1));
        parameters9.setSourceIndex(0);
        TableItemHandleTest.assertFalse((boolean)table1.canShiftRow(parameters9));
        parameters5.setSourceIndex(0);
        TableItemHandleTest.assertFalse((boolean)table1.canShiftRow(parameters5));
        parameters4.setSourceIndex(2);
        TableItemHandleTest.assertTrue((boolean)table2.canShiftRow(parameters4));
        try {
            table2.shiftRow(parameters9);
            TableItemHandleTest.fail((String)"table2 shift error ");
        }
        catch (SemanticException e) {
            TableItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_SHIFT_FORBIDDEN", (String)e.getErrorCode());
        }
        table2.shiftRow(parameters4);
        this.save();
        TableItemHandleTest.assertTrue((boolean)this.compareFile("TableRowCopy_golden_4.xml"));
        clonedData = (IDesignElement)clonedData.clone();
        TableItemHandleTest.assertTrue((boolean)table2.canInsertAndPasteRow(clonedData, parameters4));
        TableItemHandleTest.assertFalse((boolean)table2.canInsertAndPasteRow(clonedData, parameters1));
        TableItemHandleTest.assertFalse((boolean)table1.canInsertAndPasteRow(clonedData, parameters5));
        try {
            table2.insertAndPasteRow(clonedData, parameters1);
            TableItemHandleTest.fail((String)"table2 inert and paste error ");
        }
        catch (SemanticException e) {
            TableItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_INSERTANDPASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        table2.insertAndPasteRow(clonedData, parameters4);
        this.save();
        TableItemHandleTest.assertTrue((boolean)this.compareFile("TableRowCopy_golden_5.xml"));
    }

    public void testRowCopyPasteInNestedTable() throws Exception {
        this.openDesign("TableItemHandleTest_nested.xml");
        TableHandle table3 = (TableHandle)this.designHandle.findElement("My table3");
        RowOperationParameters parameters1 = new RowOperationParameters(0, -1, 0);
        RowOperationParameters parameters2 = new RowOperationParameters(2, -1, 0);
        TableItemHandleTest.assertTrue((boolean)table3.canCopyRow(parameters2));
        IDesignElement clonedData = table3.copyRow(parameters2);
        TableRow clonedRow = (TableRow)clonedData.getHandle((Module)this.design).getElement();
        TableItemHandleTest.assertNotNull((Object)clonedRow);
        TableItemHandleTest.assertNull((Object)clonedRow.getContainer());
        try {
            table3.pasteRow(clonedData, parameters1);
            TableItemHandleTest.fail((String)"Paste Row error in header slot");
        }
        catch (SemanticException e) {
            TableItemHandleTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
        }
    }

    public void testGetColumnCount() throws Exception {
        this.openDesign(fileName);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table1");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table2");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table3");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table4");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)4, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table5");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)4, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table7");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)4, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table8");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)5, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table9");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table10");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table11");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table12");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table13");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)4, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table14");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table15");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table16");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table17");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)4, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table18");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)1, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table19");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)1, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table20");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)6, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table21");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)6, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table22");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)4, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table23");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table24");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table25");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table26");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table27");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)2, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table28");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)3, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table29");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)20, (int)table.getColumnCount());
        table = (TableHandle)this.designHandle.findElement("My table30");
        TableItemHandleTest.assertNotNull((Object)table);
        TableItemHandleTest.assertEquals((int)20, (int)table.getColumnCount());
        TableItemHandleTest.assertEquals((int)0, (int)this.designHandle.getErrorList().size());
    }

    public void testInsertGroup() throws Exception {
        block2: {
            this.createDesign();
            TableHandle table = this.designHandle.getElementFactory().newTableItem("testTable", 3, 1, 1, 1);
            try {
                this.designHandle.getCommandStack().startTrans(null);
                TableGroupHandle group = this.newTableGroup(1, 1, 3);
                table.getGroups().add((DesignElementHandle)group);
                table.getColumns().get(0).setProperty("color", (Object)"blue");
                CellHandle cell = (CellHandle)((RowHandle)group.getHeader().get(0)).getCells().get(0);
                TableItemHandleTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
                this.designHandle.getCommandStack().commit();
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private TableGroupHandle newTableGroup(int headerRowNum, int footerRowNum, int columnNum) throws SemanticException {
        assert (headerRowNum > 0 && footerRowNum > 0 && columnNum > 0);
        TableGroupHandle group = this.designHandle.getElementFactory().newTableGroup();
        int i = 0;
        while (i < headerRowNum) {
            group.getHeader().add((DesignElementHandle)this.designHandle.getElementFactory().newTableRow(columnNum));
            ++i;
        }
        i = 0;
        while (i < footerRowNum) {
            group.getFooter().add((DesignElementHandle)this.designHandle.getElementFactory().newTableRow(columnNum));
            ++i;
        }
        return group;
    }

    public void testSetPageBreakOnRow() throws SemanticException {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("testTable", 3, 1, 1, 1);
        RowHandle tableRow = (RowHandle)table.getHeader().get(0);
        TableItemHandleTest.assertNotNull((Object)tableRow.getDefn().getProperty("pageBreakAfter"));
        TableItemHandleTest.assertNotNull((Object)tableRow.getDefn().getProperty("pageBreakBefore"));
        TableItemHandleTest.assertNotNull((Object)tableRow.getDefn().getProperty("pageBreakInside"));
    }

    public void testRenameGroup() throws SemanticException {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("testTable", 3, 1, 1, 1);
        TableGroupHandle group = this.newTableGroup(1, 1, 3);
        group.setName("group1");
        table.getGroups().add((DesignElementHandle)group);
        group = this.newTableGroup(1, 1, 3);
        group.setName("group2");
        table.getGroups().add((DesignElementHandle)group);
        try {
            group.setName("group1");
            TableItemHandleTest.fail();
        }
        catch (NameException e) {
            TableItemHandleTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
    }

    public void testSummaryTable() throws Exception {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("testTable");
        table.setIsSummaryTable(true);
        table.getHeader().add((DesignElementHandle)table.getElementFactory().newTableRow());
        table.getFooter().add((DesignElementHandle)table.getElementFactory().newTableRow());
        try {
            table.getDetail().add((DesignElementHandle)table.getElementFactory().newTableRow());
            TableItemHandleTest.fail();
        }
        catch (ContentException e) {
            TableItemHandleTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
        }
        TableItemHandleTest.assertFalse((boolean)table.canContain(2, (DesignElementHandle)table.getElementFactory().newTableRow()));
        TableItemHandleTest.assertFalse((boolean)table.canContain(2, "Row"));
    }

    public void testTableWidthCalculation() throws Exception {
        this.openDesign(tableWidthTestFileName);
        this.checkWidthCalculation("testTable1", "2in");
        this.checkWidthCalculation("testTable2", "2in");
        this.checkWidthCalculation("testTable3", "4cm");
        this.checkWidthCalculation("testTable4", "6px");
        this.checkWidthCalculation("testTable5");
        this.checkWidthCalculation("testTable6", "4in");
        this.checkCalculationException("testTable7", "Error.SemanticError.TABLE_COLUMN_INCONSISTENT_RELATIVE_UNIT");
        this.checkCalculationException("testTable8", "Error.SemanticError.TABLE_COLUMN_INCONSISTENT_UNIT_TYPE");
        this.checkCalculationException("testTable9", "Error.SemanticError.TABLE_COLUMN_ILLEGAL_PERCENTAGE");
        this.checkCalculationException("testTable10", "Error.SemanticError.TABLE_COLUMN_WITH_NO_WIDTH");
        this.checkCalculationException("testTable11", "Error.SemanticError.TABLE_NO_COLUMN_FOUND");
        this.checkWidthCalculation("testTable12", "4in");
        this.checkWidthCalculation("testTable13", "4in");
        this.checkWidthCalculation("testTable14", "8in");
        this.designHandle.setImageDPI(0);
        this.checkWidthCalculation("testTable12", "2.5in");
        this.checkWidthCalculation("testTable13", "2.5in");
        this.checkWidthCalculation("testTable14", "5in");
        this.checkWidthCalculation("testTable12", "2in", 150);
        this.checkWidthCalculation("testTable13", "2in", 150);
        this.checkWidthCalculation("testTable14", "4in", 150);
    }

    private void checkWidthCalculation(String tableName) throws SemanticException {
        this.checkWidthCalculation(tableName, null, -1);
    }

    private void checkWidthCalculation(String tableName, String expectedWidth) throws SemanticException {
        this.checkWidthCalculation(tableName, expectedWidth, -1);
    }

    private void checkWidthCalculation(String tableName, String expectedWidth, int dpi) throws SemanticException {
        TableHandle table = (TableHandle)this.designHandle.findElement(tableName);
        TableItemHandleTest.assertNotNull((Object)table);
        if (expectedWidth == null) {
            TableItemHandleTest.assertTrue((boolean)(table.getWidth().getValue() instanceof DimensionValue));
            expectedWidth = table.getWidth().getValue().toString();
        }
        if (dpi == -1) {
            table.setWidthToFitColumns();
        } else {
            table.setWidthToFitColumns(dpi);
        }
        TableItemHandleTest.assertEquals((String)expectedWidth, (String)table.getWidth().getValue().toString());
    }

    private void checkCalculationException(String tableName, String expectedErrorCode) {
        TableHandle table = (TableHandle)this.designHandle.findElement(tableName);
        try {
            table.setWidthToFitColumns();
            TableItemHandleTest.fail((String)(String.valueOf(expectedErrorCode) + " expected!"));
        }
        catch (SemanticException e) {
            TableItemHandleTest.assertEquals((String)expectedErrorCode, (String)e.getErrorCode());
            System.out.println(e.getLocalizedMessage());
        }
    }
}

