/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CssEvent;
import org.eclipse.birt.report.model.api.command.CssReloadedEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CssCommandTest
extends BaseTestCase {
    public void testUndoAddAndDropCss() throws Exception {
        this.openDesign("BlankReportDesign.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        CssCommandTest.assertEquals((String)"left", (String)labelHandle.getStyle().getTextAlign());
        CssStyleSheetHandle sheetHandle = this.designHandle.openCssStyleSheet("reslove.css");
        this.designHandle.addCss(sheetHandle);
        CssCommandTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        this.designHandle.getCommandStack().undo();
        CssCommandTest.assertEquals((String)"left", (String)labelHandle.getStyle().getTextAlign());
        this.designHandle.getCommandStack().redo();
        CssCommandTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        this.designHandle.dropCss(sheetHandle);
        CssCommandTest.assertEquals((String)"left", (String)labelHandle.getStyle().getTextAlign());
        this.designHandle.getCommandStack().undo();
        CssCommandTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        this.designHandle.getCommandStack().redo();
        CssCommandTest.assertEquals((String)"left", (String)labelHandle.getStyle().getTextAlign());
    }

    public void testUndoReloadCss() throws Exception {
        this.openDesign("CssCommandTest_Reload.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        CssCommandTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        CssStyleSheetHandle sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        this.designHandle.reloadCss(sheetHandle);
        CssCommandTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        CssCommandTest.assertEquals((String)"base.css", (String)sheetHandle.getFileName());
        CssCommandTest.assertFalse((boolean)this.designHandle.needsSave());
        CssCommandTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        CssCommandTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
    }

    public void testAdd() throws Exception {
        this.openDesign("BlankReportDesign.xml");
        MyListener listener = new MyListener();
        this.designHandle.addListener((Listener)listener);
        CssStyleSheetHandle sheetHandle = this.designHandle.openCssStyleSheet("reslove.css");
        this.designHandle.addCss(sheetHandle);
        CssCommandTest.assertEquals((int)22, (int)listener.getEventType());
        CssCommandTest.assertEquals((int)1, (int)listener.getAction());
        CssCommandTest.assertEquals((int)1, (int)listener.getEventCount());
        listener.clearEventCount();
        sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        this.designHandle.reloadCss(sheetHandle);
        CssCommandTest.assertEquals((int)21, (int)listener.getEventType());
        CssCommandTest.assertEquals((int)1, (int)listener.getEventCount());
        listener.clearEventCount();
        sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        this.designHandle.dropCss(sheetHandle);
        CssCommandTest.assertEquals((int)2, (int)listener.getAction());
        CssCommandTest.assertEquals((int)1, (int)listener.getEventCount());
    }

    class MyListener
    implements Listener {
        int action = 1;
        int eventType = 22;
        int count = 0;

        MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 22) {
                CssEvent event = (CssEvent)ev;
                this.action = event.getAction();
                this.eventType = event.getEventType();
                ++this.count;
            } else if (ev.getEventType() == 21) {
                CssReloadedEvent event = (CssReloadedEvent)ev;
                this.eventType = event.getEventType();
                ++this.count;
            }
        }

        public int getEventCount() {
            return this.count;
        }

        public void clearEventCount() {
            this.count = 0;
        }

        public int getAction() {
            return this.action;
        }

        public int getEventType() {
            return this.eventType;
        }
    }
}

