/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.command.CircularExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ExtendsExceptionTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        this.os = new ByteArrayOutputStream();
        table.setName("customerTable");
        GridItem parent = new GridItem();
        parent.setName("parentGrid");
        String extendsName = "parentTable";
        InvalidParentException error = new InvalidParentException((DesignElement)table, extendsName, "Error.InvalidParentException.PARENT_NOT_FOUND");
        this.print((ExtendsException)error);
        error = new WrongTypeException((DesignElement)table, (DesignElement)parent, "Error.WrongTypeException.WRONG_TYPE");
        this.print((ExtendsException)error);
        error = new ExtendsForbiddenException((DesignElement)table, extendsName, "Error.ExtendsForbiddenException.CANT_EXTEND");
        this.print((ExtendsException)error);
        error = new CircularExtendsException((DesignElement)table, extendsName, "Error.CircularExtendsException.SELF_EXTEND");
        this.print((ExtendsException)error);
        error = new CircularExtendsException((DesignElement)table, (DesignElement)parent, "Error.CircularExtendsException.CIRCULAR");
        this.print((ExtendsException)error);
        error = new InvalidParentException((DesignElement)table, extendsName, "Error.InvalidParentException.UNNAMED_PARENT");
        this.print((ExtendsException)error);
        error = new ExtendsForbiddenException((DesignElement)table, extendsName, "Error.ExtendsForbiddenException.PARENT_NOT_IN_COMPONENT");
        this.print((ExtendsException)error);
        this.os.close();
        ExtendsExceptionTest.assertTrue((boolean)this.compareFile("ExtendsExceptionError.golden.txt"));
    }

    private void print(ExtendsException error) {
        block3: {
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

