/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.UserPropertyEvent;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.FloatPropertyType;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class UserPropertyCommandTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testAddUserProperty() throws Exception {
        this.openDesign("UserPropertyCommandTest.xml", TEST_LOCALE);
        UserPropertyCommandTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("My Data");
        String propValue = (String)dataHandle.getProperty("myProp2");
        UserPropertyCommandTest.assertEquals((String)"choiceOne", (String)propValue);
        dataHandle.setProperty("myProp2", (Object)"\u4e00");
        UserPropertyCommandTest.assertEquals((String)"choiceOne", (String)dataHandle.getStringProperty("myProp2"));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        PropertyType intType = dd.getPropertyType(2);
        UserPropertyDefn newPropDefn = new UserPropertyDefn();
        newPropDefn.setName("myProp4");
        newPropDefn.setType(intType);
        dataHandle.addUserPropertyDefn(newPropDefn);
        UserPropertyDefnHandle newPropDefnHandle = dataHandle.getUserPropertyDefnHandle("myProp4");
        UserPropertyCommandTest.assertNotNull((Object)newPropDefnHandle);
        UserPropertyCommandTest.assertEquals((int)intType.getTypeCode(), (int)newPropDefnHandle.getType());
        try {
            dataHandle.addUserPropertyDefn(newPropDefn);
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.DUPLICATE_NAME", (String)e.getErrorCode());
        }
        UserPropertyDefn upd = (UserPropertyDefn)dataHandle.getPropertyHandle("myProp1").getDefn();
        try {
            this.designHandle.addUserPropertyDefn(upd);
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException upe) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.INVALID_DISPLAY_ID", (String)upe.getErrorCode());
        }
        newPropDefn = new UserPropertyDefn();
        newPropDefn.setName("uProperty");
        newPropDefn.setType(dd.getPropertyType(17));
        try {
            dataHandle.addUserPropertyDefn(newPropDefn);
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.INVALID_TYPE", (String)e.getErrorCode());
        }
        newPropDefn = new UserPropertyDefn();
        newPropDefn.setName("uProperty");
        newPropDefn.setType(dd.getPropertyType(2));
        newPropDefn.setDefault((Object)"wInteger");
        try {
            dataHandle.addUserPropertyDefn(newPropDefn);
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.INVALID_DEFAULT_VALUE", (String)e.getErrorCode());
        }
    }

    public void testDropUserProperty() throws Exception {
        this.openDesign("UserPropertyCommandTest.xml");
        UserPropertyCommandTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("My Data");
        UserPropertyCommandTest.assertNotNull((Object)dataHandle);
        UserPropertyCommandTest.assertEquals((String)"choiceOne", (String)dataHandle.getStringProperty("myProp2"));
        dataHandle.dropUserPropertyDefn("myProp2");
        UserPropertyDefnHandle userPropHandle = dataHandle.getUserPropertyDefnHandle("myProp2");
        UserPropertyCommandTest.assertNull((Object)userPropHandle);
        try {
            dataHandle.dropUserPropertyDefn("prop");
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.NOT_FOUND", (String)e.getErrorCode());
        }
        try {
            this.designHandle.dropUserPropertyDefn("prop");
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.NOT_FOUND", (String)e.getErrorCode());
        }
        DataItemHandle parentDataHandle = (DataItemHandle)this.designHandle.findElement("base data");
        DataItemHandle childDataHandle = (DataItemHandle)this.designHandle.findElement("child data");
        UserPropertyCommandTest.assertNotNull((Object)parentDataHandle.getUserPropertyDefnHandle("stringProp"));
        UserPropertyCommandTest.assertNotNull((Object)childDataHandle.getUserPropertyDefnHandle("stringProp"));
        UserPropertyCommandTest.assertNotNull((Object)childDataHandle.getProperty("stringProp"));
        parentDataHandle.dropUserPropertyDefn("stringProp");
        UserPropertyCommandTest.assertNull((Object)parentDataHandle.getUserPropertyDefnHandle("stringProp"));
        UserPropertyCommandTest.assertNull((Object)childDataHandle.getUserPropertyDefnHandle("stringProp"));
        UserPropertyCommandTest.assertNull((Object)childDataHandle.getProperty("stringProp"));
    }

    public void testSetUserPropertyDefn() throws Exception {
        this.openDesign("UserPropertyCommandTest.xml");
        UserPropertyCommandTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("My Data");
        UserPropertyCommandTest.assertNotNull((Object)dataHandle);
        UserPropertyDefn old = (UserPropertyDefn)dataHandle.getPropertyHandle("myProp1").getDefn();
        UserPropertyCommand updCommand = new UserPropertyCommand((Module)this.design, dataHandle.getElement());
        UserPropertyDefn newProp = new UserPropertyDefn();
        newProp.setName("upd");
        FloatPropertyType type = new FloatPropertyType();
        newProp.setType((PropertyType)type);
        try {
            updCommand.setPropertyDefn(old, newProp);
            UserPropertyCommandTest.fail();
        }
        catch (PropertyValueException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        old = (UserPropertyDefn)dataHandle.getPropertyHandle("myProp2").getDefn();
        double value = dataHandle.getFloatProperty("myProp2");
        newProp.setName("updNew");
        try {
            updCommand.setPropertyDefn(old, newProp);
            UserPropertyCommandTest.fail();
        }
        catch (PropertyValueException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        UserPropertyCommandTest.assertEquals((String)new Double(value).toString(), (String)new Double(dataHandle.getFloatProperty("updNew")).toString());
        newProp = new UserPropertyDefn();
        try {
            updCommand.setPropertyDefn(old, newProp);
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.NAME_REQUIRED", (String)e.getErrorCode());
        }
        old.setName("notExists");
        try {
            updCommand.setPropertyDefn(old, newProp);
            UserPropertyCommandTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyCommandTest.assertEquals((String)"Error.UserPropertyException.NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testNotification() throws DesignFileException, SemanticException {
        this.openDesign("UserPropertyCommandTest.xml", ULocale.CHINA);
        MyUserPropertyListener listener = new MyUserPropertyListener();
        MyPropertyListener propertyListener = new MyPropertyListener();
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        PropertyType stringType = dd.getPropertyType(0);
        UserPropertyDefn userPropDefn = new UserPropertyDefn();
        userPropDefn.setName("UP1");
        userPropDefn.setType(stringType);
        userPropDefn.setDisplayName("Property 1");
        FreeFormHandle freeForm = this.designHandle.getElementFactory().newFreeForm("F1");
        this.designHandle.getBody().add((DesignElementHandle)freeForm);
        freeForm.addListener((Listener)listener);
        freeForm.addListener((Listener)propertyListener);
        listener.action = 0;
        propertyListener.propertyChanged = false;
        freeForm.addUserPropertyDefn(userPropDefn);
        UserPropertyCommandTest.assertEquals((int)1, (int)listener.action);
        UserPropertyCommandTest.assertFalse((boolean)propertyListener.propertyChanged);
        listener.action = 0;
        propertyListener.propertyChanged = false;
        freeForm.setProperty(userPropDefn.getName(), (Object)"123");
        UserPropertyCommandTest.assertEquals((int)0, (int)listener.action);
        UserPropertyCommandTest.assertTrue((boolean)propertyListener.propertyChanged);
        listener.action = 0;
        propertyListener.propertyChanged = false;
        freeForm.dropUserPropertyDefn(userPropDefn.getName());
        UserPropertyCommandTest.assertEquals((int)2, (int)listener.action);
        UserPropertyCommandTest.assertTrue((boolean)propertyListener.propertyChanged);
    }

    class MyPropertyListener
    implements Listener {
        boolean propertyChanged = false;

        MyPropertyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 5) {
                this.propertyChanged = true;
            }
        }
    }

    class MyUserPropertyListener
    implements Listener {
        static final int NA = 0;
        static final int ADDED = 1;
        static final int REMOVED = 2;
        static final int CHANGED = 3;
        UserPropertyEvent event = null;
        int action = 0;

        MyUserPropertyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 7) {
                this.event = (UserPropertyEvent)ev;
                if (this.action == 1 && this.event.getAction() == 1) {
                    this.action = 3;
                } else {
                    switch (this.event.getAction()) {
                        case 0: {
                            this.action = 1;
                            break;
                        }
                        case 1: {
                            this.action = 2;
                        }
                    }
                }
            }
        }
    }
}

